/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import java.util.Collections;
import java.util.List;
import org.teiid.language.Call;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.swagger.SwaggerMetadataProcessor;
import org.teiid.translator.swagger.SwaggerProcedureExecution;
import org.teiid.translator.ws.WSConnection;

@Translator(name="swagger", description="A translator for making swagger based data service call")
public class SwaggerExecutionFactory
extends ExecutionFactory<ConnectionFactory, WSConnection> {
    public SwaggerExecutionFactory() {
        this.setSourceRequiredForMetadata(true);
        this.setSupportsOrderBy(false);
        this.setSupportsSelectDistinct(false);
        this.setSupportsInnerJoins(false);
        this.setSupportsFullOuterJoins(false);
        this.setSupportsOuterJoins(false);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        return new SwaggerProcedureExecution(command, this, executionContext, metadata, connection);
    }

    public final List<String> getSupportedFunctions() {
        return Collections.emptyList();
    }

    public MetadataProcessor<WSConnection> getMetadataProcessor() {
        return new SwaggerMetadataProcessor(this);
    }
}

