/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.language.Argument;
import org.teiid.language.Array;
import org.teiid.language.Call;
import org.teiid.language.Expression;
import org.teiid.language.Literal;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RestMetadataExtension;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.swagger.BaseQueryExecution;
import org.teiid.translator.swagger.JsonSerializer;
import org.teiid.translator.swagger.SwaggerBodyInputDocument;
import org.teiid.translator.swagger.SwaggerPlugin;
import org.teiid.translator.swagger.SwaggerResponse;
import org.teiid.translator.swagger.SwaggerSerializer;
import org.teiid.translator.swagger.SwaggerTypeManager;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;
import org.teiid.util.WSUtil;

public class SwaggerProcedureExecution
extends BaseQueryExecution
implements ProcedureExecution {
    private Object returnValue;
    private SwaggerResponse response;
    private Class<?>[] expectedColumnTypes;
    private Call command;
    private Map<String, Object> responseHeaders;

    public SwaggerProcedureExecution(Call command, ExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        super(translator, executionContext, metadata, connection);
        this.command = command;
        this.expectedColumnTypes = command.getResultSetColumnTypes();
    }

    private ProcedureParameter getReturnParameter() {
        for (ProcedureParameter pp : this.command.getMetadataObject().getParameters()) {
            if (pp.getType() != ProcedureParameter.Type.ReturnValue) continue;
            return pp;
        }
        return null;
    }

    private BinaryWSProcedureExecution buildWSExecution(Call obj) throws TranslatorException {
        String consumes;
        Procedure procedure = obj.getMetadataObject();
        String uri = procedure.getProperty("teiid_rest:URI", false);
        String method = procedure.getProperty("teiid_rest:METHOD", false);
        StringBuilder queryParameters = new StringBuilder();
        StringBuilder formParameters = new StringBuilder();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        String payload = null;
        SwaggerBodyInputDocument input = null;
        List params = obj.getArguments();
        if (params != null && params.size() != 0) {
            Argument param = null;
            for (int i = 0; i < params.size(); ++i) {
                param = (Argument)params.get(i);
                ProcedureParameter metadata = param.getMetadataObject();
                String argName = WSUtil.httpURLEncode((String)param.getMetadataObject().getName());
                if (param.getDirection() == Argument.Direction.IN || param.getDirection() == Argument.Direction.INOUT) {
                    String argValue;
                    Expression value;
                    String in = metadata.getProperty("teiid_rest:PARAMETER_TYPE", false);
                    if (in.equalsIgnoreCase(RestMetadataExtension.ParameterType.QUERY.name())) {
                        if (queryParameters.length() != 0) {
                            queryParameters.append("&");
                        }
                        if ((value = param.getExpression()) instanceof Array) {
                            this.addArgumentValue(argName, (Array)value, metadata.getProperty("teiid_rest:COLLECION_FORMAT", false), queryParameters);
                            continue;
                        }
                        String argValue2 = this.getURLValue((Literal)value);
                        queryParameters.append(argName);
                        queryParameters.append("=");
                        queryParameters.append(argValue2);
                        continue;
                    }
                    if (in.equalsIgnoreCase(RestMetadataExtension.ParameterType.PATH.name())) {
                        argValue = this.getURLValue(param.getArgumentValue());
                        String regex = "\\{" + argName + "\\}";
                        uri = uri.replaceAll(regex, argValue);
                        continue;
                    }
                    if (in.equalsIgnoreCase(RestMetadataExtension.ParameterType.FORM.name()) || in.equalsIgnoreCase(RestMetadataExtension.ParameterType.FORMDATA.name())) {
                        if (formParameters.length() != 0) {
                            formParameters.append("&");
                        }
                        if ((value = param.getExpression()) instanceof Array) {
                            this.addArgumentValue(argName, (Array)value, metadata.getProperty("teiid_rest:COLLECION_FORMAT", false), formParameters);
                            continue;
                        }
                        formParameters.append(argName);
                        formParameters.append("=");
                        formParameters.append(this.getURLValue((Literal)value));
                        continue;
                    }
                    if (in.equalsIgnoreCase(RestMetadataExtension.ParameterType.BODY.name())) {
                        Object expr;
                        if (input == null) {
                            input = new SwaggerBodyInputDocument();
                        }
                        if ((expr = param.getExpression()) instanceof Literal) {
                            expr = ((Literal)expr).getValue();
                        }
                        input.addArgument(param.getMetadataObject(), expr);
                        continue;
                    }
                    if (!in.equalsIgnoreCase(RestMetadataExtension.ParameterType.HEADER.name())) continue;
                    argValue = param.getArgumentValue().getValue().toString();
                    headers.put(argName, Arrays.asList(argValue));
                    continue;
                }
                throw new TranslatorException("Not supported parameter");
            }
        }
        if ((consumes = procedure.getProperty("teiid_rest:CONSUMES", false)) == null) {
            consumes = "application/json";
        }
        if (input != null) {
            try {
                SwaggerSerializer serializer = SwaggerProcedureExecution.getSerializer(consumes);
                InputStream oos = serializer.serialize(input);
                payload = ObjectConverterUtil.convertToString((InputStream)oos);
            }
            catch (IOException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        if (payload == null && formParameters.length() > 0) {
            payload = formParameters.toString();
        }
        headers.put("Content-Type", Arrays.asList(consumes));
        String produces = procedure.getProperty("teiid_rest:PRODUCES", false);
        if (produces == null) {
            produces = "application/json";
        }
        headers.put("Accept", Arrays.asList(produces));
        if (queryParameters.length() > 0) {
            uri = uri + "?" + queryParameters;
        }
        return this.buildInvokeHTTP(method, uri, payload, headers);
    }

    private String getURLValue(Literal value) {
        if (value.getValue() == null) {
            throw new TeiidRuntimeException("Null is not supported");
        }
        return WSUtil.httpURLEncode((String)value.getValue().toString());
    }

    private void addArgumentValue(String argName, Array value, String collectionFormat, StringBuilder queryStr) {
        List exprs = value.getExpressions();
        if (collectionFormat.equalsIgnoreCase("multi")) {
            for (int i = 0; i < exprs.size(); ++i) {
                if (i > 0) {
                    queryStr.append("&");
                }
                queryStr.append(argName);
                queryStr.append("=");
                Literal l = (Literal)exprs.get(i);
                queryStr.append(this.getURLValue(l));
            }
        } else {
            String delimiter = ",";
            if (collectionFormat.equalsIgnoreCase("csv")) {
                delimiter = ",";
            } else if (collectionFormat.equalsIgnoreCase("ssv")) {
                delimiter = " ";
            } else if (collectionFormat.equalsIgnoreCase("tsv")) {
                delimiter = "\t";
            } else if (collectionFormat.equalsIgnoreCase("pipes")) {
                delimiter = "|";
            }
            queryStr.append(argName);
            queryStr.append("=");
            for (int i = 0; i < exprs.size(); ++i) {
                Literal l = (Literal)exprs.get(i);
                if (i > 0) {
                    queryStr.append(delimiter);
                }
                queryStr.append(this.getURLValue(l));
            }
        }
    }

    public void execute() throws TranslatorException {
        Procedure procedure = this.command.getMetadataObject();
        BinaryWSProcedureExecution execution = this.buildWSExecution(this.command);
        execution.execute();
        if (execution.getResponseCode() >= 200 && execution.getResponseCode() < 300) {
            this.responseHeaders = execution.getResponseHeaders();
            if (procedure.getResultSet() != null) {
                if (((Column)procedure.getResultSet().getColumns().get(0)).getName().equals("return")) {
                    this.returnValue = this.getReturnValue(execution);
                } else {
                    try {
                        Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                        InputStream wsResponse = blob.getBinaryStream();
                        Object obj = execution.getResponseHeader("Content-Type");
                        if (obj == null) {
                            throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28017, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28017, new Object[]{"Not Defined"}));
                        }
                        List contentType = (List)obj;
                        SwaggerSerializer serializer = SwaggerProcedureExecution.getSerializer(contentType.get(0).toString());
                        if (serializer == null) {
                            throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28017, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28017, new Object[]{obj.toString()}));
                        }
                        this.handleResponse(procedure, wsResponse, execution.getResponseHeaders(), serializer);
                    }
                    catch (SQLException e) {
                        throw new TranslatorException((Throwable)e);
                    }
                }
            } else if (this.getReturnParameter() != null) {
                this.returnValue = this.getReturnValue(execution);
            }
        } else if (execution.getResponseCode() != 404) {
            throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28018, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28018, new Object[]{execution.getResponseCode()}));
        }
    }

    private String getReturnValue(BinaryWSProcedureExecution execution) throws TranslatorException {
        try {
            return ObjectConverterUtil.convertToString((InputStream)((Blob)execution.getOutputParameterValues().get(0)).getBinaryStream());
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public static SwaggerSerializer getSerializer(String contentType) {
        ContentType type = ContentType.parse(contentType);
        if (type.isJSON()) {
            return new JsonSerializer();
        }
        if (type.isXML()) {
            throw new AssertionError((Object)"XML Not supported");
        }
        return null;
    }

    private void handleResponse(Procedure procedure, InputStream payload, Map<String, Object> headers, SwaggerSerializer serializer) throws TranslatorException {
        this.response = new SwaggerResponse(payload, headers, serializer, this.isMapResponse(procedure));
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        Map<String, Object> row;
        Procedure procedure = this.command.getMetadataObject();
        if (this.response != null && (row = this.response.getNext()) != null) {
            row.putAll(this.responseHeaders);
            return this.buildRow(procedure.getResultSet().getColumns(), this.response.isMapResponse(), this.expectedColumnTypes, row);
        }
        if (this.returnValue != null) {
            row = new LinkedHashMap<String, Object>();
            row.put("return", SwaggerTypeManager.convertTeiidRuntimeType(this.returnValue, this.expectedColumnTypes[0]));
            row.putAll(this.responseHeaders);
            this.returnValue = null;
            return this.buildRow(procedure.getResultSet().getColumns(), false, this.expectedColumnTypes, row);
        }
        return null;
    }

    private boolean isMapResponse(Procedure procedure) {
        ColumnSet columnSet = procedure.getResultSet();
        if (columnSet == null) {
            return false;
        }
        List columns = columnSet.getColumns();
        return columns.size() >= 2 && ((Column)columns.get(0)).getName().equals("key_name") && ((Column)columns.get(1)).getName().equals("key_value");
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return Arrays.asList(this.returnValue);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    private static class ContentType {
        private static String APPLICATION = "application";
        private static String TYPE_JSON = "json";
        private static String TYPE_XML = "xml";
        private String major;
        private String subtype;

        ContentType(String major, String subtype) {
            this.major = major;
            this.subtype = subtype;
        }

        public boolean isJSON() {
            return this.major != null && this.subtype != null && this.major.equals(APPLICATION) && this.subtype.equals(TYPE_JSON);
        }

        public boolean isXML() {
            return this.major != null && this.subtype != null && this.major.equals(APPLICATION) && this.subtype.equals(TYPE_XML);
        }

        public static ContentType parse(String type) {
            int typeIndex = type.indexOf(47);
            int paramIndex = type.indexOf(59);
            String major = null;
            String subtype = null;
            if (typeIndex > 0) {
                major = type.substring(0, typeIndex);
                subtype = paramIndex > -1 ? type.substring(typeIndex + 1, paramIndex) : type.substring(typeIndex + 1);
            }
            return new ContentType(major, subtype);
        }
    }
}

