/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.swagger.SwaggerPlugin;

public class SwaggerTypeManager {
    private static Pattern timestampPattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})[T|t](\\d{2}):(\\d{2}):(\\d{2})(\\.\\d{1})?([Z|z]|([+|-](\\d{2}):(\\d{2})))");
    private static final String INTEGER = "integer";
    private static final String INTEGER_ = SwaggerTypeManager.typeFormat("integer", "int32");
    private static final String LONG = "long";
    private static final String LONG_ = SwaggerTypeManager.typeFormat("integer", "int64");
    private static final String FLOAT = "float";
    private static final String FLOAT_ = SwaggerTypeManager.typeFormat("number", "float");
    private static final String DOUBLE = "double";
    private static final String DOUBLE_ = SwaggerTypeManager.typeFormat("number", "double");
    private static final String STRING = "string";
    private static final String STRING_ = SwaggerTypeManager.typeFormat("string", "");
    private static final String BYTE = "byte";
    private static final String BYTE_ = SwaggerTypeManager.typeFormat("string", "byte");
    private static final String BINARY = "binary";
    private static final String BINARY_ = SwaggerTypeManager.typeFormat("string", "binary");
    private static final String BOOLEAN = "boolean";
    private static final String BOOLEAN_ = SwaggerTypeManager.typeFormat("boolean", "");
    private static final String DATE = "date";
    private static final String DATE_ = SwaggerTypeManager.typeFormat("string", "date");
    private static final String DATETIME = "dateTime";
    private static final String DATETIME_ = SwaggerTypeManager.typeFormat("string", "date-time");
    private static final String PASSWORD = "password";
    private static final String PASSWORD_ = SwaggerTypeManager.typeFormat("string", "password");
    private static final String OBJECT = SwaggerTypeManager.typeFormat("array", "");
    private static HashMap<String, String> swaggerTypes = new HashMap();

    static String typeFormat(String type, String format) {
        return type + "/" + format;
    }

    static String teiidType(String name) {
        String type = swaggerTypes.get(name);
        if (type == null) {
            type = STRING;
        }
        return type;
    }

    public static String teiidType(String type, String format, boolean array) {
        String returnType;
        if (null == format) {
            format = "";
        }
        if (null == (returnType = swaggerTypes.get(SwaggerTypeManager.typeFormat(type, format)))) {
            returnType = STRING;
        }
        if (array) {
            returnType = returnType + "[]";
        }
        return returnType;
    }

    public static Object convertTeiidRuntimeType(Object value, Class<?> expectedType) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (expectedType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (expectedType.isAssignableFrom(Timestamp.class) && value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (expectedType.isAssignableFrom(Timestamp.class) && value instanceof String) {
            return SwaggerTypeManager.formTimestamp((String)value);
        }
        if (expectedType.isAssignableFrom(java.util.Date.class) && value instanceof Long) {
            return new java.util.Date((Long)value);
        }
        if (expectedType.isAssignableFrom(java.util.Date.class) && value instanceof String) {
            return SwaggerTypeManager.formDate((String)value);
        }
        if (expectedType.isArray() && value instanceof List) {
            List values = (List)value;
            Class<?> expectedArrayComponentType = expectedType.getComponentType();
            Object array = Array.newInstance(expectedArrayComponentType, values.size());
            for (int i = 0; i < values.size(); ++i) {
                Object arrayItem = SwaggerTypeManager.convertTeiidRuntimeType(values.get(i), expectedArrayComponentType);
                Array.set(array, i, arrayItem);
            }
            return array;
        }
        Transform transform = DataTypeManager.getTransform(value.getClass(), expectedType);
        if (transform != null) {
            try {
                value = transform.transform(value, expectedType);
            }
            catch (TransformationException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        return value;
    }

    static Date formDate(String value) throws TranslatorException {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            return new Date(formatter.parse(value).getTime());
        }
        catch (ParseException e) {
            throw new TranslatorException((Throwable)e, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28012, new Object[0]));
        }
    }

    static Timestamp formTimestamp(String value) throws TranslatorException {
        Matcher m = timestampPattern.matcher(value);
        if (m.matches()) {
            Calendar cal = null;
            String timeZone = m.group(8);
            cal = timeZone.equalsIgnoreCase("Z") ? Calendar.getInstance(TimeZone.getTimeZone("GMT")) : Calendar.getInstance(TimeZone.getTimeZone("GMT" + m.group(9)));
            cal.set(Integer.valueOf(m.group(1)), Integer.valueOf(m.group(2)) - 1, Integer.valueOf(m.group(3)), Integer.valueOf(m.group(4)), Integer.valueOf(m.group(5)), Integer.valueOf(m.group(6)));
            Timestamp ts = new Timestamp(cal.getTime().getTime());
            if (m.group(7) != null) {
                String fraction = m.group(7).substring(1);
                ts.setNanos(Integer.parseInt(fraction));
            } else {
                ts.setNanos(0);
            }
            return ts;
        }
        throw new TranslatorException(SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28011, new Object[]{timestampPattern}));
    }

    static String timestampToString(Timestamp ts) {
        SimpleDateFormat timestampSDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SZ");
        if (ts == null) {
            return null;
        }
        String str = timestampSDF.format(ts);
        if (str.endsWith("+0000")) {
            str = str.replace("+0000", "Z");
        }
        return str;
    }

    static String dateToString(Date date) {
        SimpleDateFormat dateSDF = new SimpleDateFormat("yyyy-MM-dd");
        if (date == null) {
            return null;
        }
        return dateSDF.format(date);
    }

    static {
        swaggerTypes.put(INTEGER, INTEGER);
        swaggerTypes.put(INTEGER_, INTEGER);
        swaggerTypes.put(LONG, LONG);
        swaggerTypes.put(LONG_, LONG);
        swaggerTypes.put(FLOAT, FLOAT);
        swaggerTypes.put(FLOAT_, FLOAT);
        swaggerTypes.put(DOUBLE, DOUBLE);
        swaggerTypes.put(DOUBLE_, DOUBLE);
        swaggerTypes.put(STRING, STRING);
        swaggerTypes.put(STRING_, STRING);
        swaggerTypes.put(BYTE, BYTE);
        swaggerTypes.put(BYTE_, BYTE);
        swaggerTypes.put(BINARY, "blob");
        swaggerTypes.put(BINARY_, "blob");
        swaggerTypes.put(BOOLEAN, BOOLEAN);
        swaggerTypes.put(BOOLEAN_, BOOLEAN);
        swaggerTypes.put(DATE, DATE);
        swaggerTypes.put(DATE_, DATE);
        swaggerTypes.put(DATETIME, "timestamp");
        swaggerTypes.put(DATETIME_, "timestamp");
        swaggerTypes.put(PASSWORD, STRING);
        swaggerTypes.put(PASSWORD_, STRING);
        swaggerTypes.put(OBJECT, "object");
    }
}

