/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.DataSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.swagger.JsonSerializer;
import org.teiid.translator.swagger.SwaggerExecutionFactory;
import org.teiid.translator.swagger.SwaggerProcedureExecution;
import org.teiid.translator.swagger.TestSwaggerMetadataProcessor;
import org.teiid.translator.ws.WSConnection;

public class TestSwaggerQueryExecution {
    private ProcedureExecution helpProcedureExecute(String query, String resultJson, String expectedURL, int responseCode) throws Exception {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        return this.helpProcedureExecute(query, resultJson, expectedURL, responseCode, true, "GET", null, headers);
    }

    private ProcedureExecution helpProcedureExecute(String query, final String resultJson, String expectedURL, int responseCode, boolean decode, String expectedMethod, String expectedInput, Map<String, Object> userHeaders) throws Exception {
        userHeaders.put("javax.xml.ws.http.request.headers", new HashMap());
        userHeaders.put("status-code", new Integer(responseCode));
        userHeaders.put("Content-Type", Arrays.asList("application/json"));
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)TestSwaggerMetadataProcessor.getTransformationMetadata(TestSwaggerMetadataProcessor.petstoreMetadata(translator), translator));
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WSConnection connection = (WSConnection)Mockito.mock(WSConnection.class);
        Dispatch dispatch = (Dispatch)Mockito.mock(Dispatch.class);
        Mockito.stub((Object)dispatch.getRequestContext()).toReturn(userHeaders);
        Mockito.stub((Object)dispatch.getResponseContext()).toReturn(userHeaders);
        Mockito.stub((Object)connection.createDispatch((String)Mockito.eq((Object)"http://www.w3.org/2004/08/wsdl/http"), Mockito.anyString(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE))).toReturn((Object)dispatch);
        DataSource outputDS = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream();
            }

            public String getName() {
                return "result";
            }

            public InputStream getInputStream() throws IOException {
                ByteArrayInputStream in = new ByteArrayInputStream(resultJson.getBytes());
                return in;
            }

            public String getContentType() {
                return "application/json";
            }
        };
        Mockito.stub((Object)((DataSource)dispatch.invoke((Object)((DataSource)Mockito.any(DataSource.class))))).toReturn((Object)outputDS);
        ProcedureExecution execution = translator.createProcedureExecution((Call)cmd, context, utility.createRuntimeMetadata(), connection);
        execution.execute();
        ArgumentCaptor endpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor binding = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor input = ArgumentCaptor.forClass(DataSource.class);
        ((WSConnection)Mockito.verify((Object)connection)).createDispatch((String)binding.capture(), (String)endpoint.capture(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE));
        ((Dispatch)Mockito.verify((Object)dispatch)).invoke((Object)((DataSource)input.capture()));
        Assert.assertEquals((Object)expectedURL, (Object)(decode ? URLDecoder.decode((String)endpoint.getValue(), "utf-8") : endpoint.getValue()));
        Assert.assertEquals((Object)expectedMethod, dispatch.getRequestContext().get("javax.xml.ws.http.request.method"));
        if (expectedInput != null) {
            Assert.assertEquals((Object)expectedInput, (Object)ObjectConverterUtil.convertToString((InputStream)((DataSource)input.getValue()).getInputStream()));
        }
        return execution;
    }

    @Test
    public void testSimpleInputArray() throws Exception {
        String query = "exec findPetsByStatus(status=>('available',));";
        String expectedURL = "http://petstore.swagger.io/v2/pet/findByStatus?status=available";
        String response = "[\n  {\n\"id\": 7,\n    \"category\": {\n         \"id\": 4,\n         \"name\": \"Lions\"\n    },\n    \"name\": \"Lion 1\",\n    \"photoUrls\": [\n      \"url1\",\n      \"url2\"\n    ],\n    \"tags\": [\n      {\n        \"id\": 1,\n        \"name\": \"tag1\"\n      },\n      {\n        \"id\": 2,\n        \"name\": \"tag2\"\n      }\n    ],\n    \"status\": \"available\"\n  },\n  {\n    \"id\": 10008,\n    \"category\": {\n      \"id\": 0,\n      \"name\": \"string\"\n    },\n    \"name\": \"doggie\",\n    \"photoUrls\": [\n      \"string\"\n    ],\n    \"tags\": [\n      {\n        \"id\": 0,\n        \"name\": \"string\"\n      }\n    ],\n    \"status\": \"available\"\n  }]";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200);
        Assert.assertArrayEquals((Object[])new Object[]{7L, 4L, "Lions", "Lion 1", new String[]{"url1", "url2"}, 1L, "tag1", "available"}, (Object[])excution.next().toArray(new Object[8]));
        Assert.assertArrayEquals((Object[])new Object[]{7L, 4L, "Lions", "Lion 1", new String[]{"url1", "url2"}, 2L, "tag2", "available"}, (Object[])excution.next().toArray(new Object[8]));
        Assert.assertArrayEquals((Object[])new Object[]{10008L, 0L, "string", "doggie", new String[]{"string"}, 0L, "string", "available"}, (Object[])excution.next().toArray(new Object[8]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testPostBasedQuery() throws Exception {
        String query = "exec addPet(id=>99, category_id=>0,category_name=>'canine',name=>'nikky',photoUrls=>('photo1','photo2'),tags_tag_id=>0, tags_tag_name=>'doggie',status=>'available');";
        String expectedURL = "http://petstore.swagger.io/v2/pet";
        String response = "{\"id\":99,\"name\":\"nikky\",\"photoUrls\":[\"photo1\",\"photo2\"],\"status\":\"available\",\"category\":{\"id\":0,\"name\":\"canine\"},\"tags\":[{\"id\":0,\"name\":\"doggie\"}]}";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "POST", response, this.getHeaders());
    }

    @Test
    public void testMapReturn() throws Exception {
        String query = "exec getInventory();";
        String expectedURL = "http://petstore.swagger.io/v2/store/inventory";
        String response = "{\n  \"sold\": 6,\n  \"string\": 7,\n  \"pending\": 62,\n  \"available\": 891,\n  \"Live\": 7,\n  \"fulfilled\": 1\n}";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "GET", null, this.getHeaders());
        Assert.assertArrayEquals((Object[])new Object[]{"sold", 6}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"string", 7}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"pending", 62}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"available", 891}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"Live", 7}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"fulfilled", 1}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertNull((Object)excution.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeadersInResponseWithReturn() throws Exception {
        String query = "exec loginUser(username=>'foo',password=>'bar');";
        String expectedURL = "http://petstore.swagger.io/v2/user/login?username=foo&password=bar";
        String response = "sucess";
        TimeZone tz = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
            ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "GET", null, this.getHeaders());
            Assert.assertArrayEquals((Object[])new Object[]{"sucess", 1, new Timestamp(1460110463000L)}, (Object[])excution.next().toArray(new Object[3]));
            Assert.assertNull((Object)excution.next());
        }
        finally {
            TimeZone.setDefault(tz);
        }
    }

    @Test
    public void testParameterInPath() throws Exception {
        String query = "exec getPetById(petId=>687789);";
        String expectedURL = "http://petstore.swagger.io/v2/pet/687789";
        String response = "{\n  \"id\": 687789,\n  \"category\": {\n    \"id\": 0,\n    \"name\": \"Lions\"\n  },\n  \"name\": \"nikky\",\n  \"photoUrls\": [\n    \"url1\"\n  ],\n  \"tags\": [\n    {\n      \"id\": 1,\n      \"name\": \"tag1\"\n    }\n  ],\n  \"status\": \"sold\"\n}";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "GET", null, this.getHeaders());
        Assert.assertArrayEquals((Object[])new Object[]{687789L, 0L, "Lions", "nikky", new String[]{"url1"}, 1L, "tag1", "sold"}, (Object[])excution.next().toArray(new Object[8]));
        Assert.assertNull((Object)excution.next());
    }

    @Test(expected=TranslatorException.class)
    public void testErrorResponse() throws Exception {
        String query = "exec getPetById(petId=>687789);";
        String expectedURL = "http://petstore.swagger.io/v2/pet/687789";
        String response = "";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 400, true, "GET", null, this.getHeaders());
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testDefaultResponse() throws Exception {
        String query = "exec logoutUser();";
        String expectedURL = "http://petstore.swagger.io/v2/user/logout";
        String response = "";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "GET", null, this.getHeaders());
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testScalarResponse() throws Exception {
        String query = "exec loginStatus('foo');";
        String expectedURL = "http://petstore.swagger.io/v2/user/loginStatus?username=foo";
        String response = "foo";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "GET", null, this.getHeaders());
        Assert.assertEquals((Object)"foo", excution.getOutputParameterValues().get(0));
    }

    @Test(expected=TeiidRuntimeException.class)
    public void testNullParameter() throws Exception {
        String query = "exec loginStatus(null);";
        String expectedURL = null;
        String response = null;
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "GET", null, this.getHeaders());
    }

    @Test
    public void testOptionalParameter() throws Exception {
        String query = "exec updatePet(name=>'fido');";
        String expectedURL = "http://petstore.swagger.io/v2/pet";
        String response = "";
        ProcedureExecution excution = this.helpProcedureExecute(query, response, expectedURL, 200, true, "PUT", null, this.getHeaders());
    }

    private Map<String, Object> getHeaders() {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("javax.xml.ws.http.request.headers", new HashMap());
        headers.put("status-code", new Integer(200));
        headers.put("Content-Type", "application/json");
        headers.put("X-Rate-Limit", "1");
        headers.put("X-Expires-After", "2016-04-08T10:14:23Z");
        return headers;
    }

    @Test
    public void testGetSerializer() {
        Assert.assertTrue((boolean)(SwaggerProcedureExecution.getSerializer((String)"application/json") instanceof JsonSerializer));
        Assert.assertTrue((boolean)(SwaggerProcedureExecution.getSerializer((String)"application/json;charset=utf-8") instanceof JsonSerializer));
    }

    @Test(expected=AssertionError.class)
    public void testGetSerializerFails() {
        SwaggerProcedureExecution.getSerializer((String)"application/xml");
    }
}

