/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.openapi;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.converter.SwaggerConverter;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.RefUtils;
import java.io.InputStream;
import java.sql.Blob;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.openapi.OpenAPIExecutionFactory;
import org.teiid.translator.openapi.SchemaVisitor;
import org.teiid.translator.swagger.BaseQueryExecution;
import org.teiid.translator.swagger.SwaggerPlugin;
import org.teiid.translator.swagger.SwaggerTypeManager;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class OpenAPIMetadataProcessor
implements MetadataProcessor<WSConnection> {
    private static final String ARRAY_SUFFIX = "[]";
    public static final String KEY_NAME = "key_name";
    public static final String KEY_VALUE = "key_value";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="URI", description="Used to define endpoint of the procedure", required=true)
    public static final String URI = "teiid_rest:URI";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Http Method", description="Http method used to execute the procedure", required=true, allowed="GET,POST,PUT,DELETE,OPTIONS,HEAD,PATCH")
    public static final String METHOD = "teiid_rest:METHOD";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Produces", description="Used to define content type produced by this procedure, default JSON assumed")
    public static final String PRODUCES = "teiid_rest:PRODUCES";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Consumes", description="Used to define content type consumed by this procedure with body type parameters. Default JSON assumed")
    public static final String CONSUMES = "teiid_rest:CONSUMES";
    @ExtensionMetadataProperty(applicable={ProcedureParameter.class}, datatype=String.class, display="Parameter Type", description="Parameter type, as to how the parameter is being provided to the procedure", required=true, allowed="PATH,QUERY,FORM,FORMDATA,BODY,HEADER")
    public static final String PARAMETER_TYPE = "teiid_rest:PARAMETER_TYPE";
    @ExtensionMetadataProperty(applicable={ProcedureParameter.class}, datatype=String.class, display="Collection Format", description="Determines the format of the array if type array is used, like CSV,TSV etc.", allowed="CSV,SSV,TSV,PIPES,MULTI")
    public static final String COLLECION_FORMAT = "teiid_rest:COLLECION_FORMAT";
    private String metadataUrl;
    private String server;
    private String preferredProduces = "application/json";
    private String preferredConsumes = "application/json";
    private OpenAPIExecutionFactory ef;

    public OpenAPIMetadataProcessor(OpenAPIExecutionFactory ef) {
        this.ef = ef;
    }

    @TranslatorProperty(display="OpenAPI metadata URL", category=TranslatorProperty.PropertyType.IMPORT, description="OpenAPI metadata URL")
    public String getMetadataUrl() {
        return this.metadataUrl;
    }

    public void setMetadataUrl(String metadataUrl) {
        this.metadataUrl = metadataUrl;
    }

    @TranslatorProperty(display="Server", category=TranslatorProperty.PropertyType.IMPORT, description="Server to use when multiple servers are defined")
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    @TranslatorProperty(display="Preferred Accept Header", category=TranslatorProperty.PropertyType.IMPORT, description="Preferred Accept MIME type header, this should be one of the Swagger 'produces' types; default is application/json")
    public String getPreferredProduces() {
        return this.preferredProduces;
    }

    public void setPreferredProduces(String accept) {
        this.preferredProduces = accept;
    }

    @TranslatorProperty(display="Preferred Content-type Header", category=TranslatorProperty.PropertyType.IMPORT, description="Preferred Content-type header, this should be one of the Swagger 'consume' types, default is application/json")
    public String getPreferredConsumes() {
        return this.preferredConsumes;
    }

    public void setPreferredConsumes(String type) {
        this.preferredConsumes = type;
    }

    public void process(MetadataFactory mf, WSConnection connection) throws TranslatorException {
        SwaggerParseResult swagger = this.getSchema(connection);
        OpenAPI openapi = swagger.getOpenAPI();
        List messages = swagger.getMessages();
        if (messages != null && !messages.isEmpty()) {
            if (openapi == null) {
                throw new TranslatorException((String)messages.iterator().next());
            }
            LogManager.logInfo((String)"org.teiid.CONNECTOR", messages.iterator().next());
        }
        List servers = openapi.getServers();
        Server toUse = null;
        if (this.server != null) {
            for (Server s : servers) {
                if (!s.getUrl().equals(this.server)) continue;
                toUse = s;
                break;
            }
        } else {
            toUse = (Server)servers.iterator().next();
        }
        for (Map.Entry entry : openapi.getPaths().entrySet()) {
            this.addProcedure(mf, swagger, toUse, (String)entry.getKey(), (PathItem)entry.getValue());
        }
    }

    private String buildURL(String basePath, String endpoint) {
        if (endpoint.startsWith("/")) {
            if (basePath.endsWith("/")) {
                return basePath + endpoint.substring(1);
            }
            return basePath + endpoint;
        }
        if (basePath.endsWith("/")) {
            return basePath + endpoint;
        }
        return basePath + "/" + endpoint;
    }

    public static Map<PathItem.HttpMethod, Operation> getOperationMap(PathItem operations) {
        LinkedHashMap<PathItem.HttpMethod, Operation> result = new LinkedHashMap<PathItem.HttpMethod, Operation>();
        if (operations.getGet() != null) {
            result.put(PathItem.HttpMethod.GET, operations.getGet());
        }
        if (operations.getPut() != null) {
            result.put(PathItem.HttpMethod.PUT, operations.getPut());
        }
        if (operations.getPost() != null) {
            result.put(PathItem.HttpMethod.POST, operations.getPost());
        }
        if (operations.getDelete() != null) {
            result.put(PathItem.HttpMethod.DELETE, operations.getDelete());
        }
        if (operations.getPatch() != null) {
            result.put(PathItem.HttpMethod.PATCH, operations.getPatch());
        }
        if (operations.getHead() != null) {
            result.put(PathItem.HttpMethod.HEAD, operations.getHead());
        }
        if (operations.getOptions() != null) {
            result.put(PathItem.HttpMethod.OPTIONS, operations.getOptions());
        }
        return result;
    }

    private void addProcedure(MetadataFactory mf, SwaggerParseResult swagger, Server toUse, String endpoint, PathItem operations) throws TranslatorException {
        Map<PathItem.HttpMethod, Operation> operationsMap = OpenAPIMetadataProcessor.getOperationMap(operations);
        for (Map.Entry<PathItem.HttpMethod, Operation> entry : operationsMap.entrySet()) {
            Operation operation = entry.getValue();
            String name = operation.getOperationId();
            if (name == null) {
                int start = 0;
                if (endpoint.startsWith("/")) {
                    start = 1;
                }
                name = endpoint.substring(start);
                name = name.replaceAll("\\{([^}]*)\\}", "$1");
                if (operationsMap.entrySet().size() > 1) {
                    name = name + "_" + entry.getKey().name();
                }
            }
            Procedure procedure = mf.addProcedure(name);
            procedure.setVirtual(false);
            procedure.setProperty(METHOD, entry.getKey().name());
            procedure.setProperty(URI, this.buildURL(toUse.getUrl(), endpoint));
            this.addProcedureParameters(mf, swagger, procedure, operation);
            procedure.setAnnotation(this.getOperationSummary(operation));
            this.addExtensions(operation.getExtensions(), (AbstractMetadataRecord)procedure);
            boolean returnAdded = false;
            ApiResponses respMap = operation.getResponses();
            for (String code : respMap.keySet()) {
                int httpCode;
                if (code.equalsIgnoreCase("default") || (httpCode = Integer.valueOf(code).intValue()) <= 100 || httpCode >= 300) continue;
                ApiResponse resp = (ApiResponse)respMap.get((Object)code);
                returnAdded = this.buildResponse(mf, swagger, procedure, resp);
                break;
            }
            if (returnAdded || respMap.get((Object)"default") == null) continue;
            ApiResponse resp = (ApiResponse)respMap.get((Object)"default");
            returnAdded = this.buildResponse(mf, swagger, procedure, resp);
        }
    }

    private boolean buildResponse(final MetadataFactory mf, SwaggerParseResult swagger, final Procedure procedure, ApiResponse resp) throws TranslatorException {
        Map headers;
        SchemaAction pa = new SchemaAction(){

            public void execute(String name, String nameInSource, Schema property, boolean array) {
                String type = OpenAPIMetadataProcessor.getSchemaType(property, array);
                Column c = mf.addProcedureResultSetColumn(name, type, procedure);
                if (!name.equalsIgnoreCase(nameInSource)) {
                    c.setNameInSource(nameInSource);
                }
            }
        };
        Content content = resp.getContent();
        if (content != null && !content.isEmpty()) {
            MediaType mediaType = this.processMediaType(procedure, content, this.preferredProduces, PRODUCES);
            Schema schema = mediaType.getSchema();
            if (this.isSimple(schema)) {
                boolean array = false;
                if (schema instanceof ArraySchema) {
                    schema = ((ArraySchema)schema).getItems();
                    array = true;
                }
                if (resp.getHeaders() == null || resp.getHeaders().isEmpty()) {
                    String type = SwaggerTypeManager.teiidType(schema.getType(), schema.getFormat(), array);
                    mf.addProcedureParameter("return", type, ProcedureParameter.Type.ReturnValue, procedure);
                } else {
                    LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
                    properties.put("return", schema);
                    this.walkSchema(swagger, properties, null, null, pa);
                }
            } else {
                if (schema instanceof ArraySchema) {
                    schema = ((ArraySchema)schema).getItems();
                }
                if (schema instanceof ObjectSchema) {
                    this.walkSchema(swagger, ((ObjectSchema)schema).getProperties(), null, null, pa);
                } else if (schema instanceof MapSchema) {
                    Object property = ((MapSchema)schema).getAdditionalProperties();
                    if (property instanceof Schema) {
                        Schema s = (Schema)property;
                        String type = SwaggerTypeManager.teiidType(s.getType(), s.getFormat(), false);
                        Column c = mf.addProcedureResultSetColumn(KEY_NAME, "string", procedure);
                        c.setNameInSource(KEY_NAME);
                        c = mf.addProcedureResultSetColumn(KEY_VALUE, type, procedure);
                        c.setNameInSource(KEY_VALUE);
                    }
                } else {
                    if (schema instanceof FileSchema) {
                        throw new TranslatorException("File properties are not supported");
                    }
                    Schema s = this.getSchemaFromRef(swagger, schema);
                    if (s != null) {
                        this.walkSchema(swagger, s.getProperties(), null, null, pa);
                    }
                }
            }
        }
        if ((headers = resp.getHeaders()) != null) {
            headers.values().stream().forEach(h -> this.walkSchema(swagger, h.getSchema().getProperties(), null, null, pa));
        }
        return procedure.getResultSet() != null;
    }

    private boolean isSimple(Schema<?> property) {
        if (property instanceof ArraySchema) {
            ArraySchema ap = (ArraySchema)property;
            return this.isSimple(ap.getItems());
        }
        if (property instanceof ObjectSchema) {
            ObjectSchema os = (ObjectSchema)property;
            return "object".equals(os.getType()) && (os.getProperties() == null || os.getProperties().isEmpty());
        }
        if (property instanceof MapSchema) {
            return false;
        }
        if (property instanceof FileSchema) {
            return false;
        }
        return property.get$ref() == null;
    }

    private void walkSchema(SwaggerParseResult swagger, Map<String, Schema> properties, String namePrefix, String nisPrefix, SchemaAction pa) {
        this.walkSchema(swagger, new HashSet(), properties, namePrefix, nisPrefix, pa);
    }

    private void walkSchema(final SwaggerParseResult swagger, final Set<Schema<?>> parents, final Map<String, Schema> properties, final String namePrefix, final String nisPrefix, final SchemaAction pa) {
        if (properties == null) {
            return;
        }
        SchemaVisitor visitor = new SchemaVisitor(){

            @Override
            public void visit(String name, ArraySchema property) {
                if (OpenAPIMetadataProcessor.this.isSimple((Schema)property)) {
                    pa.execute(OpenAPIMetadataProcessor.this.fqn(namePrefix, name), OpenAPIMetadataProcessor.this.nis(nisPrefix, name, false), property.getItems(), true);
                } else {
                    Schema items = property.getItems();
                    parents.add(property);
                    if (items instanceof ObjectSchema) {
                        String modelName = ((ObjectSchema)items).getName();
                        OpenAPIMetadataProcessor.this.walkSchema(swagger, parents, ((ObjectSchema)items).getProperties(), OpenAPIMetadataProcessor.this.fqn(OpenAPIMetadataProcessor.this.fqn(namePrefix, name), modelName), OpenAPIMetadataProcessor.this.nis(OpenAPIMetadataProcessor.this.nis(nisPrefix, name, true), modelName, false), pa);
                    } else {
                        String refSchemaName = items.get$ref();
                        if (refSchemaName != null) {
                            Schema s = OpenAPIMetadataProcessor.this.getSchemaFromRef(swagger, items);
                            String refName = RefUtils.computeDefinitionName((String)refSchemaName);
                            OpenAPIMetadataProcessor.this.walkSchema(swagger, parents, s.getProperties(), OpenAPIMetadataProcessor.this.fqn(OpenAPIMetadataProcessor.this.fqn(namePrefix, name), refName), OpenAPIMetadataProcessor.this.nis(OpenAPIMetadataProcessor.this.nis(nisPrefix, name, true), refName, false), pa);
                        } else {
                            OpenAPIMetadataProcessor.this.walkSchema(swagger, parents, properties, OpenAPIMetadataProcessor.this.fqn(namePrefix, name), OpenAPIMetadataProcessor.this.nis(nisPrefix, name, true), pa);
                        }
                    }
                    parents.remove(property);
                }
            }

            @Override
            public void visit(String name, ObjectSchema property) {
                parents.add(property);
                OpenAPIMetadataProcessor.this.walkSchema(swagger, parents, property.getProperties(), OpenAPIMetadataProcessor.this.fqn(namePrefix, name), OpenAPIMetadataProcessor.this.nis(nisPrefix, name, false), pa);
                parents.remove(property);
            }

            public void visit(String name, Schema property) {
                String schemaName = property.get$ref();
                if (schemaName != null) {
                    Schema s = OpenAPIMetadataProcessor.this.getSchemaFromRef(swagger, property);
                    if (s != null) {
                        parents.add(property);
                        OpenAPIMetadataProcessor.this.walkSchema(swagger, parents, s.getProperties(), OpenAPIMetadataProcessor.this.fqn(namePrefix, name), OpenAPIMetadataProcessor.this.nis(nisPrefix, name, false), pa);
                        parents.remove(property);
                    }
                } else {
                    pa.execute(OpenAPIMetadataProcessor.this.fqn(namePrefix, name), OpenAPIMetadataProcessor.this.nis(nisPrefix, name, false), property, false);
                }
            }
        };
        for (Map.Entry<String, Schema> p : properties.entrySet()) {
            if (parents.contains(p.getValue())) continue;
            visitor.accept(p.getKey(), p.getValue());
        }
    }

    private String fqn(String prefix, String name) {
        if (name == null) {
            return prefix;
        }
        return prefix == null ? name : prefix + "_" + name;
    }

    private String nis(String prefix, String name, boolean array) {
        String nis = null;
        if (name == null) {
            nis = prefix;
        } else {
            String string = nis = prefix == null ? name : prefix + "/" + name;
        }
        if (array) {
            nis = nis + ARRAY_SUFFIX;
        }
        return nis;
    }

    private static String getSchemaType(Schema<?> property, boolean array) {
        String type = "string";
        if (property != null) {
            type = SwaggerTypeManager.teiidType(property.getType(), property.getFormat(), array);
        } else if (array) {
            type = type + ARRAY_SUFFIX;
        }
        return type;
    }

    private void addProcedureParameters(final MetadataFactory mf, SwaggerParseResult swagger, final Procedure procedure, Operation operation) {
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                String name = parameter.getName();
                ProcedureParameter pp = null;
                Object defaultValue = null;
                Parameter.StyleEnum style = parameter.getStyle();
                boolean array = false;
                Schema schema = parameter.getSchema();
                String type = schema.getType();
                if (schema instanceof ArraySchema) {
                    Schema ap = ((ArraySchema)schema).getItems();
                    type = ap.getType();
                    array = true;
                }
                type = SwaggerTypeManager.teiidType(type, schema.getFormat(), array);
                defaultValue = schema.getDefault();
                pp = mf.addProcedureParameter(name, type, ProcedureParameter.Type.In, procedure);
                pp.setProperty(PARAMETER_TYPE, parameter.getIn());
                Boolean required = parameter.getRequired();
                if (required == null || !required.booleanValue()) {
                    pp.setProperty("teiid_rel:default_handling", "omit");
                }
                pp.setNullType(BaseColumn.NullType.No_Nulls);
                pp.setAnnotation(parameter.getDescription());
                if (defaultValue != null) {
                    pp.setDefaultValue(defaultValue.toString());
                }
                if (style != null) {
                    pp.setProperty(COLLECION_FORMAT, style.toString());
                }
                this.addExtensions(parameter.getExtensions(), (AbstractMetadataRecord)pp);
            }
        }
        if (operation.getRequestBody() != null) {
            final RequestBody requestBody = operation.getRequestBody();
            SchemaAction pa = new SchemaAction(){

                public void execute(String name, String nameInSource, Schema property, boolean array) {
                    String type = OpenAPIMetadataProcessor.getSchemaType(property, array);
                    if (procedure.getParameterByName(nameInSource) == null) {
                        ProcedureParameter param = mf.addProcedureParameter(name, type, ProcedureParameter.Type.In, procedure);
                        param.setProperty(OpenAPIMetadataProcessor.PARAMETER_TYPE, "body");
                        if (!(property == null || requestBody.getRequired() != null && requestBody.getRequired().booleanValue() || property.getRequired() != null && !property.getRequired().isEmpty())) {
                            param.setProperty("teiid_rel:default_handling", "omit");
                        }
                        param.setNullType(BaseColumn.NullType.No_Nulls);
                        param.setAnnotation(property != null ? property.getDescription() : null);
                        if (!name.equalsIgnoreCase(nameInSource)) {
                            param.setNameInSource(nameInSource);
                        }
                    }
                }
            };
            Content content = requestBody.getContent();
            MediaType mediaType = this.processMediaType(procedure, content, this.preferredConsumes, CONSUMES);
            Schema schema = mediaType.getSchema();
            if (schema.get$ref() != null) {
                if (schema.getProperties() != null) {
                    this.walkSchema(swagger, schema.getProperties(), null, null, pa);
                } else {
                    Schema s = this.getSchemaFromRef(swagger, schema);
                    if (s != null) {
                        this.walkSchema(swagger, s.getProperties(), null, null, pa);
                    }
                }
            } else if (schema.getProperties() != null) {
                this.walkSchema(swagger, schema.getProperties(), null, null, pa);
            } else {
                ProcedureParameter p = mf.addProcedureParameter("body", "clob", ProcedureParameter.Type.In, procedure);
                p.setProperty(PARAMETER_TYPE, "body");
                p.setNullType(BaseColumn.NullType.No_Nulls);
                p.setAnnotation(requestBody.getDescription());
            }
        }
    }

    private void addExtensions(Map<String, Object> extensions, AbstractMetadataRecord record) {
        if (extensions != null) {
            for (Map.Entry<String, Object> extension : extensions.entrySet()) {
                record.setProperty(extension.getKey(), extension.getValue().toString());
            }
        }
    }

    private MediaType processMediaType(Procedure procedure, Content content, String defaultType, String propertyKey) {
        MediaType mediaType = (MediaType)content.get((Object)defaultType);
        if (mediaType == null) {
            Map.Entry entry = (Map.Entry)content.entrySet().iterator().next();
            defaultType = (String)entry.getKey();
            mediaType = (MediaType)entry.getValue();
        }
        if (!"*/*".equals(defaultType)) {
            procedure.setProperty(propertyKey, defaultType);
        }
        return mediaType;
    }

    private Schema getSchemaFromRef(SwaggerParseResult swagger, Schema schema) {
        String ref = schema.get$ref();
        if (ref == null) {
            return null;
        }
        String name = RefUtils.computeDefinitionName((String)ref);
        return (Schema)swagger.getOpenAPI().getComponents().getSchemas().get(name);
    }

    private String getOperationSummary(Operation operation) {
        String description = operation.getDescription();
        if (description == null || description.equals("")) {
            description = operation.getSummary();
        }
        return description;
    }

    protected SwaggerParseResult getSchema(WSConnection conn) throws TranslatorException {
        SwaggerParseResult swagger = null;
        try {
            String url = this.metadataUrl;
            if (url == null) {
                url = "openapi";
            }
            OpenAPIParser parser = new OpenAPIParser(){

                protected List<SwaggerParserExtension> getExtensions() {
                    SwaggerConverter converter;
                    List extensions = super.getExtensions();
                    if (!extensions.contains(converter = new SwaggerConverter())) {
                        extensions.add(converter);
                    }
                    return extensions;
                }
            };
            ParseOptions parseOptions = new ParseOptions();
            parseOptions.setResolve(true);
            if (url.startsWith("classpath:") || url.startsWith("file:")) {
                swagger = parser.readLocation(url, null, parseOptions);
            } else {
                BaseQueryExecution execution = new BaseQueryExecution(this.ef, null, null, conn);
                HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                BinaryWSProcedureExecution call = execution.buildInvokeHTTP("GET", url, null, headers);
                call.execute();
                if (call.getResponseCode() != 200) {
                    throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28015, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28015, new Object[]{call.getResponseCode()}));
                }
                Blob out = (Blob)call.getOutputParameterValues().get(0);
                String contents = ObjectConverterUtil.convertToString((InputStream)out.getBinaryStream());
                swagger = parser.readContents(contents, null, parseOptions);
            }
        }
        catch (Exception e) {
            throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28016, (Throwable)e, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28016, new Object[]{e}));
        }
        return swagger;
    }

    static interface SchemaAction {
        public void execute(String var1, String var2, Schema<?> var3, boolean var4);
    }
}

