/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.util.Base64;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.language.Array;
import org.teiid.language.Expression;
import org.teiid.language.Literal;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.document.Document;
import org.teiid.translator.swagger.SwaggerPlugin;
import org.teiid.translator.swagger.SwaggerSerializer;
import org.teiid.translator.swagger.SwaggerTypeManager;

public class JsonSerializer
implements SwaggerSerializer {
    @Override
    public List<Document> deserialize(InputStream stream) throws TranslatorException {
        try {
            JsonParser parser = new JsonFactory().createParser(stream);
            List<Document> list = null;
            Document current = null;
            Stack<String> fieldName = new Stack<String>();
            int arrayLevel = 0;
            int objectLevel = 0;
            block16: while (parser.nextToken() != null) {
                switch (parser.getCurrentToken()) {
                    case START_OBJECT: {
                        ++objectLevel;
                        if (current == null) {
                            current = new Document();
                            continue block16;
                        }
                        Document child = new Document((String)fieldName.peek(), arrayLevel >= objectLevel, current);
                        current.addChildDocument((String)fieldName.peek(), child);
                        current = child;
                        continue block16;
                    }
                    case END_OBJECT: {
                        --objectLevel;
                        if (list != null && current.getParent() == null) {
                            list.add(current);
                            current = null;
                            continue block16;
                        }
                        Document parent = current.getParent();
                        if (parent == null) continue block16;
                        current = parent;
                        continue block16;
                    }
                    case START_ARRAY: {
                        ++arrayLevel;
                        if (current != null || list != null) continue block16;
                        list = new ArrayList<Document>();
                        continue block16;
                    }
                    case END_ARRAY: {
                        if (arrayLevel > objectLevel && !fieldName.empty()) {
                            fieldName.pop();
                        }
                        --arrayLevel;
                        continue block16;
                    }
                    case FIELD_NAME: {
                        fieldName.push(parser.getCurrentName());
                        continue block16;
                    }
                    case VALUE_STRING: {
                        if (list != null && arrayLevel > objectLevel || list == null && arrayLevel >= objectLevel) {
                            current.addArrayProperty((String)fieldName.peek(), (Object)parser.getValueAsString());
                            continue block16;
                        }
                        current.addProperty((String)fieldName.pop(), (Object)parser.getValueAsString());
                        continue block16;
                    }
                    case VALUE_NUMBER_INT: {
                        if (list != null && arrayLevel > objectLevel || list == null && arrayLevel >= objectLevel) {
                            current.addArrayProperty((String)fieldName.peek(), (Object)parser.getValueAsLong());
                            continue block16;
                        }
                        current.addProperty((String)fieldName.pop(), (Object)parser.getValueAsLong());
                        continue block16;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        if (list != null && arrayLevel > objectLevel || list == null && arrayLevel >= objectLevel) {
                            current.addArrayProperty((String)fieldName.peek(), (Object)parser.getValueAsDouble());
                            continue block16;
                        }
                        current.addProperty((String)fieldName.pop(), (Object)parser.getValueAsDouble());
                        continue block16;
                    }
                    case VALUE_TRUE: {
                        if (list != null && arrayLevel > objectLevel || list == null && arrayLevel >= objectLevel) {
                            current.addArrayProperty((String)fieldName.peek(), (Object)parser.getValueAsBoolean());
                            continue block16;
                        }
                        current.addProperty((String)fieldName.pop(), (Object)parser.getValueAsBoolean());
                        continue block16;
                    }
                    case VALUE_FALSE: {
                        if (list != null && arrayLevel > objectLevel || list == null && arrayLevel >= objectLevel) {
                            current.addArrayProperty((String)fieldName.peek(), (Object)parser.getValueAsBoolean());
                            continue block16;
                        }
                        current.addProperty((String)fieldName.pop(), (Object)parser.getValueAsBoolean());
                        continue block16;
                    }
                    case VALUE_NULL: {
                        if (list != null && arrayLevel > objectLevel || list == null && arrayLevel >= objectLevel) {
                            current.addArrayProperty((String)fieldName.peek(), null);
                            continue block16;
                        }
                        current.addProperty((String)fieldName.pop(), null);
                        continue block16;
                    }
                }
            }
            return list == null ? Arrays.asList(current) : list;
        }
        catch (JsonParseException e) {
            throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28007, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28007, new Object[]{e}));
        }
        catch (IOException e) {
            throw new TranslatorException((BundleUtil.Event)SwaggerPlugin.Event.TEIID28007, SwaggerPlugin.Util.gs((BundleUtil.Event)SwaggerPlugin.Event.TEIID28007, new Object[]{e}));
        }
    }

    @Override
    public InputStream serialize(Document doc) throws TranslatorException {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream(10240);
            JsonGenerator json = new JsonFactory().createGenerator((OutputStream)outputStream);
            this.writeDocument(doc, null, json, false);
            json.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException | SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeDocument(Document doc, String name, JsonGenerator json, boolean writeName) throws IOException, SQLException {
        if (doc.getProperties().isEmpty() && doc.getChildren().isEmpty()) {
            return;
        }
        if (writeName) {
            json.writeObjectFieldStart(name);
        } else {
            json.writeStartObject();
        }
        for (Map.Entry entry : doc.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith(name + "/")) {
                key = key.substring(name.length() + 1);
            }
            if (value instanceof Array) {
                json.writeArrayFieldStart(key);
                Array array = (Array)value;
                for (Expression expr : array.getExpressions()) {
                    this.writeProperty(json, ((Literal)expr).getValue());
                }
                json.writeEndArray();
                continue;
            }
            this.writeProperty(json, key, value);
        }
        if (!doc.getChildren().isEmpty()) {
            for (Map.Entry entry : doc.getChildren().entrySet()) {
                String docName = (String)entry.getKey();
                List children = (List)entry.getValue();
                boolean array = ((Document)children.get(0)).isArray();
                if (array) {
                    json.writeArrayFieldStart(docName);
                    for (Document child : children) {
                        this.writeDocument(child, docName, json, false);
                    }
                    json.writeEndArray();
                    continue;
                }
                this.writeDocument((Document)children.get(0), docName, json, true);
            }
        }
        json.writeEndObject();
    }

    private void writeProperty(JsonGenerator json, Object value) throws IOException, SQLException {
        if (value instanceof Integer) {
            json.writeNumber(((Integer)value).intValue());
        } else if (value instanceof Long) {
            json.writeNumber(((Long)value).longValue());
        } else if (value instanceof Float) {
            json.writeNumber(((Float)value).floatValue());
        } else if (value instanceof Double) {
            json.writeNumber(((Double)value).doubleValue());
        } else if (value instanceof Byte) {
            json.writeNumber((short)((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            json.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Timestamp) {
            json.writeString(SwaggerTypeManager.timestampToString((Timestamp)value));
        } else if (value instanceof Date) {
            json.writeString(SwaggerTypeManager.dateToString((Date)value));
        } else if (value instanceof ClobType) {
            json.writeString(ClobType.getString((Clob)((Clob)value)));
        } else if (value instanceof BlobType) {
            json.writeString(Base64.encodeBytes((byte[])ObjectConverterUtil.convertToByteArray((InputStream)((Blob)value).getBinaryStream())));
        } else if (value instanceof SQLXML) {
            json.writeString(ObjectConverterUtil.convertToString((Reader)((SQLXML)value).getCharacterStream()));
        } else if (value instanceof byte[]) {
            json.writeString(Base64.encodeBytes((byte[])((byte[])value)));
        } else {
            json.writeString(value.toString());
        }
    }

    private void writeProperty(JsonGenerator json, String key, Object value) throws IOException, SQLException {
        if (value instanceof Integer) {
            json.writeNumberField(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            json.writeNumberField(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            json.writeNumberField(key, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            json.writeNumberField(key, ((Double)value).doubleValue());
        } else if (value instanceof Byte) {
            json.writeNumberField(key, (short)((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            json.writeBooleanField(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Timestamp) {
            json.writeStringField(key, SwaggerTypeManager.timestampToString((Timestamp)value));
        } else if (value instanceof Date) {
            json.writeStringField(key, SwaggerTypeManager.dateToString((Date)value));
        } else if (value instanceof ClobType) {
            json.writeStringField(key, ClobType.getString((Clob)((Clob)value)));
        } else if (value instanceof BlobType) {
            json.writeStringField(key, Base64.encodeBytes((byte[])ObjectConverterUtil.convertToByteArray((InputStream)((Blob)value).getBinaryStream())));
        } else if (value instanceof SQLXML) {
            json.writeStringField(key, ObjectConverterUtil.convertToString((Reader)((SQLXML)value).getCharacterStream()));
        } else if (value instanceof byte[]) {
            json.writeStringField(key, Base64.encodeBytes((byte[])((byte[])value)));
        } else {
            json.writeStringField(key, value.toString());
        }
    }
}

