/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.prestodb;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Parser;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.prestodb.PrestoDBExecutionFactory;

public class TestSQLConversionVisitor {
    private static final LanguageFactory LANG_FACTORY = new LanguageFactory();
    private static PrestoDBExecutionFactory TRANSLATOR;
    private static TranslationUtility translationUtility;

    @BeforeClass
    public static void init() throws TranslatorException {
        TestSQLConversionVisitor.init("0.92");
    }

    public static void init(String version) throws TranslatorException {
        TRANSLATOR = new PrestoDBExecutionFactory();
        TRANSLATOR.setDatabaseVersion(version);
        TRANSLATOR.start();
        translationUtility.addUDF("SYS", (Collection)TRANSLATOR.getPushDownFunctions());
    }

    private static TransformationMetadata queryMetadataInterface() {
        try {
            ModelMetaData mmd = new ModelMetaData();
            mmd.setName("prestodbModel");
            MetadataFactory mf = new MetadataFactory("prestodb", (Object)1, SystemMetadata.getInstance().getRuntimeTypeMap(), mmd);
            mf.setParser((Parser)new QueryParser());
            mf.parse((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)"sample.ddl")));
            TransformationMetadata tm = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[0]);
            ValidatorReport report = new MetadataValidator().validate(tm.getVdbMetaData(), (MetadataStore)tm.getMetadataStore());
            if (report.hasItems()) {
                throw new RuntimeException(report.getFailureMessage());
            }
            return tm;
        }
        catch (FileNotFoundException | MetadataException e) {
            throw new RuntimeException(e);
        }
    }

    private void helpTest(String sql, String expected) throws TranslatorException {
        Command command = translationUtility.parseCommand(sql);
        SQLConversionVisitor vistor = TRANSLATOR.getSQLConversionVisitor();
        vistor.append((LanguageObject)command);
        Assert.assertEquals((Object)expected, (Object)vistor.toString());
    }

    private void helpTestMod(Literal c, String format, String expectedStr) throws Exception {
        Function func = LANG_FACTORY.createFunction(format, Arrays.asList(c), String.class);
        PrestoDBExecutionFactory ef = new PrestoDBExecutionFactory();
        ef.start();
        SQLConversionVisitor sqlVisitor = ef.getSQLConversionVisitor();
        sqlVisitor.append((LanguageObject)func);
        Assert.assertEquals((Object)expectedStr, (Object)sqlVisitor.toString());
    }

    @Test
    public void testDayOfMonth() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)117, (int)0, (int)13, (int)10, (int)5, (int)0, (int)10000000), Timestamp.class);
        this.helpTestMod(arg1, "dayofmonth", "day_of_month(timestamp '2017-01-13 10:05:00.01')");
    }

    @Test
    public void testDayOfWeek() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)117, (int)0, (int)13, (int)10, (int)5, (int)0, (int)10000000), Timestamp.class);
        this.helpTestMod(arg1, "dayofweek", "day_of_week(timestamp '2017-01-13 10:05:00.01')");
    }

    @Test
    public void testDayOfYear() throws Exception {
        Literal arg1 = LANG_FACTORY.createLiteral((Object)TimestampUtil.createTimestamp((int)117, (int)0, (int)13, (int)10, (int)5, (int)0, (int)10000000), Timestamp.class);
        this.helpTestMod(arg1, "dayofyear", "day_of_year(timestamp '2017-01-13 10:05:00.01')");
    }

    @Test
    public void testDateTimeLiterals() throws Exception {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("UTC"));
        try {
            String sql = "SELECT intkey FROM prestodbModel.smalla WHERE datevalue = cast('2017-01-13' as date)";
            String expected = "SELECT smalla.intKey FROM smalla WHERE smalla.dateValue = date '2017-01-13'";
            this.helpTest(sql, expected);
            sql = "SELECT intkey FROM prestodbModel.smalla WHERE smalla.timeValue = cast('15:50:02' as time)";
            expected = "SELECT smalla.intKey FROM smalla WHERE smalla.timeValue = time '15:50:02'";
            this.helpTest(sql, expected);
            sql = "SELECT intkey FROM prestodbModel.smalla WHERE smalla.timestampValue = cast('2017-01-13 15:50:02.0' as timestamp)";
            expected = "SELECT smalla.intKey FROM smalla WHERE smalla.timestampValue = timestamp '2017-01-13 15:50:02.0'";
            this.helpTest(sql, expected);
        }
        finally {
            TimestampWithTimezone.resetCalendar(null);
        }
    }

    @Test
    public void testFormatDateTime() throws TranslatorException {
        String sql = "SELECT FORMATDATE(datevalue, 'MM-dd-yy') FROM prestodbModel.smalla";
        String expected = "SELECT format_datetime(cast(smalla.dateValue AS timestamp), 'MM-dd-yy') FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT FORMATTIME(timeValue, 'HH:MI:SS') FROM prestodbModel.smalla";
        expected = "SELECT format_datetime(cast(smalla.timeValue AS timestamp), 'HH:MI:SS') FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT FORMATTIMESTAMP(timestampValue, 'YYYY-MM-DD HH:MI:SS') FROM prestodbModel.smalla";
        expected = "SELECT format_datetime(smalla.timestampValue, 'YYYY-MM-DD HH:MI:SS') FROM smalla";
        this.helpTest(sql, expected);
    }

    @Test
    public void testConvertCast() throws TranslatorException {
        String sql = "SELECT convert(dateValue, timestamp) FROM prestodbModel.smalla";
        String expected = "SELECT cast(smalla.dateValue AS timestamp) FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT convert(timeValue, timestamp) FROM prestodbModel.smalla";
        expected = "SELECT cast(smalla.timeValue AS timestamp) FROM smalla";
        this.helpTest(sql, expected);
    }

    @Test
    public void testConvertCastExpandedTypes() throws TranslatorException {
        TestSQLConversionVisitor.init("0.190");
        String sql = "SELECT convert(stringnum, integer), convert(stringnum, byte) FROM prestodbModel.smalla";
        String expected = "SELECT cast(smalla.stringnum AS integer), cast(smalla.stringnum AS tinyint) FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT booleanValue, (booleanValue + 1) AS BooleanValuePlus2 FROM prestodbModel.SmallA";
        expected = "SELECT smalla.booleanValue, (cast(smalla.booleanValue AS integer) + 1) AS BooleanValuePlus2 FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT convert(stringnum, float), convert(stringnum, short) FROM prestodbModel.smalla";
        expected = "SELECT cast(smalla.stringnum AS real), cast(smalla.stringnum AS smallint) FROM smalla";
        this.helpTest(sql, expected);
    }

    @Test
    public void testLogarithmFunctions() throws TranslatorException {
        String sql = "SELECT log(doublenum) FROM prestodbModel.smalla";
        String expected = "SELECT ln(smalla.doublenum) FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT log10(doublenum) FROM prestodbModel.smalla";
        expected = "SELECT log10(smalla.doublenum) FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT prestodb.log2(doublenum) FROM prestodbModel.smalla";
        expected = "SELECT log2(smalla.doublenum) FROM smalla";
        this.helpTest(sql, expected);
        sql = "SELECT prestodb.log(doublenum, 2) FROM prestodbModel.smalla";
        expected = "SELECT log(smalla.doublenum, 2) FROM smalla";
        this.helpTest(sql, expected);
    }

    @Test
    public void testCorelatedSubquery() throws TranslatorException {
        String sql = "SELECT intkey, bytenum, (SELECT bytenum FROM prestodbModel.smalla AS b WHERE (bytenum = a.longnum) AND (intkey = '10')) AS longnum FROM prestodbModel.smalla AS a";
        String expected = "SELECT a.intKey, a.bytenum, (SELECT b.bytenum FROM smalla AS b WHERE cast(b.bytenum AS bigint) = a.longnum AND b.intKey = '10' LIMIT 2) AS longnum FROM smalla AS a";
        this.helpTest(sql, expected);
    }

    static {
        translationUtility = new TranslationUtility((QueryMetadataInterface)TestSQLConversionVisitor.queryMetadataInterface());
    }
}

