/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.prestodb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;

public class PrestoDBMetadataProcessor
extends JDBCMetadataProcessor
implements MetadataProcessor<Connection> {
    private boolean trimColumnNames;

    public void process(MetadataFactory metadataFactory, Connection conn) throws TranslatorException {
        try {
            this.getConnectorMetadata(conn, metadataFactory);
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void getConnectorMetadata(Connection conn, MetadataFactory metadataFactory) throws SQLException {
        List<String> catalogs = this.getCatalogs(conn);
        for (String catalog : catalogs) {
            if (this.getCatalog() != null && !this.getCatalog().equalsIgnoreCase(catalog)) continue;
            List<String> schemas = this.getSchema(conn, catalog);
            for (String schema : schemas) {
                if (this.getSchemaPattern() != null && !Pattern.matches(this.getSchemaPattern(), schema)) continue;
                List<String> tables = this.getTables(conn, catalog, schema);
                for (String table : tables) {
                    if (this.shouldExclude(table)) continue;
                    this.addTable(table, conn, catalog, schema, metadataFactory);
                }
            }
        }
    }

    private List<String> getCatalogs(Connection conn) throws SQLException {
        ArrayList<String> catalogs = new ArrayList<String>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW CATALOGS");
        while (rs.next()) {
            catalogs.add(rs.getString(1));
        }
        rs.close();
        return catalogs;
    }

    private List<String> getSchema(Connection conn, String catalog) throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW SCHEMAS FROM " + catalog);
        while (rs.next()) {
            schemas.add(rs.getString(1));
        }
        rs.close();
        return schemas;
    }

    private List<String> getTables(Connection conn, String catalog, String schema) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW TABLES FROM " + catalog + "." + schema);
        while (rs.next()) {
            tables.add(rs.getString(1));
        }
        rs.close();
        return tables;
    }

    private String getRuntimeType(String type) {
        if (type.equalsIgnoreCase("boolean")) {
            return "boolean";
        }
        if (type.equalsIgnoreCase("bigint")) {
            return "long";
        }
        if (type.equalsIgnoreCase("double")) {
            return "double";
        }
        if (type.equalsIgnoreCase("varchar")) {
            return "string";
        }
        if (type.equalsIgnoreCase("varbinary")) {
            return "varbinary";
        }
        if (type.equalsIgnoreCase("date")) {
            return "date";
        }
        if (type.equalsIgnoreCase("time") || type.equalsIgnoreCase("time with timezone")) {
            return "time";
        }
        if (type.equalsIgnoreCase("timestamp") || type.equalsIgnoreCase("timestamp with timezone")) {
            return "timestamp";
        }
        if (type.equalsIgnoreCase("json")) {
            return "blob";
        }
        return "object";
    }

    private void addTable(String tableName, Connection conn, String catalog, String schema, MetadataFactory metadataFactory) throws SQLException {
        Table table = this.addTable(metadataFactory, null, null, tableName, null, tableName);
        if (table == null) {
            return;
        }
        String nis = catalog + "." + schema + "." + tableName;
        table.setNameInSource(nis);
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW COLUMNS FROM " + nis);
        while (rs.next()) {
            String type;
            String name = rs.getString(1);
            if (this.trimColumnNames) {
                name = name.trim();
            }
            if ((type = rs.getString(2)) != null) {
                type = type.trim();
            }
            String runtimeType = this.getRuntimeType(type);
            BaseColumn.NullType nt = Boolean.valueOf(rs.getString(3)) != false ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls;
            Column column = metadataFactory.addColumn(name, runtimeType, (ColumnSet)table);
            column.setNameInSource(name);
            column.setUpdatable(true);
            column.setNullType(nt);
        }
        rs.close();
    }
}

