/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.prestodb;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.Function;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCMetadataProcessor;
import org.teiid.translator.jdbc.JDBCUpdateExecution;
import org.teiid.translator.prestodb.PrestoDBMetadataProcessor;
import org.teiid.translator.prestodb.PrestoDBPlugin;
import org.teiid.util.Version;

@Translator(name="prestodb", description="PrestoDB custom translator")
public class PrestoDBExecutionFactory
extends JDBCExecutionFactory {
    private static final String PRESTODB = "prestodb";
    public static final Version V_0_153 = Version.getVersion((String)"0.153");
    private ConvertModifier convert = new ConvertModifier();

    public PrestoDBExecutionFactory() {
        this.setSupportsSelectDistinct(true);
        this.setSupportsInnerJoins(true);
        this.setSupportsOuterJoins(true);
        this.setSupportsFullOuterJoins(true);
        this.setUseBindVariables(false);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
    }

    public JDBCUpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)PrestoDBPlugin.Event.TEIID26000, PrestoDBPlugin.Util.gs((BundleUtil.Event)PrestoDBPlugin.Event.TEIID26000, new Object[]{command}));
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)PrestoDBPlugin.Event.TEIID26000, PrestoDBPlugin.Util.gs((BundleUtil.Event)PrestoDBPlugin.Event.TEIID26000, new Object[]{command}));
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection conn) throws TranslatorException {
        throw new TranslatorException((BundleUtil.Event)PrestoDBPlugin.Event.TEIID26000, PrestoDBPlugin.Util.gs((BundleUtil.Event)PrestoDBPlugin.Event.TEIID26000, new Object[]{command}));
    }

    public boolean useAnsiJoin() {
        return true;
    }

    @Deprecated
    protected JDBCMetadataProcessor createMetadataProcessor() {
        return (PrestoDBMetadataProcessor)this.getMetadataProcessor();
    }

    public MetadataProcessor<Connection> getMetadataProcessor() {
        return new PrestoDBMetadataProcessor();
    }

    public boolean isSourceRequiredForMetadata() {
        return true;
    }

    public boolean supportsConvert(int fromType, int toType) {
        if (!super.supportsConvert(fromType, toType)) {
            return false;
        }
        return this.convert.hasTypeMapping(toType);
    }

    protected boolean usesDatabaseVersion() {
        return true;
    }

    public void initCapabilities(Connection connection) throws TranslatorException {
        super.initCapabilities(connection);
        if (this.getVersion().compareTo(V_0_153) >= 0) {
            this.convert.addTypeMapping("real", new int[]{8});
            this.convert.addTypeMapping("tinyint", new int[]{3});
            this.convert.addTypeMapping("smallint", new int[]{4});
            this.convert.addTypeMapping("integer", new int[]{5});
        }
    }

    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("boolean", new int[]{2});
        this.convert.addTypeMapping("bigint", new int[]{7, 6});
        this.convert.addTypeMapping("double", new int[]{9});
        this.convert.addTypeMapping("varchar", new int[]{0});
        this.convert.addTypeMapping("date", new int[]{11});
        this.convert.addTypeMapping("time", new int[]{12});
        this.convert.addTypeMapping("timestamp", new int[]{13});
        this.convert.addTypeMapping("varbinary", new int[]{15});
        this.convert.addTypeMapping("json", new int[]{15});
        this.registerFunctionModifier("convert", (FunctionModifier)this.convert);
        this.registerFunctionModifier("curdate", (FunctionModifier)new AliasModifier("current_date"));
        this.registerFunctionModifier("curtime", (FunctionModifier)new AliasModifier("current_time"));
        this.registerFunctionModifier("dayofmonth", (FunctionModifier)new AliasModifier("day_of_month"));
        this.registerFunctionModifier("dayofweek", (FunctionModifier)new AliasModifier("day_of_week"));
        this.registerFunctionModifier("dayofyear", (FunctionModifier)new AliasModifier("day_of_year"));
        this.registerFunctionModifier("ifnull", (FunctionModifier)new AliasModifier("coalesce"));
        this.registerFunctionModifier("formattimestamp", (FunctionModifier)new AliasModifier("format_datetime"));
        this.registerFunctionModifier("parsetimestamp", (FunctionModifier)new AliasModifier("parse_datetime"));
        this.registerFunctionModifier("power", (FunctionModifier)new AliasModifier("pow"));
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("lower"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("upper"));
        this.registerFunctionModifier("char", (FunctionModifier)new AliasModifier("chr"));
        this.registerFunctionModifier("log", (FunctionModifier)new AliasModifier("ln"){

            protected void modify(Function function) {
                if (function.getParameters().size() == 1) {
                    super.modify(function);
                }
            }
        });
        this.addPushDownFunction(PRESTODB, "cbrt", "double", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "ceil", "integer", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "current_timestamp", "timestamp", new String[0]);
        this.addPushDownFunction(PRESTODB, "current_timezone", "string", new String[0]);
        this.addPushDownFunction(PRESTODB, "e", "double", new String[0]);
        this.addPushDownFunction(PRESTODB, "ln", "double", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "log2", "double", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "log", "double", new String[]{"double", "integer"});
        this.addPushDownFunction(PRESTODB, "random", "double", new String[0]);
        this.addPushDownFunction(PRESTODB, "cosh", "double", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "tanh", "double", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "infinity", "double", new String[0]);
        this.addPushDownFunction(PRESTODB, "is_finite", "boolean", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "is_infinite", "boolean", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "is_nan", "boolean", new String[]{"double"});
        this.addPushDownFunction(PRESTODB, "nan", "double", new String[0]);
        this.addPushDownFunction(PRESTODB, "reverse", "string", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "split_part", "string", new String[]{"string", "char", "integer"});
        this.addPushDownFunction(PRESTODB, "to_base64", "string", new String[]{"varbinary"});
        this.addPushDownFunction(PRESTODB, "from_base64", "varbinary", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "to_base64url", "string", new String[]{"varbinary"});
        this.addPushDownFunction(PRESTODB, "from_base64url", "varbinary", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "to_hex", "string", new String[]{"varbinary"});
        this.addPushDownFunction(PRESTODB, "from_hex", "varbinary", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "timezone_hour", "biginteger", new String[]{"timestamp"});
        this.addPushDownFunction(PRESTODB, "timezone_minute", "biginteger", new String[]{"timestamp"});
        this.addPushDownFunction(PRESTODB, "regexp_extract", "string", new String[]{"string", "string"});
        this.addPushDownFunction(PRESTODB, "regexp_extract", "string", new String[]{"string", "integer"});
        this.addPushDownFunction(PRESTODB, "regexp_like", "boolean", new String[]{"string", "string"});
        this.addPushDownFunction(PRESTODB, "regexp_replace", "string", new String[]{"string", "string", "string"});
        this.addPushDownFunction(PRESTODB, "url_extract_fragment", "string", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "url_extract_host", "string", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "url_extract_parameter", "string", new String[]{"string", "string"});
        this.addPushDownFunction(PRESTODB, "url_extract_path", "string", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "url_extract_port", "integer", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "url_extract_protocol", "string", new String[]{"string"});
        this.addPushDownFunction(PRESTODB, "url_extract_query", "string", new String[]{"string"});
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("ceiling");
        supportedFunctions.add("char");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("concat");
        supportedFunctions.add("cos");
        supportedFunctions.add("convert");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("exp");
        supportedFunctions.add("floor");
        supportedFunctions.add("formattimestamp");
        supportedFunctions.add("hour");
        supportedFunctions.add("ifnull");
        supportedFunctions.add("lcase");
        supportedFunctions.add("length");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("log");
        supportedFunctions.add("log10");
        supportedFunctions.add("minute");
        supportedFunctions.add("mod");
        supportedFunctions.add("month");
        supportedFunctions.add("now");
        supportedFunctions.add("parsetimestamp");
        supportedFunctions.add("pi");
        supportedFunctions.add("power");
        supportedFunctions.add("quarter");
        supportedFunctions.add("rand");
        supportedFunctions.add("replace");
        supportedFunctions.add("round");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("second");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("sin");
        supportedFunctions.add("substring");
        supportedFunctions.add("tan");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("week");
        supportedFunctions.add("year");
        return supportedFunctions;
    }

    public String translateLiteralDate(Date dateValue) {
        return "date '" + this.formatDateValue(dateValue) + "'";
    }

    public String translateLiteralTime(Time timeValue) {
        return "time '" + this.formatDateValue(timeValue) + "'";
    }

    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "timestamp '" + this.formatDateValue(timestampValue) + "'";
    }

    public boolean supportsSelectWithoutFrom() {
        return true;
    }

    public boolean supportsSubqueryInOn() {
        return true;
    }

    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsExistsCriteria() {
        return false;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsOrderByNullOrdering() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsIntersect() {
        return false;
    }

    public boolean supportsExcept() {
        return false;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return false;
    }

    public boolean supportsFunctionsInGroupBy() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return true;
    }

    public boolean supportsBatchedUpdates() {
        return true;
    }

    public boolean supportsCommonTableExpressions() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return true;
    }

    public boolean supportsArrayType() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return false;
    }
}

