/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb.visitors;

import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.LanguageFactory;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.simpledb.SimpleDBExecutionFactory;
import org.teiid.translator.simpledb.SimpleDBInsertVisitor;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

public class TestSimpleDBExecution {
    private static SimpleDBExecutionFactory translator;
    private static TranslationUtility utility;
    private static SimpleDBConnection connection;

    @Before
    public void setup() throws Exception {
        translator = new SimpleDBExecutionFactory();
        translator.start();
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" string, attribute string, somedate timestamp, strarray string[]);", (String)"x", (String)"y");
        utility = new TranslationUtility((QueryMetadataInterface)tm);
        connection = (SimpleDBConnection)Mockito.mock(SimpleDBConnection.class);
    }

    @Test
    public void testSelect() throws Exception {
        SelectResult result = new SelectResult();
        result.setItems(this.mockResult());
        String query = "select * from item where attribute > 'name'";
        Mockito.stub((Object)connection.performSelect(Mockito.anyString(), Mockito.anyString())).toReturn((Object)result);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.stub((Object)context.getBatchSize()).toReturn((Object)10);
        ResultSetExecution exec = translator.createResultSetExecution((QueryExpression)((Select)cmd), context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        exec.next();
        ((SimpleDBConnection)Mockito.verify((Object)connection)).performSelect("SELECT attribute, somedate, strarray FROM item WHERE attribute > 'name' LIMIT 10", null);
        Mockito.stub((Object)context.getBatchSize()).toReturn((Object)4000);
        exec = translator.createResultSetExecution((QueryExpression)((Select)cmd), context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        exec.next();
        ((SimpleDBConnection)Mockito.verify((Object)connection)).performSelect("SELECT attribute, somedate, strarray FROM item WHERE attribute > 'name' LIMIT 2500", null);
    }

    @Test
    public void testUpdate() throws Exception {
        String query = "UPDATE item set attribute = 'value', somedate = {ts '2014-04-04 10:50:45'} where attribute > 'name'";
        Mockito.stub((Object)connection.performUpdate(Mockito.anyString(), Mockito.anyMap(), Mockito.anyString())).toReturn((Object)100);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        UpdateExecution exec = translator.createUpdateExecution(cmd, context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        attributes.put("attribute", "value");
        attributes.put("somedate", "2014-04-04 10:50:45.0");
        ((SimpleDBConnection)Mockito.verify((Object)connection)).performUpdate("item", attributes, "SELECT itemName() FROM item WHERE attribute > 'name'");
    }

    @Test
    public void testUpdateArray() throws Exception {
        String query = "UPDATE item set strarray = ('1','2')";
        Mockito.stub((Object)connection.performUpdate(Mockito.anyString(), Mockito.anyMap(), Mockito.anyString())).toReturn((Object)100);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        UpdateExecution exec = translator.createUpdateExecution(cmd, context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        ArgumentCaptor item = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor select = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor args = ArgumentCaptor.forClass(HashMap.class);
        ((SimpleDBConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).performUpdate((String)item.capture(), (Map)args.capture(), (String)select.capture());
        System.out.println();
        Assert.assertEquals((Object)"1,2,", (Object)this.arrayToStr((String[])((HashMap)args.getAllValues().get(0)).get("strarray")));
        Assert.assertEquals((Object)"item", item.getAllValues().get(0));
        Assert.assertEquals((Object)"SELECT itemName() FROM item", select.getAllValues().get(0));
    }

    @Test
    public void testDelete() throws Exception {
        String query = "delete from item where somedate = {ts '2014-04-04 10:50:45'}";
        Mockito.stub((Object)connection.performDelete(Mockito.anyString(), Mockito.anyString())).toReturn((Object)100);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        UpdateExecution exec = translator.createUpdateExecution(cmd, context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        ((SimpleDBConnection)Mockito.verify((Object)connection)).performDelete("item", "SELECT itemName() FROM item WHERE somedate = '2014-04-04 10:50:45.0'");
    }

    @Test
    public void testDeleteAll() throws Exception {
        String query = "delete from item";
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        UpdateExecution exec = translator.createUpdateExecution(cmd, context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        ((SimpleDBConnection)Mockito.verify((Object)connection)).deleteDomain("item");
    }

    @Test
    public void testInsert() throws Exception {
        String query = "insert into item (\"itemName()\", attribute, somedate, strarray) values ('one', 'value', {ts '2014-04-04 10:50:45'}, ('1', '2'))";
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        UpdateExecution exec = translator.createUpdateExecution(cmd, context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        SimpleDBInsertVisitor visitor = new SimpleDBInsertVisitor();
        visitor.visitNode((LanguageObject)cmd);
        ArgumentCaptor argument = ArgumentCaptor.forClass(Iterator.class);
        ArgumentCaptor itemName = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor columns = ArgumentCaptor.forClass(ArrayList.class);
        ((SimpleDBConnection)Mockito.verify((Object)connection)).performInsert((String)itemName.capture(), (List)columns.capture(), (Iterator)argument.capture());
        Assert.assertEquals((Object)"item", (Object)itemName.getValue());
        List values = (List)((Iterator)argument.getValue()).next();
        Assert.assertEquals((Object)"value", values.get(1));
        Assert.assertEquals((Object)"2014-04-04 10:50:45.0", (Object)values.get(2).toString());
        Assert.assertEquals((Object)"1,2,", (Object)this.arrayToStr((String[])values.get(3)));
    }

    private String arrayToStr(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]).append(",");
        }
        return sb.toString();
    }

    private List<Item> mockResult() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("a1", "a1"));
        attributes.add(new Attribute("a2", "a2"));
        attributes.add(new Attribute("a2", "a22"));
        ArrayList<Item> items = new ArrayList<Item>();
        items.add(new Item("one", attributes));
        return items;
    }

    @Test
    public void testDirectExecution() throws Exception {
        SelectResult result = new SelectResult();
        result.setItems(this.mockResult());
        String query = "select * from item where attribute > 'name'";
        Mockito.stub((Object)connection.performSelect(Mockito.anyString(), Mockito.anyString())).toReturn((Object)result);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        Argument arg = new Argument(Argument.Direction.IN, String.class, (ProcedureParameter)Mockito.mock(ProcedureParameter.class));
        arg.setArgumentValue(LanguageFactory.INSTANCE.createLiteral((Object)query, String.class));
        arguments.add(arg);
        ProcedureExecution exec = translator.createDirectExecution(arguments, cmd, context, (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class), connection);
        exec.execute();
        List row = exec.next();
        ((SimpleDBConnection)Mockito.verify((Object)connection)).performSelect("select * from item where attribute > 'name'", null);
        Object[] results = (Object[])row.get(0);
        Assert.assertEquals((Object)"a1", (Object)results[0]);
        Assert.assertEquals((Object)"[a2, a22]", (Object)results[1]);
    }
}

