/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.SimpleDBPlugin;

public class SimpleDBSQLVisitor
extends SQLStringVisitor {
    private List<String> projectedColumns = new ArrayList<String>();
    private ArrayList<TranslatorException> exceptions = new ArrayList();
    private Column previousColumn;
    private boolean skipCompare;

    public void checkExceptions() throws TranslatorException {
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
    }

    public void visit(Select obj) {
        this.buffer.append("SELECT").append(" ");
        ArrayList<DerivedColumn> allowedColumns = new ArrayList<DerivedColumn>();
        boolean otherCols = false;
        for (int i = 0; i < obj.getDerivedColumns().size(); ++i) {
            DerivedColumn dc = (DerivedColumn)obj.getDerivedColumns().get(i);
            if (!(dc.getExpression() instanceof ColumnReference)) {
                otherCols = true;
                break;
            }
            ColumnReference column = (ColumnReference)dc.getExpression();
            if (SimpleDBMetadataProcessor.isItemName(column.getMetadataObject())) continue;
            otherCols = true;
            break;
        }
        boolean addedItemName = false;
        for (int i = 0; i < obj.getDerivedColumns().size(); ++i) {
            DerivedColumn dc = (DerivedColumn)obj.getDerivedColumns().get(i);
            if (dc.getExpression() instanceof ColumnReference) {
                ColumnReference column = (ColumnReference)dc.getExpression();
                if (SimpleDBMetadataProcessor.isItemName(column.getMetadataObject())) {
                    if (!addedItemName && !otherCols) {
                        allowedColumns.add(dc);
                        addedItemName = true;
                    }
                } else {
                    allowedColumns.add(dc);
                }
                this.projectedColumns.add(SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)column.getMetadataObject()));
                continue;
            }
            if (dc.getExpression() instanceof AggregateFunction) {
                allowedColumns.add(dc);
                this.projectedColumns.add("Count");
                continue;
            }
            this.exceptions.add(new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24004, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24004, new Object[]{dc})));
        }
        this.append(allowedColumns);
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            this.buffer.append(" ").append("FROM").append(" ");
            this.append(obj.getFrom());
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((LanguageObject)obj.getWhere());
        }
        if (obj.getOrderBy() != null) {
            this.validateOrderBy(obj);
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getOrderBy());
        }
    }

    private void validateOrderBy(Select obj) {
        Collection whereColumns = CollectorVisitor.collectElements((LanguageObject)obj.getWhere());
        for (SortSpecification sort : obj.getOrderBy().getSortSpecifications()) {
            boolean matched = false;
            for (ColumnReference where : whereColumns) {
                ColumnReference col = (ColumnReference)sort.getExpression();
                if (!col.getName().equals(where.getName())) continue;
                matched = true;
            }
            if (matched) continue;
            this.exceptions.add(new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24005, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24005, new Object[0])));
            break;
        }
    }

    public void visit(Comparison obj) {
        this.append((LanguageObject)obj.getLeftExpression());
        if (!this.skipCompare) {
            this.buffer.append(" ");
            if (obj.getOperator().equals((Object)Comparison.Operator.NE)) {
                this.buffer.append("!=");
            } else {
                this.buffer.append(obj.getOperator());
            }
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getRightExpression());
        }
        this.skipCompare = false;
    }

    public void visit(Array array) {
        List exprs = array.getExpressions();
        this.append((LanguageObject)exprs.get(0));
        for (int i = 1; i < exprs.size(); ++i) {
            this.buffer.append(" ").append(AndOr.Operator.OR).append(" ");
            this.buffer.append(SQLStringVisitor.getRecordName((AbstractMetadataRecord)this.previousColumn));
            this.buffer.append(" ").append("=").append(" ");
            this.append((LanguageObject)exprs.get(i));
        }
    }

    public void visit(Literal obj) {
        if (obj.getValue() == null) {
            this.buffer.append("NULL");
        } else {
            String val = obj.getValue().toString();
            this.buffer.append("'").append(this.escapeString(val, "'")).append("'");
        }
    }

    public void visit(Function obj) {
        String name = obj.getName();
        List args = obj.getParameters();
        if (name.equalsIgnoreCase("INTERSECTION") || name.equalsIgnoreCase("SIMPLEDB.INTERSECTION")) {
            this.append((LanguageObject)args.get(0));
            this.buffer.append(" ").append("=").append(" ");
            for (int i = 1; i < args.size(); ++i) {
                this.append((LanguageObject)args.get(i));
                if (i >= args.size() - 1) continue;
                this.buffer.append(" ").append("INTERSECTION").append(" ");
                this.buffer.append(SQLStringVisitor.getRecordName((AbstractMetadataRecord)this.previousColumn));
                this.buffer.append(" ").append("=").append(" ");
            }
            this.skipCompare = true;
        } else {
            super.visit(obj);
        }
    }

    public void visit(ColumnReference obj) {
        this.buffer.append(SQLStringVisitor.getRecordName((AbstractMetadataRecord)obj.getMetadataObject()));
        this.previousColumn = obj.getMetadataObject();
    }

    public List<String> getProjectedColumns() {
        return this.projectedColumns;
    }

    public static String getSQLString(LanguageObject obj) {
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append(obj);
        return visitor.toString();
    }
}

