/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import org.teiid.language.Command;
import org.teiid.language.Update;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.SimpleDBUpdateVisitor;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

public class SimpleDBUpdateExecute
implements UpdateExecution {
    private SimpleDBUpdateVisitor visitor;
    private SimpleDBConnection connection;
    private int updatedCount = 0;

    public SimpleDBUpdateExecute(Command command, SimpleDBConnection connection) throws TranslatorException {
        this.connection = connection;
        this.visitor = new SimpleDBUpdateVisitor((Update)command);
        this.visitor.checkExceptions();
    }

    public void execute() throws TranslatorException {
        String domainName = SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)this.visitor.getTable());
        this.updatedCount = this.connection.performUpdate(domainName, this.visitor.getAttributes(), this.buildSelect());
    }

    private String buildSelect() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append("itemName()");
        sb.append(" FROM ").append(SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)this.visitor.getTable()));
        if (this.visitor.getCriteria() != null) {
            sb.append(" WHERE ").append(this.visitor.getCriteria());
        }
        return sb.toString();
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.updatedCount};
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

