/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb.visitors;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.TestDDLParser;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.SimpleDBExecutionFactory;
import org.teiid.translator.simpledb.SimpleDBSQLVisitor;

public class TestSimpleDBSQLVisitor {
    @Test
    public void testSelect() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" string, attribute string);", (String)"x", (String)"y");
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)tm);
        Command c = tu.parseCommand("select \"itemname()\" from item");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT itemName() FROM item", (Object)visitor.toString());
        c = tu.parseCommand("select \"itemname()\", attribute from item");
        visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item", (Object)visitor.toString());
        Assert.assertEquals((long)2L, (long)visitor.getProjectedColumns().size());
    }

    @Test
    public void testSelectCountStar() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" string, attribute string);", (String)"x", (String)"y");
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)tm);
        Command c = tu.parseCommand("select count(*) from item");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT COUNT(*) FROM item", (Object)visitor.toString());
        Assert.assertEquals(Arrays.asList("Count"), (Object)visitor.getProjectedColumns());
    }

    @Test
    public void testNE() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" string, attribute string);", (String)"x", (String)"y");
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)tm);
        Command c = tu.parseCommand("select \"itemname()\" from item where \"itemname()\" <> 'name'");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT itemName() FROM item WHERE itemName() != 'name'", (Object)visitor.toString());
    }

    @Test
    public void testComparisionWithOR() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" string, attribute string);", (String)"x", (String)"y");
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)tm);
        Command c = tu.parseCommand("select \"itemname()\" from item where \"itemname()\" > 'name' and attribute < 'name'");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT itemName() FROM item WHERE itemName() > 'name' AND attribute < 'name'", (Object)visitor.toString());
    }

    @Test(expected=TranslatorException.class)
    public void testOrderBy() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" string, attribute string);", (String)"x", (String)"y");
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)tm);
        Command c = tu.parseCommand("select * from item order by \"itemName()\"");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        visitor.checkExceptions();
        Assert.assertEquals((Object)"SELECT attribute FROM item ORDER BY itemName()", (Object)visitor.toString());
    }

    @Test
    public void testOrderByAllow() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" string, attribute string);", (String)"x", (String)"y");
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)tm);
        Command c = tu.parseCommand("select * from item where \"itemName()\" = 'name' order by \"itemName()\"");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        visitor.checkExceptions();
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE itemName() = 'name' ORDER BY itemName()", (Object)visitor.toString());
    }

    @Test
    public void testIN() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL((String)"create foreign table item (\"itemName()\" integer, attribute string);", (String)"x", (String)"y");
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)tm);
        Command c = tu.parseCommand("select * from item where \"itemName()\" in (1, 2)");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE itemName() IN ('1', '2')", (Object)visitor.toString());
    }

    @Test
    public void testEvery() throws Exception {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)"create foreign table item (\"itemName()\" integer, attribute string[]);", (String)"y");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command c = tu.parseCommand("select * from item where simpledb.every(attribute) = '1'");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE SIMPLEDB.EVERY(attribute) = '1'", (Object)visitor.toString());
    }

    @Test
    public void testEveryLike() throws Exception {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)"create foreign table item (\"itemName()\" integer, attribute string[]);", (String)"y");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command c = tu.parseCommand("select * from item where simpledb.every(attribute) like '1%'");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE SIMPLEDB.EVERY(attribute) LIKE '1%'", (Object)visitor.toString());
    }

    @Test
    public void testEveryNotNull() throws Exception {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)"create foreign table item (\"itemName()\" integer, attribute string[]);", (String)"y");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command c = tu.parseCommand("select * from item where simpledb.every(attribute) is not null");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE SIMPLEDB.EVERY(attribute) IS NOT NULL", (Object)visitor.toString());
    }

    @Test
    public void testEvery2() throws Exception {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)"create foreign table item (\"itemName()\" integer, attribute string[]);", (String)"y");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command c = tu.parseCommand("select * from item where simpledb.every(attribute) = '1' or  simpledb.every(attribute) = '2'");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE SIMPLEDB.EVERY(attribute) IN ('2', '1')", (Object)visitor.toString());
    }

    @Test
    public void testIntersection() throws Exception {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)"create foreign table item (\"itemName()\" integer, attribute string[]);", (String)"y");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command c = tu.parseCommand("select * from item where simpledb.intersection(attribute,'1', '2')");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE attribute = '1' INTERSECTION attribute = '2'", (Object)visitor.toString());
    }

    @Test
    public void testIntersection2() throws Exception {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)"create foreign table item (\"itemName()\" integer, attribute string[]);", (String)"y");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command c = tu.parseCommand("select * from item where simpledb.intersection(attribute,'1', '2', '3') = true");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE attribute = '1' INTERSECTION attribute = '2' INTERSECTION attribute = '3'", (Object)visitor.toString());
    }

    @Test
    public void testArrayCompare() throws Exception {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)"create foreign table item (\"itemName()\" integer, attribute string[]);", (String)"y");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"x", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        TranslationUtility tu = new TranslationUtility((QueryMetadataInterface)metadata);
        Command c = tu.parseCommand("select * from item where attribute = ('1','2')");
        SimpleDBSQLVisitor visitor = new SimpleDBSQLVisitor();
        visitor.append((LanguageObject)c);
        Assert.assertEquals((Object)"SELECT attribute FROM item WHERE attribute = '1' OR attribute = '2'", (Object)visitor.toString());
    }
}

