/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.simpledb.SimpleDBDeleteVisitor;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

public class SimpleDBDeleteExecute
implements UpdateExecution {
    private SimpleDBConnection connection;
    private int updatedCount = 0;
    private SimpleDBDeleteVisitor visitor;

    public SimpleDBDeleteExecute(Command command, SimpleDBConnection connection) throws TranslatorException {
        this.connection = connection;
        this.visitor = new SimpleDBDeleteVisitor((Delete)command);
        this.visitor.checkExceptions();
    }

    public void execute() throws TranslatorException {
        String domainName = SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)this.visitor.getTable());
        if (this.visitor.getCriteria() != null) {
            this.updatedCount = this.connection.performDelete(domainName, this.buildSelect());
        } else {
            this.connection.deleteDomain(domainName);
        }
    }

    private String buildSelect() {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ").append("itemName()");
        sb.append(" FROM ").append(SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)this.visitor.getTable()));
        sb.append(" WHERE ").append(this.visitor.getCriteria());
        return sb.toString();
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return new int[]{this.updatedCount};
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

