/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb.visitors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.SimpleDBExecutionFactory;
import org.teiid.translator.simpledb.api.SimpleDBConnection;

public class TestSimpleDBMetadataProcessor {
    static String getDDL(Properties props) throws TranslatorException {
        SimpleDBExecutionFactory translator = new SimpleDBExecutionFactory();
        translator.start();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "people", SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        SimpleDBConnection connection = (SimpleDBConnection)Mockito.mock(SimpleDBConnection.class);
        Mockito.stub((Object)connection.getDomains()).toReturn(Arrays.asList("G1", "G2"));
        HashSet<SimpleDBConnection.SimpleDBAttribute> cols = new HashSet<SimpleDBConnection.SimpleDBAttribute>();
        cols.add(new SimpleDBConnection.SimpleDBAttribute("e1", false));
        cols.add(new SimpleDBConnection.SimpleDBAttribute("e2", false));
        Mockito.stub((Object)connection.getAttributeNames("G1")).toReturn(cols);
        HashSet<SimpleDBConnection.SimpleDBAttribute> cols2 = new HashSet<SimpleDBConnection.SimpleDBAttribute>();
        cols2.add(new SimpleDBConnection.SimpleDBAttribute("e1", false));
        cols2.add(new SimpleDBConnection.SimpleDBAttribute("e2", true));
        Mockito.stub((Object)connection.getAttributeNames("G2")).toReturn(cols2);
        translator.getMetadata(mf, (Object)connection);
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"vdb", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)translator.getPushDownFunctions()))});
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        return ddl;
    }

    @Test
    public void testSchema() throws Exception {
        Properties props = new Properties();
        String ddl = TestSimpleDBMetadataProcessor.getDDL(props);
        String expectedDDL = "CREATE FOREIGN TABLE G1 (\n\tItemName string NOT NULL OPTIONS (NAMEINSOURCE 'itemName()'),\n\te1 string OPTIONS (NAMEINSOURCE '`e1`'),\n\te2 string OPTIONS (NAMEINSOURCE '`e2`'),\n\tCONSTRAINT PK0 PRIMARY KEY(ItemName)\n) OPTIONS (NAMEINSOURCE '`G1`', UPDATABLE TRUE);\n\nCREATE FOREIGN TABLE G2 (\n\tItemName string NOT NULL OPTIONS (NAMEINSOURCE 'itemName()'),\n\te1 string OPTIONS (NAMEINSOURCE '`e1`'),\n\te2 string[] OPTIONS (NAMEINSOURCE '`e2`'),\n\tCONSTRAINT PK0 PRIMARY KEY(ItemName)\n) OPTIONS (NAMEINSOURCE '`G2`', UPDATABLE TRUE);";
        Assert.assertEquals((Object)expectedDDL, (Object)ddl);
    }
}

