/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb.api;

import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.amazonaws.services.simpledb.util.SimpleDBUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.api.SimpleDBConnectionImpl;

public class TestSimpleDBConnectionImpl {
    private SimpleDBConnectionImpl simpleDBConnection;
    private AmazonSimpleDBClient simpleDBClient = (AmazonSimpleDBClient)Mockito.mock(AmazonSimpleDBClient.class);

    @Before
    public void setUp() {
        this.simpleDBConnection = new SimpleDBConnectionImpl((AmazonSimpleDB)this.simpleDBClient);
    }

    @Test
    public void testCreateDomain() throws TranslatorException {
        String domainName = "abc";
        this.simpleDBConnection.createDomain(domainName);
        ((AmazonSimpleDBClient)Mockito.verify((Object)this.simpleDBClient, (VerificationMode)Mockito.times((int)1))).createDomain(new CreateDomainRequest(domainName));
    }

    @Test
    public void testDeleteDomain() throws TranslatorException {
        String domainName = "abc";
        this.simpleDBConnection.deleteDomain(domainName);
        ((AmazonSimpleDBClient)Mockito.verify((Object)this.simpleDBClient, (VerificationMode)Mockito.times((int)1))).deleteDomain(new DeleteDomainRequest(domainName));
    }

    @Test
    public void testGetDomains() throws TranslatorException {
        ListDomainsResult listDomainsResult = (ListDomainsResult)Mockito.mock(ListDomainsResult.class);
        List<String> domainName = Arrays.asList("abc", "def");
        Mockito.when((Object)listDomainsResult.getDomainNames()).thenReturn(domainName);
        Mockito.when((Object)this.simpleDBClient.listDomains()).thenReturn((Object)listDomainsResult);
        Assert.assertEquals(domainName, (Object)this.simpleDBConnection.getDomains());
    }

    @Test
    public void testGetAttributeNames() throws TranslatorException {
        String domainName = "abc";
        DomainMetadataResult domainMetadataResult = (DomainMetadataResult)Mockito.mock(DomainMetadataResult.class);
        Mockito.when((Object)domainMetadataResult.getAttributeNameCount()).thenReturn((Object)0);
        Mockito.when((Object)this.simpleDBClient.domainMetadata((DomainMetadataRequest)Matchers.any(DomainMetadataRequest.class))).thenReturn((Object)domainMetadataResult);
        SelectResult selectResult = (SelectResult)Mockito.mock(SelectResult.class);
        Mockito.when((Object)this.simpleDBClient.select(new SelectRequest("SELECT * FROM " + SimpleDBUtils.quoteName((String)domainName)))).thenReturn((Object)selectResult);
        this.simpleDBConnection.getAttributeNames(domainName);
    }

    @Test
    public void testAddNullAttribute() throws Exception {
        ArrayList attributes = new ArrayList();
        this.simpleDBConnection.addAttribute("x", null, attributes);
        Assert.assertNull((Object)((ReplaceableAttribute)attributes.get(0)).getValue());
    }
}

