/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb.api;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpledb.AmazonSimpleDB;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.AmazonSimpleDBClientBuilder;
import org.teiid.logging.LogManager;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.api.BaseSimpleDBConfiguration;

public class SimpleDBConnectionFactory {
    private final BaseSimpleDBConfiguration simpleDBConfig;
    private final AWSStaticCredentialsProvider awsStaticCredentialsProvider;
    private AmazonSimpleDB simpleDBClient;

    public SimpleDBConnectionFactory(BaseSimpleDBConfiguration simpleDBConfig) throws TranslatorException {
        this.simpleDBConfig = simpleDBConfig;
        if (simpleDBConfig.getAccessKey() == null) {
            throw new TranslatorException("Access key can't be null.");
        }
        if (simpleDBConfig.getSecretKey() == null) {
            throw new TranslatorException("Secret key can't be null.");
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(simpleDBConfig.getAccessKey(), simpleDBConfig.getSecretKey());
        this.awsStaticCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        try {
            this.getSimpleDBClient();
        }
        catch (SdkClientException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Failed to make initial simpledb connection", (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmazonSimpleDB getSimpleDBClient() {
        if (this.simpleDBClient == null) {
            SimpleDBConnectionFactory simpleDBConnectionFactory = this;
            synchronized (simpleDBConnectionFactory) {
                if (this.simpleDBClient == null) {
                    this.simpleDBClient = (AmazonSimpleDB)((AmazonSimpleDBClientBuilder)AmazonSimpleDBClient.builder().withCredentials((AWSCredentialsProvider)this.awsStaticCredentialsProvider)).build();
                }
            }
        }
        return this.simpleDBClient;
    }

    public BaseSimpleDBConfiguration getSimpleDBConfig() {
        return this.simpleDBConfig;
    }
}

