/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.QueryExpression;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.SimpleDBPlugin;
import org.teiid.translator.simpledb.api.SimpleDBDataTypeManager;

public class SimpleDBInsertVisitor
extends HierarchyVisitor {
    private Iterator<? extends List<?>> values;
    private List<Object> expressionValues = new ArrayList<Object>();
    private List<Column> columns = new ArrayList<Column>();
    private ArrayList<TranslatorException> exceptions = new ArrayList();
    private String tableName;

    public void checkExceptions() throws TranslatorException {
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Iterator<? extends List<?>> values() {
        if (this.values != null) {
            return this.values;
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(1);
        result.add(this.expressionValues);
        return result.iterator();
    }

    public String getDomainName() {
        return this.tableName;
    }

    public void visit(Insert obj) {
        this.visitNode((LanguageObject)obj.getTable());
        this.visitNodes(obj.getColumns());
        if (!(obj.getValueSource() instanceof QueryExpression) && obj.getParameterValues() == null) {
            this.visitNode((LanguageObject)obj.getValueSource());
        } else {
            this.values = obj.getParameterValues();
        }
    }

    public void visit(NamedTable obj) {
        this.tableName = SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)obj.getMetadataObject());
    }

    public void visit(ColumnReference obj) {
        this.columns.add(obj.getMetadataObject());
        super.visit(obj);
    }

    public void visit(ExpressionValueSource obj) {
        try {
            List values = obj.getValues();
            for (int i = 0; i < obj.getValues().size(); ++i) {
                if (values.get(i) instanceof Literal) {
                    Literal lit = (Literal)values.get(i);
                    this.expressionValues.add(lit.getValue());
                    continue;
                }
                if (values.get(i) instanceof Array) {
                    Array array = (Array)values.get(i);
                    String[] result = SimpleDBInsertVisitor.getValuesArray(array);
                    this.expressionValues.add(result);
                    continue;
                }
                this.exceptions.add(new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24001, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24001, new Object[0])));
            }
            super.visit(obj);
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    static String[] getValuesArray(Array array) throws TranslatorException {
        String[] result = new String[array.getExpressions().size()];
        for (int j = 0; j < array.getExpressions().size(); ++j) {
            Expression expr = (Expression)array.getExpressions().get(j);
            if (expr instanceof Literal) {
                Literal lit = (Literal)expr;
                result[j] = (String)SimpleDBDataTypeManager.convertToSimpleDBType(lit.getValue(), lit.getType());
                continue;
            }
            new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24001, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24001, new Object[0]));
        }
        return result;
    }
}

