/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.simpledb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.teiid.core.BundleUtil;
import org.teiid.language.Array;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.simpledb.SimpleDBInsertVisitor;
import org.teiid.translator.simpledb.SimpleDBMetadataProcessor;
import org.teiid.translator.simpledb.SimpleDBPlugin;
import org.teiid.translator.simpledb.SimpleDBSQLVisitor;
import org.teiid.translator.simpledb.api.SimpleDBDataTypeManager;

public class SimpleDBUpdateVisitor
extends HierarchyVisitor {
    private Table table;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private String criteria;
    private ArrayList<TranslatorException> exceptions = new ArrayList();

    public SimpleDBUpdateVisitor(Update update) {
        this.visitNode((LanguageObject)update);
    }

    public void checkExceptions() throws TranslatorException {
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
    }

    public void visit(Update obj) {
        if (obj.getParameterValues() != null) {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24006, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24006, new Object[0])));
        }
        this.table = obj.getTable().getMetadataObject();
        for (SetClause setClause : obj.getChanges()) {
            this.visitNode((LanguageObject)setClause);
        }
        if (obj.getWhere() != null) {
            this.criteria = SimpleDBSQLVisitor.getSQLString((LanguageObject)obj.getWhere());
        }
    }

    public void visit(SetClause obj) {
        Column column = obj.getSymbol().getMetadataObject();
        if (obj.getValue() instanceof Literal) {
            try {
                Literal l = (Literal)obj.getValue();
                this.attributes.put(SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)column), SimpleDBDataTypeManager.convertToSimpleDBType(l.getValue(), column.getJavaType()));
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        } else if (obj.getValue() instanceof Array) {
            try {
                Array array = (Array)obj.getValue();
                String[] result = SimpleDBInsertVisitor.getValuesArray(array);
                this.attributes.put(SimpleDBMetadataProcessor.getName((AbstractMetadataRecord)column), result);
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        } else {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24001, SimpleDBPlugin.Util.gs((BundleUtil.Event)SimpleDBPlugin.Event.TEIID24001, new Object[0])));
        }
    }

    public Table getTable() {
        return this.table;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getCriteria() {
        return this.criteria;
    }
}

