/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.luke.FieldFlag;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.solr.SolrConnection;
import org.teiid.translator.solr.SolrMetadataProcessor;

public class TestSolrMetadataProcessor {
    private LukeResponse.FieldInfo buildField(String name, String type, EnumSet<FieldFlag> flags) {
        LukeResponse.FieldInfo info = (LukeResponse.FieldInfo)Mockito.mock(LukeResponse.FieldInfo.class);
        Mockito.stub((Object)info.getName()).toReturn((Object)name);
        Mockito.stub((Object)info.getType()).toReturn((Object)type);
        Mockito.stub((Object)info.getFlags()).toReturn(flags);
        return info;
    }

    @Test
    public void testMetadata() throws TranslatorException {
        SolrMetadataProcessor mp = new SolrMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "solr", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        SolrConnection conn = (SolrConnection)Mockito.mock(SolrConnection.class);
        Mockito.stub((Object)conn.getCoreName()).toReturn((Object)"SomeTable");
        LinkedHashMap<String, LukeResponse.FieldInfo> fields = new LinkedHashMap<String, LukeResponse.FieldInfo>();
        fields.put("col1", this.buildField("col1", "string", EnumSet.of(FieldFlag.STORED, FieldFlag.INDEXED)));
        fields.put("col2", this.buildField("col2", "int", EnumSet.of(FieldFlag.STORED, FieldFlag.INDEXED)));
        fields.put("col3", this.buildField("col3", "int", EnumSet.of(FieldFlag.STORED, FieldFlag.INDEXED, FieldFlag.MULTI_VALUED)));
        fields.put("id", this.buildField("id", "long", EnumSet.of(FieldFlag.STORED, FieldFlag.INDEXED)));
        LukeResponse response = (LukeResponse)Mockito.mock(LukeResponse.class);
        Mockito.stub((Object)response.getFieldInfo()).toReturn(fields);
        Mockito.stub((Object)conn.metadata((LukeRequest)Mockito.any(LukeRequest.class))).toReturn((Object)response);
        mp.process(mf, conn);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "CREATE FOREIGN TABLE SomeTable (\n\tcol1 string OPTIONS (SEARCHABLE 'Searchable'),\n\tcol2 integer OPTIONS (SEARCHABLE 'Searchable'),\n\tcol3 integer[] OPTIONS (SEARCHABLE 'Searchable'),\n\tid long OPTIONS (SEARCHABLE 'Searchable'),\n\tCONSTRAINT PK0 PRIMARY KEY(id)\n) OPTIONS (UPDATABLE TRUE);";
        Assert.assertEquals((Object)expected, (Object)metadataDDL);
    }
}

