/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.cdk.CommandBuilder;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.language.Select;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.solr.SolrExecutionFactory;
import org.teiid.translator.solr.SolrSQLHierarchyVistor;

public class TestTeiidLanguageToSolr {
    private TransformationMetadata metadata;
    private SolrExecutionFactory translator;
    private TranslationUtility utility;

    private QueryMetadataInterface setUp(String ddl, String vdbName, String modelName) throws Exception {
        this.translator = new SolrExecutionFactory();
        this.translator.start();
        this.metadata = RealMetadataFactory.fromDDL((String)ddl, (String)vdbName, (String)modelName);
        this.utility = new TranslationUtility((QueryMetadataInterface)this.metadata);
        return this.metadata;
    }

    private String getSolrTranslation(String sql) throws IOException, Exception {
        Select select = (Select)this.getCommand(sql);
        SolrSQLHierarchyVistor visitor = new SolrSQLHierarchyVistor(this.utility.createRuntimeMetadata(), this.translator);
        visitor.visit(select);
        String cmd = visitor.getSolrQuery().toString();
        return URLDecoder.decode(cmd, "UTF-8");
    }

    public Command getCommand(String sql) throws IOException, Exception {
        CommandBuilder builder = new CommandBuilder(this.setUp(ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"exampleTBL.ddl")), "exampleVDB", "exampleModel"));
        return builder.getCommand(sql);
    }

    @Test
    public void testSelectStar() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity,name,purchasets,purchasetime,purchasedate,nis&q=*:*", (Object)this.getSolrTranslation("select * from example"));
    }

    @Test
    public void testSelectColumn() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight&q=*:*", (Object)this.getSolrTranslation("select price,weight from example"));
    }

    @Test
    public void testSelectWhereEQ() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=price:1.0", (Object)this.getSolrTranslation("select price,weight,popularity from example where price=1"));
    }

    @Test
    public void testSelectWhereEQNegitive() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=price:\\-1.0", (Object)this.getSolrTranslation("select price,weight,popularity from example where price=-1"));
    }

    @Test
    public void testSelectWhereNE() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=NOT price:1.0", (Object)this.getSolrTranslation("select price,weight,popularity from example where price!=1"));
    }

    @Test
    public void testSelectWhereNEString() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=NOT name:test", (Object)this.getSolrTranslation("select price,weight,popularity from example where name!='test'"));
    }

    @Test
    public void testSelectWhereGT() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=price:[1.0 TO *] AND NOT price:1.0", (Object)this.getSolrTranslation("select price,weight,popularity from example where price>1"));
    }

    @Test
    public void testSelectWhereGE() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=price:[1.0 TO *]", (Object)this.getSolrTranslation("select price,weight,popularity from example where price>=1"));
    }

    @Test
    public void testSelectWhereLT() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=price:[* TO 1.0] AND NOT price:1.0", (Object)this.getSolrTranslation("select price,weight,popularity from example where price<1"));
    }

    @Test
    public void testSelectWhereLE() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=price:[* TO 1.0]", (Object)this.getSolrTranslation("select price,weight,popularity from example where price<=1"));
    }

    @Test
    public void testSelectWhereNEQ() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=NOT price:1.0", (Object)this.getSolrTranslation("select price,weight,popularity from example where price!=1"));
    }

    @Test
    public void testSelectWhenOr() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((price:1.0) OR (weight:[5.0 TO *]))", (Object)this.getSolrTranslation("select price,weight,popularity from example where price=1 or weight >=5"));
    }

    @Test
    public void testSelectWhenNotOr() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((NOT price:1.0) AND (weight:[* TO 5.0]))", (Object)this.getSolrTranslation("select price,weight,popularity from example where Not (price=1 or weight >5)"));
    }

    @Test
    public void testSelectWhenNotOrString() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((NOT name:*sung) AND (weight:[* TO 5.0]))", (Object)this.getSolrTranslation("select price,weight,popularity from example where Not (name like '%sung' or weight >5)"));
    }

    @Test
    public void testSelectWhenAnd() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((price:1.0) AND (weight:[5.0 TO *]))", (Object)this.getSolrTranslation("select price,weight,popularity from example where price=1 AND weight >=5"));
    }

    @Test
    public void testSelectWhenAndOr() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((((weight:[5.0 TO *] AND NOT weight:5.0) AND (price:1.0))) OR (weight:[5.0 TO *] AND NOT weight:5.0))", (Object)this.getSolrTranslation("select price,weight,popularity from example where weight > 5 AND price=1 or weight > 5"));
    }

    @Test
    public void testSelectWhenAndOrOr() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((((weight:[5.0 TO *] AND NOT weight:5.0) AND (price:1.0))) OR (((weight:[5.0 TO *] AND NOT weight:5.0) OR (popularity:[* TO 1] AND NOT popularity:1))))", (Object)this.getSolrTranslation("select price,weight,popularity from example where weight > 5 AND price=1 or weight > 5 or popularity < 1"));
    }

    @Test
    public void testSelectWhenLike() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=name:*sung", (Object)this.getSolrTranslation("select price,weight,popularity from example where name like '%sung'"));
    }

    @Test
    public void testSelectWhenLikeAnd() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((name:*sung) AND (price:1.0))", (Object)this.getSolrTranslation("select price,weight,popularity from example where name like '%sung' and price=1"));
    }

    @Test
    public void testSelectWhenOrLikeAnd() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((popularity:[* TO 1]) OR (((name:*sung) AND (price:1.0))))", (Object)this.getSolrTranslation("select price,weight,popularity from example where popularity <= 1 Or name like '%sung' and price=1"));
    }

    @Test
    public void testSelectWhenOrNotLikeAnd() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((popularity:[* TO 1]) OR (((NOT name:*sung) AND (price:1.0))))", (Object)this.getSolrTranslation("select price,weight,popularity from example where popularity <= 1 Or name not like '%sung' and price=1"));
    }

    @Test
    public void testSelectWhenInString() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=name:(3 OR 2 OR 1)", (Object)this.getSolrTranslation("select price,weight,popularity from example where name in ('1','2','3')"));
    }

    @Test
    public void testSelectWhenIn() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=popularity:(3 OR 2 OR 1)", (Object)this.getSolrTranslation("select price,weight,popularity from example where popularity in (1,2,3)"));
    }

    @Test
    public void testSelectWhenOrInAnd() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((weight:1.0) OR (((popularity:(3 OR 2 OR 1)) AND (price:1.0))))", (Object)this.getSolrTranslation("select price,weight,popularity from example where weight = 1 or popularity in (1,2,3) and price = 1"));
    }

    @Test
    public void testSelectWhenNotIn() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=NOT popularity:(3 OR 2 OR 1)", (Object)this.getSolrTranslation("select price,weight,popularity from example where  popularity not in (1,2,3)"));
    }

    @Test
    public void testSelectWhenNotAnd() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((weight:1.0) AND (NOT popularity:(3 OR 2 OR 1)))", (Object)this.getSolrTranslation("select price,weight,popularity from example where weight = 1 AND not popularity in (1,2,3)"));
    }

    @Test
    public void testSelectWhenAndNotAndAndLike() throws Exception {
        Assert.assertEquals((Object)"fl=price,weight,popularity&q=((weight:1.0) AND (((NOT popularity:(3 OR 2 OR 1)) OR (NOT name:*sung))))", (Object)this.getSolrTranslation("select price,weight,popularity from example where weight = 1 AND not (popularity in (1,2,3) and name like '%sung')"));
    }

    @Test
    public void testLimit() throws Exception {
        Assert.assertEquals((Object)"fl=name,popularity&rows=21&start=2&q=*:*", (Object)this.getSolrTranslation("select name,popularity from example limit 2, 21"));
    }

    @Test
    public void testOrderBy() throws Exception {
        Assert.assertEquals((Object)"fl=name,popularity&sort=popularity asc&q=*:*", (Object)this.getSolrTranslation("select name,popularity from example order by popularity ASC"));
    }

    @Test
    public void testOrderByWithAlias() throws Exception {
        Assert.assertEquals((Object)"fl=name,popularity&sort=popularity asc&q=*:*", (Object)this.getSolrTranslation("select name as c_0,popularity c_1 from example order by c_1 ASC"));
    }

    @Test
    public void testTimestampField() throws Exception {
        java.util.Date d = this.getTestDate();
        Assert.assertEquals((Object)"fl=name,purchasedate&q=purchasets:2014\\-02\\-06T19\\:52\\:07\\:000Z", (Object)this.getSolrTranslation("select name,purchasedate from example where purchasets = {ts '" + new Timestamp(d.getTime()) + "'}"));
    }

    @Test
    public void testDateField() throws Exception {
        java.util.Date d = this.getTestDate();
        Assert.assertEquals((Object)"fl=name,purchasedate&q=purchasedate:2014\\-02\\-06T08\\:00\\:00\\:000Z", (Object)this.getSolrTranslation("select name,purchasedate from example where purchasedate = {d '" + new Date(d.getTime()) + "'}"));
    }

    @Test
    public void testTimeField() throws Exception {
        java.util.Date d = this.getTestDate();
        Assert.assertEquals((Object)"fl=name,purchasedate&q=purchasetime:1970\\-01\\-01T19\\:52\\:07\\:000Z", (Object)this.getSolrTranslation("select name,purchasedate from example where purchasetime = {t '" + new Time(d.getTime()) + "'}"));
    }

    private java.util.Date getTestDate() {
        Calendar c = TimestampWithTimezone.getCalendar();
        c.setTimeInMillis(0L);
        c.set(2014, 1, 6, 11, 52, 7);
        return c.getTime();
    }

    @Test
    public void testFunction() throws Exception {
        Assert.assertEquals((Object)"fl=name,sum(popularity,1)&sort=popularity asc&q=*:*", (Object)this.getSolrTranslation("select name,popularity+1 from example order by popularity ASC"));
    }

    @Test
    public void testNestedFunction() throws Exception {
        Assert.assertEquals((Object)"fl=name,div(sum(popularity,1),2)&sort=popularity asc&q=*:*", (Object)this.getSolrTranslation("select name,(popularity+1)/2 as x from example order by popularity ASC"));
    }

    @Before
    public void setUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("PST"));
    }

    @After
    public void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }
}

