/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.common.luke.FieldFlag;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.solr.SolrConnection;

public class SolrMetadataProcessor
implements MetadataProcessor<SolrConnection> {
    public void process(MetadataFactory metadataFactory, SolrConnection connection) throws TranslatorException {
        this.getConnectorMetadata(connection, metadataFactory);
    }

    public void getConnectorMetadata(SolrConnection conn, MetadataFactory metadataFactory) throws TranslatorException {
        int count = 0;
        LukeRequest request = new LukeRequest();
        request.setShowSchema(true);
        LukeResponse response = conn.metadata(request);
        Map fields = response.getFieldInfo();
        Table table = metadataFactory.addTable(conn.getCoreName());
        table.setSupportsUpdate(true);
        for (String name : fields.keySet()) {
            LukeResponse.FieldInfo field = (LukeResponse.FieldInfo)fields.get(name);
            EnumSet flags = field.getFlags();
            if ((name.startsWith("_") || name.endsWith("_")) && !name.startsWith("*") && !name.endsWith("*") || !flags.contains(FieldFlag.INDEXED) || !flags.contains(FieldFlag.STORED)) continue;
            Column column = null;
            column = flags.contains(FieldFlag.MULTI_VALUED) ? metadataFactory.addColumn(field.getName(), this.resolveType(field.getType()) + "[]", (ColumnSet)table) : metadataFactory.addColumn(field.getName(), this.resolveType(field.getType()), (ColumnSet)table);
            column.setUpdatable(true);
            column.setSearchType(Column.SearchType.Searchable);
            if (field.getDistinct() <= 0 && !field.getName().equals("id")) continue;
            if (table.getPrimaryKey() == null) {
                metadataFactory.addPrimaryKey("PK0", Arrays.asList(field.getName()), table);
                continue;
            }
            metadataFactory.addIndex("UI" + count, true, Arrays.asList(field.getName()), table);
            ++count;
        }
    }

    private String resolveType(String solrType) {
        if (solrType.equals("string") || solrType.startsWith("text_") || solrType.equals("alphaOnlySort") || solrType.equals("phonetic") || solrType.equals("payloads") || solrType.equals("lowercase")) {
            return "string";
        }
        if (solrType.equals("int") || solrType.equals("tint") || solrType.equals("pint")) {
            return "integer";
        }
        if (solrType.equals("boolean") || solrType.equals("tboolean") || solrType.equals("pboolean")) {
            return "boolean";
        }
        if (solrType.equals("binary")) {
            return "blob";
        }
        if (solrType.equals("date") || solrType.equals("tdate") || solrType.equals("pdate")) {
            return "timestamp";
        }
        if (solrType.equals("float") || solrType.equals("tfloat") || solrType.equals("pfloat")) {
            return "float";
        }
        if (solrType.equals("long") || solrType.equals("tlong") || solrType.equals("plong")) {
            return "long";
        }
        if (solrType.equals("double") || solrType.equals("tdouble") || solrType.equals("pdouble") || solrType.equals("currency")) {
            return "double";
        }
        return "string";
    }
}

