/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.TimeZone;
import org.apache.solr.client.solrj.SolrQuery;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Function;
import org.teiid.language.In;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.OrderBy;
import org.teiid.language.SortSpecification;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.solr.SolrExecutionFactory;

public class SolrSQLHierarchyVistor
extends HierarchyVisitor {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS'Z'");
    private RuntimeMetadata metadata;
    protected StringBuilder buffer = new StringBuilder();
    private List<String> fieldNameList = new ArrayList<String>();
    protected Stack<String> onGoingExpression = new Stack();
    private boolean limitInUse;
    private SolrQuery query = new SolrQuery();
    private SolrExecutionFactory ef;
    private HashMap<String, String> columnAliasMap = new HashMap();
    private boolean countStarInUse;

    public SolrSQLHierarchyVistor(RuntimeMetadata metadata, SolrExecutionFactory ef) {
        this.metadata = metadata;
        this.ef = ef;
    }

    public void visit(DerivedColumn obj) {
        this.visitNode((LanguageObject)obj.getExpression());
        String expr = this.onGoingExpression.pop();
        if (obj.getAlias() != null) {
            this.columnAliasMap.put(obj.getAlias(), expr);
        }
        this.query.addField(expr);
        this.fieldNameList.add(expr);
    }

    public static String getColumnName(ColumnReference obj) {
        String elemShortName = null;
        Column elementID = obj.getMetadataObject();
        elemShortName = elementID != null ? SQLStringVisitor.getRecordName((AbstractMetadataRecord)elementID) : obj.getName();
        return elemShortName;
    }

    public void visit(ColumnReference obj) {
        if (obj.getMetadataObject() != null) {
            this.onGoingExpression.push(SolrSQLHierarchyVistor.getColumnName(obj));
        } else {
            this.onGoingExpression.push(this.columnAliasMap.get(SolrSQLHierarchyVistor.getColumnName(obj)));
        }
    }

    public List<String> getFieldNameList() {
        return this.fieldNameList;
    }

    public void visit(Comparison obj) {
        this.visitNode((LanguageObject)obj.getLeftExpression());
        String lhs = this.onGoingExpression.pop();
        this.visitNode((LanguageObject)obj.getRightExpression());
        String rhs = this.onGoingExpression.pop();
        if (lhs != null) {
            switch (obj.getOperator()) {
                case EQ: {
                    this.buffer.append(lhs).append(":").append(rhs);
                    break;
                }
                case NE: {
                    this.buffer.append("NOT").append(" ");
                    this.buffer.append(lhs).append(":").append(rhs);
                    break;
                }
                case LE: {
                    this.buffer.append(lhs).append(":[* TO");
                    this.buffer.append(" ").append(rhs).append("]");
                    break;
                }
                case LT: {
                    this.buffer.append(lhs).append(":[* TO");
                    this.buffer.append(" ").append(rhs).append("]");
                    this.buffer.append(" ").append("AND").append(" ");
                    this.buffer.append("NOT").append(" ").append(lhs);
                    this.buffer.append(":").append(rhs);
                    break;
                }
                case GE: {
                    this.buffer.append(lhs).append(":[").append(rhs).append(" TO *]");
                    break;
                }
                case GT: {
                    this.buffer.append(lhs).append(":[").append(rhs);
                    this.buffer.append(" TO *]").append(" ").append("AND").append(" ");
                    this.buffer.append("NOT").append(" ").append(lhs);
                    this.buffer.append(":").append(rhs);
                }
            }
        }
    }

    public void visit(AndOr obj) {
        this.buffer.append("(");
        this.buffer.append("(");
        super.visitNode((LanguageObject)obj.getLeftCondition());
        this.buffer.append(")");
        switch (obj.getOperator()) {
            case AND: {
                this.buffer.append(" ").append("AND").append(" ");
                break;
            }
            case OR: {
                this.buffer.append(" ").append("OR").append(" ");
            }
        }
        this.buffer.append("(");
        super.visitNode((LanguageObject)obj.getRightCondition());
        this.buffer.append(")");
        this.buffer.append(")");
    }

    public void visit(In obj) {
        this.visitNode((LanguageObject)obj.getLeftExpression());
        String lhs = this.onGoingExpression.pop();
        this.visitNodes(obj.getRightExpressions());
        if (obj.isNegated()) {
            this.buffer.append("NOT").append(" ");
        }
        this.buffer.append(lhs).append(":").append("(");
        int i = obj.getRightExpressions().size();
        while (i-- > 0) {
            this.buffer.append(this.onGoingExpression.pop());
            if (i <= 0) continue;
            this.buffer.append(" ").append("OR").append(" ");
        }
        this.buffer.append(")");
    }

    public void visit(Like obj) {
        this.visitNode((LanguageObject)obj.getLeftExpression());
        String lhs = this.onGoingExpression.pop();
        this.visitNode((LanguageObject)obj.getRightExpression());
        String rhs = this.onGoingExpression.pop();
        if (obj.isNegated()) {
            this.buffer.append("NOT").append(" ");
        }
        this.buffer.append(lhs).append(":").append(this.formatSolrQuery(rhs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(Literal obj) {
        if (obj.getValue() == null) {
            this.buffer.append("NULL");
        } else {
            Class type = obj.getType();
            Object val = obj.getValue();
            if (Number.class.isAssignableFrom(type)) {
                this.onGoingExpression.push(this.escapeString(String.valueOf(val)));
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
                this.onGoingExpression.push(obj.getValue().equals(Boolean.TRUE) ? "TRUE" : "FALSE");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP) || type.equals(DataTypeManager.DefaultDataClasses.TIME) || type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                SimpleDateFormat simpleDateFormat = sdf;
                synchronized (simpleDateFormat) {
                    this.onGoingExpression.push(this.escapeString(sdf.format(val)));
                }
            } else {
                this.onGoingExpression.push(this.escapeString(val.toString()));
            }
        }
    }

    protected String escapeString(String str) {
        String[] array = new String[]{"+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":"};
        for (int i = 0; i < array.length; ++i) {
            str = StringUtil.replaceAll((String)str, (String)array[i], (String)("\\" + array[i]));
        }
        return str;
    }

    public void visit(Limit obj) {
        this.limitInUse = true;
        if (!this.countStarInUse) {
            this.query.setRows(Integer.valueOf(obj.getRowLimit()));
            this.query.setStart(Integer.valueOf(obj.getRowOffset()));
        }
    }

    public void visit(OrderBy obj) {
        this.visitNodes(obj.getSortSpecifications());
    }

    public void visit(SortSpecification obj) {
        this.visitNode((LanguageObject)obj.getExpression());
        String expr = this.onGoingExpression.pop();
        this.query.addSort(expr, obj.getOrdering() == SortSpecification.Ordering.ASC ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
    }

    public void visit(Function obj) {
        FunctionModifier funcModifier = this.ef.getFunctionModifiers().get(obj.getName());
        if (funcModifier != null) {
            funcModifier.translate(obj);
        }
        StringBuilder sb = new StringBuilder();
        this.visitNodes(obj.getParameters());
        for (int i = 0; i < obj.getParameters().size(); ++i) {
            sb.insert(0, this.onGoingExpression.pop());
            if (i >= obj.getParameters().size() - 1) continue;
            sb.insert(0, ",");
        }
        sb.insert(0, "(");
        sb.insert(0, obj.getName());
        sb.append(")");
        this.onGoingExpression.push(sb.toString());
    }

    public void visit(AggregateFunction obj) {
        if (obj.getName().equals("COUNT")) {
            this.query.setRows(Integer.valueOf(0));
            this.countStarInUse = true;
            this.onGoingExpression.push("1");
        } else if (obj.getName().equals("AVG") || obj.getName().equals("SUM") || obj.getName().equals("MIN") || obj.getName().equals("MAX")) {
            // empty if block
        }
    }

    private String formatSolrQuery(String solrQuery) {
        solrQuery = solrQuery.replace("%", "*");
        solrQuery = solrQuery.replace("'", "");
        return solrQuery;
    }

    public SolrQuery getSolrQuery() {
        if (this.buffer == null || this.buffer.length() == 0) {
            this.buffer = new StringBuilder("*:*");
        }
        return this.query.setQuery(this.buffer.toString());
    }

    public boolean isLimitInUse() {
        return this.limitInUse;
    }

    public boolean isCountStarInUse() {
        return this.countStarInUse;
    }

    static {
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

