/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.solr;

import java.io.File;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.teiid.CommandContext;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.solr.SolrConnection;
import org.teiid.translator.solr.SolrExecutionFactory;

public class TestSolrUpdateExecution {
    private SolrExecutionFactory translator;
    private TranslationUtility utility;

    @Before
    public void setUp() throws Exception {
        this.translator = new SolrExecutionFactory();
        this.translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"exampleTBL.ddl")), (String)"example", (String)"solr");
        this.utility = new TranslationUtility((QueryMetadataInterface)metadata);
    }

    private UpdateRequest helpUpdate(String query, QueryResponse ... responseDocs) throws TranslatorException {
        Command cmd = this.utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.stub((Object)context.getCommandContext()).toReturn((Object)((CommandContext)Mockito.mock(CommandContext.class)));
        SolrConnection connection = (SolrConnection)Mockito.mock(SolrConnection.class);
        UpdateResponse response = (UpdateResponse)Mockito.mock(UpdateResponse.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(UpdateRequest.class);
        Mockito.when((Object)connection.query((SolrQuery)Mockito.any(SolrQuery.class))).thenReturn((Object)responseDocs[0], (Object[])new QueryResponse[]{responseDocs[1]});
        Mockito.stub((Object)connection.update((UpdateRequest)Mockito.any(UpdateRequest.class))).toReturn((Object)response);
        UpdateExecution execution = this.translator.createUpdateExecution(cmd, context, this.utility.createRuntimeMetadata(), connection);
        execution.execute();
        ((SolrConnection)Mockito.verify((Object)connection)).update((UpdateRequest)argument.capture());
        return (UpdateRequest)argument.getValue();
    }

    @Test
    public void testSimpleInsert() throws Exception {
        String query = "insert into example (price, weight, popularity, name, field) VALUES ('1.10', '2.23', 5, 'teiid', 'any')";
        SolrInputDocument insert = new SolrInputDocument(new String[0]);
        insert.addField("price", (Object)Float.valueOf(1.1f));
        insert.addField("weight", (Object)Float.valueOf(2.23f));
        insert.addField("popularity", (Object)5);
        insert.addField("name", (Object)"teiid");
        insert.addField("nis", (Object)"any");
        QueryResponse queryResponse = (QueryResponse)Mockito.mock(QueryResponse.class);
        Mockito.stub((Object)queryResponse.getResults()).toReturn((Object)new SolrDocumentList());
        QueryResponse queryResponse2 = (QueryResponse)Mockito.mock(QueryResponse.class);
        Mockito.stub((Object)queryResponse2.getResults()).toReturn((Object)new SolrDocumentList());
        UpdateRequest request = this.helpUpdate(query, queryResponse, queryResponse2);
        List docs = request.getDocuments();
        Assert.assertEquals((long)1L, (long)docs.size());
        Assert.assertEquals((Object)insert.toString(), (Object)((SolrInputDocument)docs.get(0)).toString());
    }

    @Test
    public void testSimpleUpdate() throws Exception {
        String query = "Update example set field = 'some' where name = 'teiid'";
        SolrDocument doc = new SolrDocument();
        doc.addField("price", (Object)Float.valueOf(1.1f));
        doc.addField("weight", (Object)Float.valueOf(2.23f));
        doc.addField("popularity", (Object)5);
        doc.addField("name", (Object)"teiid");
        doc.addField("nis", (Object)"any");
        SolrDocumentList list = new SolrDocumentList();
        list.add((Object)doc);
        QueryResponse queryResponse = (QueryResponse)Mockito.mock(QueryResponse.class);
        Mockito.stub((Object)queryResponse.getResults()).toReturn((Object)list);
        QueryResponse queryResponse2 = (QueryResponse)Mockito.mock(QueryResponse.class);
        Mockito.stub((Object)queryResponse2.getResults()).toReturn((Object)new SolrDocumentList());
        UpdateRequest request = this.helpUpdate(query, queryResponse, queryResponse2);
        List docs = request.getDocuments();
        Assert.assertEquals((long)1L, (long)docs.size());
        SolrInputDocument update = new SolrInputDocument(new String[0]);
        update.addField("price", (Object)Float.valueOf(1.1f));
        update.addField("weight", (Object)Float.valueOf(2.23f));
        update.addField("popularity", (Object)5);
        update.addField("name", (Object)"teiid");
        update.addField("nis", (Object)"some");
        Assert.assertEquals((Object)update.toString(), (Object)((SolrInputDocument)docs.get(0)).toString());
    }

    @Test
    public void testSimpleDelete() throws Exception {
        String query = "Delete from example where name = 'teiid'";
        SolrDocument doc = new SolrDocument();
        doc.addField("price", (Object)Float.valueOf(1.1f));
        doc.addField("weight", (Object)Float.valueOf(2.23f));
        doc.addField("popularity", (Object)5);
        doc.addField("name", (Object)"teiid");
        doc.addField("nis", (Object)"any");
        SolrDocumentList list = new SolrDocumentList();
        list.add((Object)doc);
        QueryResponse queryResponse = (QueryResponse)Mockito.mock(QueryResponse.class);
        Mockito.stub((Object)queryResponse.getResults()).toReturn((Object)list);
        QueryResponse queryResponse2 = (QueryResponse)Mockito.mock(QueryResponse.class);
        Mockito.stub((Object)queryResponse2.getResults()).toReturn((Object)new SolrDocumentList());
        UpdateRequest request = this.helpUpdate(query, queryResponse, queryResponse2);
        List docs = request.getDocuments();
        UpdateRequest expected = new UpdateRequest();
        expected.deleteById("teiid");
        Assert.assertEquals((Object)expected.getDeleteById().toString(), (Object)request.getDeleteById().toString());
    }
}

