/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.ddl;

import java.util.ArrayList;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.StringUtil;
import org.teiid.modeshape.sequencer.ddl.DdlTokenStream;
import org.teiid.modeshape.sequencer.ddl.StatementParser;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlConstants;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlParser;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlParsingException;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;

final class AlterOptionsParser
extends StatementParser {
    AlterOptionsParser(TeiidDdlParser teiidDdlParser) {
        super(teiidDdlParser);
    }

    @Override
    boolean matches(DdlTokenStream tokens) {
        return tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_VIRTUAL_PROCEDURE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_VIRTUAL_TABLE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_VIRTUAL_VIEW.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_FOREIGN_PROCEDURE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_FOREIGN_TABLE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_FOREIGN_VIEW.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_PROCEDURE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_TABLE.tokens()) || tokens.matches(TeiidDdlConstants.DdlStatement.ALTER_VIEW.tokens());
    }

    @Override
    AstNode parse(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        String nodeType = null;
        TeiidDdlConstants.SchemaElementType schemaElementType = null;
        String refNodeType = null;
        if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_TABLE.tokens())) {
            nodeType = "teiidddl:alterTable";
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            refNodeType = "teiidddl:createTable";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_VIEW.tokens())) {
            nodeType = "teiidddl:alterView";
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            refNodeType = "teiidddl:createView";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_PROCEDURE.tokens())) {
            nodeType = "teiidddl:alterProcedure";
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            refNodeType = "teiidddl:createProcedure";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_VIRTUAL_TABLE.tokens())) {
            nodeType = "teiidddl:alterTable";
            schemaElementType = TeiidDdlConstants.SchemaElementType.VIRTUAL;
            refNodeType = "teiidddl:createTable";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_VIRTUAL_VIEW.tokens())) {
            nodeType = "teiidddl:alterView";
            schemaElementType = TeiidDdlConstants.SchemaElementType.VIRTUAL;
            refNodeType = "teiidddl:createView";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_VIRTUAL_PROCEDURE.tokens())) {
            nodeType = "teiidddl:alterProcedure";
            schemaElementType = TeiidDdlConstants.SchemaElementType.VIRTUAL;
            refNodeType = "teiidddl:createProcedure";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_FOREIGN_TABLE.tokens())) {
            nodeType = "teiidddl:alterTable";
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            refNodeType = "teiidddl:createTable";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_FOREIGN_VIEW.tokens())) {
            nodeType = "teiidddl:alterView";
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            refNodeType = "teiidddl:createView";
        } else if (tokens.canConsume(TeiidDdlConstants.DdlStatement.ALTER_FOREIGN_PROCEDURE.tokens())) {
            nodeType = "teiidddl:alterProcedure";
            schemaElementType = TeiidDdlConstants.SchemaElementType.FOREIGN;
            refNodeType = "teiidddl:createProcedure";
        } else {
            throw new TeiidDdlParsingException(tokens, "Unparsable alter options statement");
        }
        assert (nodeType != null) : "Create alter options node type is null";
        assert (schemaElementType != null) : "Create alter options schema element type is null";
        assert (refNodeType != null) : "Create alter options reference node type is null";
        String tableRefName = this.parseIdentifier(tokens);
        AstNode alterOptionsNode = this.getNodeFactory().node(tableRefName, parentNode, nodeType);
        alterOptionsNode.setProperty("teiidddl:schemaElementType", (Object)schemaElementType.toDdl());
        AstNode tableRefNode = this.getNode(parentNode, tableRefName, refNodeType);
        if (tableRefNode == null) {
            throw new TeiidDdlParsingException(tokens, "Alter options statement table reference '" + tableRefName + "' node not found");
        }
        alterOptionsNode.setProperty("teiidddl:reference", (Object)tableRefNode);
        if (!this.parseAlterOptionsList(tokens, alterOptionsNode) && !this.parseAlterColumnOptions(tokens, alterOptionsNode)) {
            throw new TeiidDdlParsingException(tokens, "Unparsable alter options statement");
        }
        return alterOptionsNode;
    }

    boolean parseAlterColumnOptions(DdlTokenStream tokens, AstNode alterOptionsNode) throws ParsingException {
        if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.ALTER.toDdl())) {
            String nodeType = null;
            nodeType = tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.COLUMN.toDdl()) ? "teiidddl:alterColumn" : (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.PARAMETER.toDdl()) ? "teiidddl:alterParameter" : "teiidddl:alterColumn");
            assert (nodeType != null) : "Alter column options node type is null";
            String refName = this.parseIdentifier(tokens);
            AstNode columnOptionsNode = this.getNodeFactory().node(refName, alterOptionsNode, nodeType);
            AstNode refTableNode = (AstNode)alterOptionsNode.getProperty("teiidddl:reference");
            if (refTableNode == null) {
                this.logger.debug("Table/procedure/view node not found for alter column '{0}'", new Object[]{refName});
            } else {
                String refPropType = null;
                refPropType = refTableNode.hasMixin("teiidddl:createProcedure") ? "teiidddl:procedureParameter" : "teiidddl:tableElement";
                AstNode refNode = this.getNode(refTableNode, refName, refPropType);
                if (refNode == null) {
                    this.logger.debug("Alter column options reference column node not found: {0}", new Object[]{refName});
                }
                columnOptionsNode.setProperty("teiidddl:reference", (Object)refNode);
            }
            if (this.parseAlterOptionsList(tokens, columnOptionsNode)) {
                return true;
            }
            throw new TeiidDdlParsingException(tokens, "Unparsable alter column options clause");
        }
        return false;
    }

    boolean parseAlterOptionsList(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        if (tokens.matches(TeiidDdlConstants.TeiidReservedWord.OPTIONS.toDdl())) {
            if (!tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.OPTIONS.toDdl(), new String[]{"("})) {
                throw new TeiidDdlParsingException(tokens, "Unparsable alter options list (left paren not found)");
            }
            if (tokens.matches(TeiidDdlConstants.TeiidReservedWord.ADD.toDdl()) || tokens.matches(TeiidDdlConstants.TeiidReservedWord.SET.toDdl()) || tokens.matches(TeiidDdlConstants.TeiidReservedWord.DROP.toDdl())) {
                AstNode optionsListNode = null;
                optionsListNode = parentNode.hasMixin("teiidddl:alterColumn") || parentNode.hasMixin("teiidddl:alterParameter") ? parentNode : this.getNodeFactory().node("alters", parentNode, "teiidddl:alterOptionsList");
                boolean keepParsing = tokens.hasNext();
                boolean foundOption = false;
                boolean foundComma = false;
                while (keepParsing) {
                    String option;
                    if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.ADD.toDdl()) || tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.SET.toDdl())) {
                        option = this.parseIdentifier(tokens);
                        String value = this.parseValue(tokens);
                        if (!StringUtil.isBlank((String)value)) {
                            AstNode optionsNode = this.getNodeFactory().node(option, optionsListNode, "ddl:statementOption");
                            optionsNode.setProperty("ddl:value", (Object)value);
                        }
                        foundOption = true;
                        foundComma = false;
                        continue;
                    }
                    if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.DROP.toDdl())) {
                        option = this.parseIdentifier(tokens);
                        ArrayList<String> values = (ArrayList<String>)optionsListNode.getProperty("teiidddl:dropped");
                        if (values == null) {
                            values = new ArrayList<String>();
                        }
                        values.add(option);
                        optionsListNode.setProperty("teiidddl:dropped", (Object)values);
                        foundOption = true;
                        foundComma = false;
                        continue;
                    }
                    if (tokens.canConsume(",")) {
                        if (!foundOption) {
                            throw new TeiidDdlParsingException(tokens, "Unparsable alter options list (misplaced comma found)");
                        }
                        if (foundComma) {
                            throw new TeiidDdlParsingException(tokens, "Unparsable alter options list (consecutive commas found)");
                        }
                        foundComma = true;
                        continue;
                    }
                    if (foundComma) {
                        throw new TeiidDdlParsingException(tokens, "Unparsable alter options list (comma found at end)");
                    }
                    keepParsing = false;
                }
                if (!tokens.canConsume(")")) {
                    throw new TeiidDdlParsingException(tokens, "Unparsable alter options list (right paren not found)");
                }
                return true;
            }
            throw new TeiidDdlParsingException(tokens, "Unparsable alter options list (no add, set, or drop found)");
        }
        return false;
    }

    @Override
    protected void postProcess(AstNode rootNode) {
    }
}

