/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.teiid.modeshape.sequencer.ddl.DdlParser;
import org.teiid.modeshape.sequencer.ddl.DdlParserScorer;
import org.teiid.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlParser;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.modeshape.sequencer.ddl.node.AstNodeFactory;

@Immutable
public class DdlParsers {
    private static final Comparator<Map.Entry<DdlParser, Integer>> SORTER = new Comparator<Map.Entry<DdlParser, Integer>>(){

        @Override
        public int compare(Map.Entry<DdlParser, Integer> thisEntry, Map.Entry<DdlParser, Integer> thatEntry) {
            int result = thisEntry.getValue().compareTo(thatEntry.getValue()) * -1;
            if (result == 0) {
                if ("SQL92".equals(thisEntry.getKey().getId()) && !"SQL92".equals(thatEntry.getKey().getId())) {
                    return -1;
                }
                if ("SQL92".equals(thatEntry.getKey().getId()) && !"SQL92".equals(thisEntry.getKey().getId())) {
                    return 1;
                }
            }
            return result;
        }
    };
    public static final List<DdlParser> BUILTIN_PARSERS;
    private List<DdlParser> parsers;
    private AstNodeFactory nodeFactory = new AstNodeFactory();

    public DdlParsers() {
        this.parsers = BUILTIN_PARSERS;
    }

    public DdlParsers(List<DdlParser> parsers) {
        this.parsers = parsers != null && !parsers.isEmpty() ? parsers : BUILTIN_PARSERS;
    }

    private AstNode createDdlStatementsContainer(String parserId) {
        AstNode node = this.nodeFactory.node("ddl:statements");
        node.setProperty("jcr:primaryType", (Object)"nt:unstructured");
        node.setProperty("ddl:parserId", (Object)parserId);
        return node;
    }

    public DdlParser getParser(String id) {
        CheckArg.isNotEmpty((String)id, (String)"id");
        for (DdlParser parser : this.parsers) {
            if (!parser.getId().equals(id)) continue;
            return parser;
        }
        return null;
    }

    public Set<DdlParser> getParsers() {
        return new HashSet<DdlParser>(this.parsers);
    }

    public AstNode parseUsing(String ddl, String parserId) throws ParsingException {
        CheckArg.isNotEmpty((String)ddl, (String)"ddl");
        CheckArg.isNotEmpty((String)parserId, (String)"parserId");
        DdlParser parser = this.getParser(parserId);
        if (parser == null) {
            throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.unknownParser.text(new Object[]{parserId}));
        }
        AstNode astRoot = this.createDdlStatementsContainer(parserId);
        parser.parse(ddl, astRoot, null);
        return astRoot;
    }

    public List<ParsingResult> parseUsing(String ddl, String firstParserId, String secondParserId, String ... additionalParserIds) throws ParsingException {
        CheckArg.isNotEmpty((String)firstParserId, (String)"firstParserId");
        CheckArg.isNotEmpty((String)secondParserId, (String)"secondParserId");
        if (additionalParserIds != null) {
            CheckArg.containsNoNulls((Object[])additionalParserIds, (String)"additionalParserIds");
        }
        int numParsers = additionalParserIds == null ? 2 : additionalParserIds.length + 2;
        ArrayList<DdlParser> selectedParsers = new ArrayList<DdlParser>(numParsers);
        DdlParser parser = this.getParser(firstParserId);
        if (parser == null) {
            throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.unknownParser.text(new Object[]{firstParserId}));
        }
        selectedParsers.add(parser);
        parser = this.getParser(secondParserId);
        if (parser == null) {
            throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.unknownParser.text(new Object[]{secondParserId}));
        }
        selectedParsers.add(parser);
        if (additionalParserIds != null && additionalParserIds.length != 0) {
            for (String id : additionalParserIds) {
                DdlParser parser2 = this.getParser(id);
                if (parser2 == null) {
                    throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.unknownParser.text(new Object[]{id}));
                }
                selectedParsers.add(parser2);
            }
        }
        return this.parseUsing(ddl, selectedParsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ParsingResult> parseUsing(String ddl, List<DdlParser> parsers) {
        CheckArg.isNotEmpty((String)ddl, (String)"ddl");
        ArrayList<ParsingResult> results = new ArrayList<ParsingResult>(this.parsers.size());
        DdlParserScorer scorer = new DdlParserScorer();
        for (DdlParser parser : this.parsers) {
            ParsingResult result;
            String parserId = parser.getId();
            int score = -1;
            AstNode rootNode = null;
            RuntimeException error = null;
            try {
                Object scorerOutput = parser.score(ddl, null, scorer);
                score = scorer.getScore();
                rootNode = this.createDdlStatementsContainer(parserId);
                parser.parse(ddl, rootNode, scorerOutput);
            }
            catch (RuntimeException e) {
                try {
                    error = e;
                    result = new ParsingResult(parserId, rootNode, score, error);
                    results.add(result);
                }
                catch (Throwable throwable) {
                    ParsingResult result2 = new ParsingResult(parserId, rootNode, score, error);
                    results.add(result2);
                    scorer.reset();
                    throw throwable;
                }
                scorer.reset();
                continue;
            }
            result = new ParsingResult(parserId, rootNode, score, error);
            results.add(result);
            scorer.reset();
        }
        Collections.sort(results);
        return results;
    }

    public List<ParsingResult> parseUsingAll(String ddl) throws ParsingException {
        return this.parseUsing(ddl, this.parsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AstNode parse(String ddl, String fileName) throws ParsingException {
        CheckArg.isNotEmpty((String)ddl, (String)"ddl");
        RuntimeException firstException = null;
        HashMap<DdlParser, Integer> scoreMap = new HashMap<DdlParser, Integer>(this.parsers.size());
        DdlParserScorer scorer = new DdlParserScorer();
        for (DdlParser parser : this.parsers) {
            try {
                parser.score(ddl, fileName, scorer);
                scoreMap.put(parser, scorer.getScore());
            }
            catch (RuntimeException e) {
                if (firstException != null) continue;
                firstException = e;
            }
            finally {
                scorer.reset();
            }
        }
        if (scoreMap.isEmpty()) {
            if (firstException == null) {
                throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.errorParsingDdlContent.text(new Object[]{this.parsers.size()}));
            }
            throw firstException;
        }
        ArrayList scoredParsers = new ArrayList(scoreMap.entrySet());
        Collections.sort(scoredParsers, SORTER);
        firstException = null;
        AstNode astRoot = null;
        for (Map.Entry entry : scoredParsers) {
            try {
                DdlParser parser = (DdlParser)entry.getKey();
                astRoot = this.createDdlStatementsContainer(parser.getId());
                parser.parse(ddl, astRoot, null);
                return astRoot;
            }
            catch (RuntimeException e) {
                if (astRoot != null) {
                    astRoot.removeFromParent();
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException == null) {
            throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.errorParsingDdlContent.text(new Object[0]));
        }
        throw firstException;
    }

    static {
        ArrayList<TeiidDdlParser> parsers = new ArrayList<TeiidDdlParser>();
        parsers.add(new TeiidDdlParser());
        BUILTIN_PARSERS = Collections.unmodifiableList(parsers);
    }

    @Immutable
    public class ParsingResult
    implements Comparable<ParsingResult> {
        public static final int NO_SCORE = -1;
        private final Exception error;
        private final String id;
        private final AstNode rootNode;
        private final int score;

        public ParsingResult(String parserId, AstNode rootTreeNode, int parserScore, Exception parsingError) {
            CheckArg.isNotEmpty((String)parserId, (String)"parserId");
            this.id = parserId;
            this.rootNode = rootTreeNode;
            this.score = parserScore;
            this.error = parsingError;
        }

        @Override
        public int compareTo(ParsingResult that) {
            if (this == that || this.score == that.score) {
                return 0;
            }
            return this.score > that.score ? -1 : 1;
        }

        public Exception getError() {
            return this.error;
        }

        public String getParserId() {
            return this.id;
        }

        public AstNode getRootTree() {
            return this.rootNode;
        }

        public int getScore() {
            return this.score;
        }
    }
}

