/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.ddl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.teiid.modeshape.sequencer.ddl.DdlConstants;
import org.teiid.modeshape.sequencer.ddl.DdlParser;
import org.teiid.modeshape.sequencer.ddl.DdlParserProblem;
import org.teiid.modeshape.sequencer.ddl.DdlParserScorer;
import org.teiid.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.teiid.modeshape.sequencer.ddl.DdlTokenStream;
import org.teiid.modeshape.sequencer.ddl.datatype.DataType;
import org.teiid.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.modeshape.sequencer.ddl.node.AstNodeFactory;

@NotThreadSafe
public class StandardDdlParser
implements DdlParser,
DdlConstants,
DdlConstants.StatementStartPhrases {
    private static final Logger LOGGER = Logger.getLogger(StandardDdlParser.class);
    public static final String ID = "SQL92";
    private static final String IGNORED_STATEMENT_NAME = "IGNORED_";
    private boolean testMode = false;
    private final List<DdlParserProblem> problems;
    private final AstNodeFactory nodeFactory;
    private AstNode rootNode;
    private List<String> allDataTypeStartWords = null;
    private DataTypeParser datatypeParser = null;
    private String terminator = ";";
    private boolean useTerminator = false;
    private Position currentMarkedPosition;
    private boolean includeComments = true;
    private int ignoredStatementSuffix = 1;

    public StandardDdlParser() {
        this.setDoUseTerminator(true);
        this.setDatatypeParser(new DataTypeParser());
        this.nodeFactory = new AstNodeFactory();
        this.problems = new ArrayList<DdlParserProblem>();
    }

    public DataTypeParser getDatatypeParser() {
        return this.datatypeParser;
    }

    public void setDatatypeParser(DataTypeParser datatypeParser) {
        this.datatypeParser = datatypeParser;
    }

    public AstNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public AstNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(AstNode rootNode) {
        this.rootNode = rootNode;
    }

    @Override
    public Object score(String ddl, String fileName, DdlParserScorer scorer) throws ParsingException {
        CheckArg.isNotNull((Object)ddl, (String)"ddl");
        CheckArg.isNotNull((Object)scorer, (String)"scorer");
        if (fileName != null) {
            scorer.scoreText(fileName, 2, this.getIdentifyingKeywords());
        }
        this.problems.clear();
        DdlTokenStream tokens = new DdlTokenStream(ddl, DdlTokenStream.ddlTokenizer(this.includeComments), false);
        this.initializeTokenStream(tokens);
        tokens.start();
        this.testPrint("\n== >> StandardDdlParser.parse() PARSING STARTED: ");
        while (tokens.matches(32)) {
            String comment = tokens.consume();
            scorer.scoreText(comment, 2, this.getIdentifyingKeywords());
        }
        this.computeScore(tokens, scorer);
        return tokens;
    }

    protected void computeScore(DdlTokenStream tokens, DdlParserScorer scorer) {
        while (tokens.hasNext()) {
            int score = tokens.computeNextStatementStartKeywordCount();
            if (score == 0 && tokens.isNextKeyWord()) {
                score = 1;
            }
            if (score != 0) {
                scorer.scoreStatements(score);
            }
            tokens.consume();
        }
    }

    public String[] getIdentifyingKeywords() {
        return new String[]{this.getId()};
    }

    @Override
    public void parse(String ddl, AstNode rootNode, Object scoreReturnObject) throws ParsingException {
        CheckArg.isNotNull((Object)ddl, (String)"ddl");
        CheckArg.isNotNull((Object)rootNode, (String)"rootNode");
        this.problems.clear();
        this.ignoredStatementSuffix = 1;
        this.setRootNode(rootNode);
        DdlTokenStream tokens = null;
        if (scoreReturnObject instanceof DdlTokenStream) {
            tokens = (DdlTokenStream)((Object)scoreReturnObject);
            tokens.rewind();
        } else {
            tokens = new DdlTokenStream(ddl, DdlTokenStream.ddlTokenizer(this.includeComments), false);
            this.initializeTokenStream(tokens);
            tokens.start();
        }
        this.testPrint("\n== >> StandardDdlParser.parse() PARSING STARTED: ");
        while (this.moveToNextStatementStart(tokens)) {
            Object stmtNode = this.parseNextStatement(tokens, rootNode);
            if (stmtNode != null) continue;
            this.markStartOfStatement(tokens);
            String stmtName = IGNORED_STATEMENT_NAME + this.ignoredStatementSuffix++;
            stmtNode = this.parseIgnorableStatement(tokens, stmtName, rootNode);
            this.markEndOfStatement(tokens, (AstNode)stmtNode);
        }
        this.postProcess(rootNode);
        this.rewrite(tokens, rootNode);
        for (DdlParserProblem problem : this.problems) {
            this.attachNewProblem(problem, rootNode);
        }
        if (this.testMode) {
            int count = 0;
            for (AstNode child : rootNode.getChildren()) {
                this.testPrint("== >> Found Statement(" + ++count + "):\n" + child);
            }
        }
    }

    protected void initializeTokenStream(DdlTokenStream tokens) {
        tokens.registerKeyWords(SQL_92_RESERVED_WORDS);
        tokens.registerStatementStartPhrase(SQL_92_ALL_PHRASES);
    }

    protected AstNode parseNextStatement(DdlTokenStream tokens, AstNode node) {
        assert (tokens != null);
        assert (node != null);
        AstNode stmtNode = null;
        if (tokens.matches("CREATE")) {
            stmtNode = this.parseCreateStatement(tokens, node);
        } else if (tokens.matches("ALTER")) {
            stmtNode = this.parseAlterStatement(tokens, node);
        } else if (tokens.matches("DROP")) {
            stmtNode = this.parseDropStatement(tokens, node);
        } else if (tokens.matches("INSERT")) {
            stmtNode = this.parseInsertStatement(tokens, node);
        } else if (tokens.matches("SET")) {
            stmtNode = this.parseSetStatement(tokens, node);
        } else if (tokens.matches("GRANT")) {
            stmtNode = this.parseGrantStatement(tokens, node);
        } else if (tokens.matches("REVOKE")) {
            stmtNode = this.parseRevokeStatement(tokens, node);
        }
        if (stmtNode == null) {
            stmtNode = this.parseCustomStatement(tokens, node);
        }
        return stmtNode;
    }

    private boolean moveToNextStatementStart(DdlTokenStream tokens) throws ParsingException {
        assert (tokens != null);
        StringBuilder sb = new StringBuilder();
        DdlParserProblem problem = null;
        if (tokens.hasNext()) {
            while (tokens.hasNext()) {
                if (!this.includeComments && tokens.matches(32)) {
                    String comment = tokens.consume();
                    LOGGER.debug("consumed comment: " + comment, new Object[0]);
                    continue;
                }
                if (!tokens.matches(32) && !tokens.matches(128)) {
                    AstNode unknownNode;
                    if (problem == null) {
                        this.markStartOfStatement(tokens);
                        String msg = DdlSequencerI18n.unusedTokensDiscovered.text(new Object[]{tokens.nextPosition().getLine(), tokens.nextPosition().getColumn()});
                        problem = new DdlParserProblem(1, tokens.nextPosition(), msg);
                    }
                    String nextTokenValue = null;
                    if (tokens.matches(this.getTerminator()) && sb.length() > 0) {
                        nextTokenValue = this.getTerminator();
                        unknownNode = this.unknownTerminatedNode(this.getRootNode());
                        this.markEndOfStatement(tokens, unknownNode);
                        problem = null;
                    } else {
                        nextTokenValue = tokens.consume();
                        unknownNode = this.handleUnknownToken(tokens, nextTokenValue);
                        if (unknownNode != null) {
                            this.markEndOfStatement(tokens, unknownNode);
                            problem = null;
                        }
                    }
                    sb.append(" ").append(nextTokenValue);
                    continue;
                }
                if (problem != null && sb.length() > 0) {
                    problem.setUnusedSource(sb.toString());
                    this.addProblem(problem);
                }
                return true;
            }
            if (problem != null && sb.length() > 0) {
                problem.setUnusedSource(sb.toString());
                this.addProblem(problem);
            }
        }
        return false;
    }

    public final void addProblem(DdlParserProblem problem, AstNode node) {
        this.addProblem(problem);
        this.attachNewProblem(problem, node);
    }

    public final void addProblem(DdlParserProblem problem) {
        this.problems.add(problem);
    }

    public final List<DdlParserProblem> getProblems() {
        return this.problems;
    }

    public final void attachNewProblem(DdlParserProblem problem, AstNode parentNode) {
        assert (problem != null);
        assert (parentNode != null);
        AstNode problemNode = this.nodeFactory().node("ddl:problem", parentNode, "ddl:ddlProblem");
        problemNode.setProperty("ddl:problemLevel", (Object)problem.getLevel());
        problemNode.setProperty("ddl:message", (Object)(problem.toString() + "[" + problem.getUnusedSource() + "]"));
        this.testPrint(problem.toString());
    }

    protected void rewrite(DdlTokenStream tokens, AstNode rootNode) {
        assert (tokens != null);
        assert (rootNode != null);
        this.removeMissingTerminatorNodes(rootNode);
    }

    protected void removeMissingTerminatorNodes(AstNode parentNode) {
        assert (parentNode != null);
        ArrayList<AstNode> copyOfNodes = new ArrayList<AstNode>(parentNode.getChildren());
        for (AstNode child : copyOfNodes) {
            if (this.nodeFactory().hasMixinType(child, "ddl:missingTerminator")) {
                parentNode.removeChild(child);
                continue;
            }
            this.removeMissingTerminatorNodes(child);
        }
    }

    public void mergeNodes(DdlTokenStream tokens, AstNode firstNode, AstNode secondNode) {
        assert (tokens != null);
        assert (firstNode != null);
        assert (secondNode != null);
        int firstStartIndex = (Integer)firstNode.getProperty("ddl:startCharIndex");
        int secondStartIndex = (Integer)secondNode.getProperty("ddl:startCharIndex");
        int deltaLength = ((String)secondNode.getProperty("ddl:expression")).length();
        Position startPosition = new Position(firstStartIndex, 1, 0);
        Position endPosition = new Position(secondStartIndex + deltaLength, 1, 0);
        String source = tokens.getContentBetween(startPosition, endPosition);
        firstNode.setProperty("ddl:expression", (Object)source);
        firstNode.setProperty("ddl:length", (Object)source.length());
    }

    public AstNode handleUnknownToken(DdlTokenStream tokens, String tokenValue) throws ParsingException {
        assert (tokens != null);
        assert (tokenValue != null);
        return null;
    }

    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        AstNode stmtNode = null;
        if (tokens.matches(STMT_CREATE_SCHEMA)) {
            stmtNode = this.parseCreateSchemaStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_TABLE) || tokens.matches(STMT_CREATE_GLOBAL_TEMPORARY_TABLE) || tokens.matches(STMT_CREATE_LOCAL_TEMPORARY_TABLE)) {
            stmtNode = this.parseCreateTableStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_VIEW) || tokens.matches(STMT_CREATE_OR_REPLACE_VIEW)) {
            stmtNode = this.parseCreateViewStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_ASSERTION)) {
            stmtNode = this.parseCreateAssertionStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_CHARACTER_SET)) {
            stmtNode = this.parseCreateCharacterSetStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_COLLATION)) {
            stmtNode = this.parseCreateCollationStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_TRANSLATION)) {
            stmtNode = this.parseCreateTranslationStatement(tokens, parentNode);
        } else if (tokens.matches(STMT_CREATE_DOMAIN)) {
            stmtNode = this.parseCreateDomainStatement(tokens, parentNode);
        } else {
            this.markStartOfStatement(tokens);
            stmtNode = this.parseIgnorableStatement(tokens, "CREATE UNKNOWN", parentNode);
            Position position = this.getCurrentMarkedPosition();
            String msg = DdlSequencerI18n.unknownCreateStatement.text(new Object[]{position.getLine(), position.getColumn()});
            DdlParserProblem problem = new DdlParserProblem(1, position, msg);
            stmtNode.setProperty("ddl:problem", (Object)problem.toString());
            this.markEndOfStatement(tokens, stmtNode);
        }
        return stmtNode;
    }

    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches("ALTER", new String[]{"TABLE"})) {
            return this.parseAlterTableStatement(tokens, parentNode);
        }
        if (tokens.matches("ALTER", new String[]{"DOMAIN"})) {
            this.markStartOfStatement(tokens);
            tokens.consume("ALTER", new String[]{"DOMAIN"});
            String domainName = this.parseName(tokens);
            AstNode alterNode = this.nodeFactory().node(domainName, parentNode, "ddl:alterDomainStatement");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, alterNode);
            return alterNode;
        }
        return null;
    }

    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("ALTER", new String[]{"TABLE"});
        String tableName = this.parseName(tokens);
        AstNode alterTableNode = this.nodeFactory().node(tableName, parentNode, "ddl:alterTableStatement");
        if (tokens.canConsume("ADD")) {
            if (this.isTableConstraint(tokens)) {
                this.parseTableConstraint(tokens, alterTableNode, true);
            } else {
                this.parseSingleTerminatedColumnDefinition(tokens, alterTableNode, true);
            }
        } else if (tokens.canConsume("DROP")) {
            if (tokens.canConsume("CONSTRAINT")) {
                String constraintName = this.parseName(tokens);
                AstNode constraintNode = this.nodeFactory().node(constraintName, alterTableNode, "ddl:dropTableConstraintDefinition");
                if (tokens.canConsume("CASCADE")) {
                    constraintNode.setProperty("ddl:dropBehavior", (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    constraintNode.setProperty("ddl:dropBehavior", (Object)"RESTRICT");
                }
            } else {
                tokens.canConsume("COLUMN");
                String columnName = this.parseName(tokens);
                AstNode columnNode = this.nodeFactory().node(columnName, alterTableNode, "ddl:dropColumnDefinition");
                if (tokens.canConsume("CASCADE")) {
                    columnNode.setProperty("ddl:dropBehavior", (Object)"CASCADE");
                } else if (tokens.canConsume("RESTRICT")) {
                    columnNode.setProperty("ddl:dropBehavior", (Object)"RESTRICT");
                }
            }
        } else if (tokens.canConsume("ALTER")) {
            tokens.canConsume("COLUMN");
            String alterColumnName = this.parseName(tokens);
            AstNode columnNode = this.nodeFactory().node(alterColumnName, alterTableNode, "ddl:alterColumnDefinition");
            if (tokens.canConsume("SET")) {
                this.parseDefaultClause(tokens, columnNode);
            } else if (tokens.canConsume("DROP", new String[]{"DEFAULT"})) {
                columnNode.setProperty("ddl:dropBehavior", (Object)"DROP DEFAULT");
            }
        } else {
            this.parseUntilTerminator(tokens);
        }
        this.markEndOfStatement(tokens, alterTableNode);
        return alterTableNode;
    }

    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_DROP_TABLE)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TABLE, parentNode, "ddl:dropTableStatement");
        }
        if (tokens.matches(STMT_DROP_VIEW)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_VIEW, parentNode, "ddl:dropViewStatement");
        }
        if (tokens.matches(STMT_DROP_SCHEMA)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_SCHEMA, parentNode, "ddl:dropSchemaStatement");
        }
        if (tokens.matches(STMT_DROP_DOMAIN)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_DOMAIN, parentNode, "ddl:dropDomainStatement");
        }
        if (tokens.matches(STMT_DROP_TRANSLATION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_TRANSLATION, parentNode, "ddl:dropTranslationStatement");
        }
        if (tokens.matches(STMT_DROP_CHARACTER_SET)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_CHARACTER_SET, parentNode, "ddl:dropCharacterSetStatement");
        }
        if (tokens.matches(STMT_DROP_ASSERTION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_ASSERTION, parentNode, "ddl:dropAssertionStatement");
        }
        if (tokens.matches(STMT_DROP_COLLATION)) {
            return this.parseSimpleDropStatement(tokens, STMT_DROP_COLLATION, parentNode, "ddl:dropCollationStatement");
        }
        return null;
    }

    private AstNode parseSimpleDropStatement(DdlTokenStream tokens, String[] startPhrase, AstNode parentNode, String stmtType) throws ParsingException {
        assert (tokens != null);
        assert (startPhrase != null && startPhrase.length > 0);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String behavior = null;
        tokens.consume(startPhrase);
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(this.parseName(tokens));
        while (tokens.matches(",")) {
            tokens.consume(",");
            nameList.add(this.parseName(tokens));
        }
        if (tokens.canConsume("CASCADE")) {
            behavior = "CASCADE";
        } else if (tokens.canConsume("RESTRICT")) {
            behavior = "RESTRICT";
        }
        AstNode dropNode = this.nodeFactory().node((String)nameList.get(0), parentNode, stmtType);
        if (behavior != null) {
            dropNode.setProperty("ddl:dropBehavior", (Object)behavior);
        }
        this.markEndOfStatement(tokens, dropNode);
        return dropNode;
    }

    protected AstNode parseInsertStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_INSERT_INTO)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_INSERT_INTO);
            String prefix = this.getStatementTypeName(STMT_INSERT_INTO);
            AstNode node = this.nodeFactory().node(prefix, parentNode, "ddl:insertStatement");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        return null;
    }

    protected AstNode parseSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches("SET")) {
            this.markStartOfStatement(tokens);
            tokens.consume("SET");
            AstNode node = this.nodeFactory().node("SET", parentNode, "ddl:setStatement");
            this.parseUntilTerminator(tokens);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        return null;
    }

    protected AstNode parseGrantStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        Object name;
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches("GRANT"));
        this.markStartOfStatement(tokens);
        AstNode grantNode = null;
        boolean allPrivileges = false;
        ArrayList<AstNode> privileges = new ArrayList<AstNode>();
        tokens.consume("GRANT");
        if (tokens.canConsume("ALL", new String[]{"PRIVILEGES"})) {
            allPrivileges = true;
        } else {
            this.parseGrantPrivileges(tokens, privileges);
        }
        tokens.consume("ON");
        if (tokens.canConsume("DOMAIN")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node((String)name, parentNode, "ddl:grantOnDomainStatement");
        } else if (tokens.canConsume("COLLATION")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node((String)name, parentNode, "ddl:grantOnCollationStatement");
        } else if (tokens.canConsume("CHARACTER", new String[]{"SET"})) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node((String)name, parentNode, "ddl:grantOnCharacterSetStatement");
        } else if (tokens.canConsume("TRANSLATION")) {
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node((String)name, parentNode, "ddl:grantOnTranslationStatement");
        } else {
            tokens.canConsume("TABLE");
            name = this.parseName(tokens);
            grantNode = this.nodeFactory().node((String)name, parentNode, "ddl:grantOnTableStatement");
        }
        for (AstNode node : privileges) {
            node.setParent(grantNode);
        }
        if (allPrivileges) {
            grantNode.setProperty("ddl:allPrivileges", (Object)allPrivileges);
        }
        tokens.consume("TO");
        do {
            String grantee = this.parseName(tokens);
            this.nodeFactory().node(grantee, grantNode, "ddl:grantee");
        } while (tokens.canConsume(","));
        if (tokens.canConsume("WITH", new String[]{"GRANT", "OPTION"})) {
            grantNode.setProperty("ddl:withGrantOption", (Object)"WITH GRANT OPTION");
        }
        this.markEndOfStatement(tokens, grantNode);
        return grantNode;
    }

    protected void parseGrantPrivileges(DdlTokenStream tokens, List<AstNode> privileges) throws ParsingException {
        do {
            AstNode node = null;
            if (tokens.canConsume("DELETE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"DELETE");
            } else if (tokens.canConsume("INSERT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"INSERT");
                this.parseColumnNameList(tokens, node, "ddl:columnReference");
            } else if (tokens.canConsume("REFERENCES")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"REFERENCES");
                this.parseColumnNameList(tokens, node, "ddl:columnReference");
            } else if (tokens.canConsume("SELECT")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"SELECT");
            } else if (tokens.canConsume("USAGE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"USAGE");
            } else if (tokens.canConsume("UPDATE")) {
                node = this.nodeFactory().node("privilege");
                node.setProperty("ddl:type", (Object)"UPDATE");
                this.parseColumnNameList(tokens, node, "ddl:columnReference");
            }
            if (node == null) break;
            this.nodeFactory().setType(node, "ddl:grantPrivilege");
            privileges.add(node);
        } while (tokens.canConsume(","));
    }

    protected AstNode parseRevokeStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        Object name;
        assert (tokens != null);
        assert (parentNode != null);
        assert (tokens.matches("REVOKE"));
        this.markStartOfStatement(tokens);
        AstNode revokeNode = null;
        boolean allPrivileges = false;
        boolean withGrantOption = false;
        ArrayList<AstNode> privileges = new ArrayList<AstNode>();
        tokens.consume("REVOKE");
        withGrantOption = tokens.canConsume("WITH", new String[]{"GRANT", "OPTION"});
        if (tokens.canConsume("ALL", new String[]{"PRIVILEGES"})) {
            allPrivileges = true;
        } else {
            this.parseGrantPrivileges(tokens, privileges);
        }
        tokens.consume("ON");
        if (tokens.canConsume("DOMAIN")) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node((String)name, parentNode, "ddl:revokeOnDomainStatement");
        } else if (tokens.canConsume("COLLATION")) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node((String)name, parentNode, "ddl:revokeOnCollationStatement");
        } else if (tokens.canConsume("CHARACTER", new String[]{"SET"})) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node((String)name, parentNode, "ddl:revokeOnCharacterSetStatement");
        } else if (tokens.canConsume("TRANSLATION")) {
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node((String)name, parentNode, "ddl:revokeOnTranslationStatement");
        } else {
            tokens.canConsume("TABLE");
            name = this.parseName(tokens);
            revokeNode = this.nodeFactory().node((String)name, parentNode, "ddl:revokeOnTableStatement");
        }
        for (AstNode node : privileges) {
            node.setParent(revokeNode);
        }
        if (allPrivileges) {
            revokeNode.setProperty("ddl:allPrivileges", (Object)allPrivileges);
        }
        tokens.consume("FROM");
        do {
            String grantee = this.parseName(tokens);
            this.nodeFactory().node(grantee, revokeNode, "ddl:grantee");
        } while (tokens.canConsume(","));
        String behavior = null;
        if (tokens.canConsume("CASCADE")) {
            behavior = "CASCADE";
        } else if (tokens.canConsume("RESTRICT")) {
            behavior = "RESTRICT";
        }
        if (behavior != null) {
            revokeNode.setProperty("ddl:dropBehavior", (Object)behavior);
        }
        if (withGrantOption) {
            revokeNode.setProperty("ddl:withGrantOption", (Object)"WITH GRANT OPTION");
        }
        this.markEndOfStatement(tokens, revokeNode);
        return revokeNode;
    }

    protected AstNode parseCreateDomainStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_DOMAIN);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "ddl:createDomainStatement");
        tokens.canConsume("AS");
        DataType datatype = this.getDatatypeParser().parse(tokens);
        if (datatype != null) {
            this.getDatatypeParser().setPropertiesOnNode(node, datatype);
            this.parseDefaultClause(tokens, node);
        }
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateCollationStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_COLLATION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "ddl:createCollationStatement");
        tokens.consume("FOR");
        String charSetName = this.parseName(tokens);
        node.setProperty("ddl:characterSetName", (Object)charSetName);
        tokens.consume("FROM");
        String collationSource = null;
        if (tokens.canConsume("EXTERNAL") || tokens.canConsume("DESC")) {
            collationSource = this.consumeParenBoundedTokens(tokens, false);
        } else if (tokens.canConsume("TRANSLATION")) {
            StringBuilder translationCollation = new StringBuilder("TRANSLATION ").append(tokens.consume());
            if (tokens.canConsume("THEN", new String[]{"COLLATION"})) {
                translationCollation.append(" THEN COLLATION ");
                translationCollation.append(this.parseName(tokens));
            }
            collationSource = translationCollation.toString();
        } else {
            collationSource = this.parseName(tokens);
        }
        node.setProperty("ddl:collationSource", (Object)collationSource);
        if (tokens.canConsume("PAD", new String[]{"SPACE"})) {
            node.setProperty("ddl:padAttribute", (Object)"PAD SPACE");
        } else if (tokens.canConsume("NO", new String[]{"PAD"})) {
            node.setProperty("ddl:padAttribute", (Object)"NO PAD");
        }
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateTranslationStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_TRANSLATION);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "ddl:createTranslationStatement");
        tokens.consume("FOR");
        node.setProperty("ddl:sourceCharacterSetName", (Object)this.parseName(tokens));
        tokens.consume("TO");
        node.setProperty("ddl:targetCharacterSetName", (Object)this.parseName(tokens));
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCreateCharacterSetStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume(STMT_CREATE_CHARACTER_SET);
        String name = this.parseName(tokens);
        AstNode node = this.nodeFactory().node(name, parentNode, "ddl:createCharacterSetStatement");
        node.setProperty("ddl:existingName", (Object)this.consumeIdentifier(tokens));
        this.parseUntilTerminator(tokens);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return null;
    }

    protected AstNode parseCreateTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        tokens.consume("CREATE");
        String temporaryValue = null;
        if (tokens.canConsume("LOCAL")) {
            tokens.consume("TEMPORARY");
            temporaryValue = "LOCAL";
        } else if (tokens.canConsume("GLOBAL")) {
            tokens.consume("TEMPORARY");
            temporaryValue = "GLOBAL";
        }
        tokens.consume("TABLE");
        String tableName = this.parseName(tokens);
        AstNode tableNode = this.nodeFactory().node(tableName, parentNode, "ddl:createTableStatement");
        if (temporaryValue != null) {
            tableNode.setProperty("ddl:temporary", (Object)temporaryValue);
        }
        this.parseColumnsAndConstraints(tokens, tableNode);
        this.parseCreateTableOptions(tokens, tableNode);
        this.markEndOfStatement(tokens, tableNode);
        return tableNode;
    }

    protected void parseCreateTableOptions(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        while (this.areNextTokensCreateTableOptions(tokens)) {
            this.parseNextCreateTableOption(tokens, tableNode);
        }
    }

    protected void parseNextCreateTableOption(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        if (tokens.canConsume("ON", new String[]{"COMMIT"})) {
            String option = "";
            if (tokens.canConsume("PRESERVE", new String[]{"ROWS"})) {
                option = option + "ON COMMIT PRESERVE ROWS";
            } else if (tokens.canConsume("DELETE", new String[]{"ROWS"})) {
                option = option + "ON COMMIT DELETE ROWS";
            } else if (tokens.canConsume("DROP")) {
                option = option + "ON COMMIT DROP";
            }
            if (option.length() > 0) {
                AstNode tableOption = this.nodeFactory().node("option", tableNode, "ddl:statementOption");
                tableOption.setProperty("ddl:value", (Object)option);
            }
        }
    }

    protected boolean areNextTokensCreateTableOptions(DdlTokenStream tokens) throws ParsingException {
        assert (tokens != null);
        boolean result = false;
        if (tokens.matches("ON", new String[]{"COMMIT"})) {
            result = true;
        }
        return result;
    }

    protected void parseColumnsAndConstraints(DdlTokenStream tokens, AstNode tableNode) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        if (!tokens.matches("(")) {
            return;
        }
        String tableElementString = this.getTableElementsString(tokens, false);
        DdlTokenStream localTokens = new DdlTokenStream(tableElementString, DdlTokenStream.ddlTokenizer(false), false);
        localTokens.start();
        StringBuilder unusedTokensSB = new StringBuilder();
        do {
            if (this.isTableConstraint(localTokens)) {
                this.parseTableConstraint(localTokens, tableNode, false);
                continue;
            }
            if (this.isColumnDefinitionStart(localTokens)) {
                this.parseColumnDefinition(localTokens, tableNode, false);
                continue;
            }
            unusedTokensSB.append(" ").append(localTokens.consume());
        } while (localTokens.canConsume(","));
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnsAndConstraints.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, Position.EMPTY_CONTENT_POSITION, msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected void parseColumnDefinition(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, "ddl:columnDefinition");
        this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
        StringBuilder unusedTokensSB = new StringBuilder();
        while (tokens.hasNext() && !tokens.matches(",")) {
            boolean parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                boolean parsedCollate = this.parseCollateClause(tokens, columnNode);
                boolean parsedConstraint = this.parseColumnConstraint(tokens, columnNode, isAlterTable);
                if (!parsedCollate && !parsedConstraint) {
                    unusedTokensSB.append(" ").append(tokens.consume());
                }
            }
            tokens.canConsume(32);
        }
        if (unusedTokensSB.length() > 0) {
            String msg = DdlSequencerI18n.unusedTokensParsingColumnDefinition.text(new Object[]{tableNode.getName()});
            DdlParserProblem problem = new DdlParserProblem(1, Position.EMPTY_CONTENT_POSITION, msg);
            problem.setUnusedSource(unusedTokensSB.toString());
            this.addProblem(problem, tableNode);
        }
    }

    protected void parseSingleTerminatedColumnDefinition(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        tokens.canConsume("COLUMN");
        String columnName = this.parseName(tokens);
        DataType datatype = this.getDatatypeParser().parse(tokens);
        AstNode columnNode = this.nodeFactory().node(columnName, tableNode, "ddl:columnDefinition");
        this.getDatatypeParser().setPropertiesOnNode(columnNode, datatype);
        while (tokens.hasNext() && !tokens.matches(this.getTerminator()) && !tokens.matches(128)) {
            boolean parsedDefaultClause;
            boolean foundSomething = parsedDefaultClause = this.parseDefaultClause(tokens, columnNode);
            if (!parsedDefaultClause) {
                foundSomething |= this.parseCollateClause(tokens, columnNode);
                foundSomething |= this.parseColumnConstraint(tokens, columnNode, isAlterTable);
            }
            if (!tokens.canConsume(",") && (foundSomething |= this.consumeComment(tokens))) continue;
            break;
        }
    }

    protected String getTableElementsString(DdlTokenStream tokens, boolean useTerminator) throws ParsingException {
        assert (tokens != null);
        StringBuilder sb = new StringBuilder(100);
        if (useTerminator) {
            while (!this.isTerminator(tokens)) {
                sb.append(" ").append(tokens.consume());
            }
        } else {
            tokens.consume("(");
            int iParen = 0;
            while (tokens.hasNext()) {
                if (tokens.matches("(")) {
                    ++iParen;
                } else if (tokens.matches(")")) {
                    if (iParen == 0) {
                        tokens.consume(")");
                        break;
                    }
                    --iParen;
                }
                if (this.isComment(tokens)) {
                    tokens.consume();
                    continue;
                }
                sb.append(" ").append(tokens.consume());
            }
        }
        return sb.toString();
    }

    protected String consumeParenBoundedTokens(DdlTokenStream tokens, boolean includeParens) throws ParsingException {
        assert (tokens != null);
        if (tokens.canConsume("(")) {
            StringBuilder sb = new StringBuilder(100);
            if (includeParens) {
                sb.append("(");
            }
            int iParen = 0;
            while (tokens.hasNext()) {
                if (tokens.matches("(")) {
                    ++iParen;
                } else if (tokens.matches(")")) {
                    if (iParen == 0) {
                        tokens.consume(")");
                        if (!includeParens) break;
                        sb.append(" ").append(")");
                        break;
                    }
                    --iParen;
                }
                if (this.isComment(tokens)) {
                    tokens.consume();
                    continue;
                }
                sb.append(" ").append(tokens.consume());
            }
            return sb.toString();
        }
        return null;
    }

    protected boolean parseColumnConstraint(DdlTokenStream tokens, AstNode columnNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (columnNode != null);
        String mixinType = isAlterTable ? "ddl:addTableConstraintDefinition" : "ddl:tableConstraint";
        boolean result = false;
        String colName = columnNode.getName();
        if (tokens.canConsume("NULL")) {
            columnNode.setProperty("ddl:nullable", (Object)"NULL");
            result = true;
        } else if (tokens.canConsume("NOT", new String[]{"NULL"})) {
            columnNode.setProperty("ddl:nullable", (Object)"NOT NULL");
            result = true;
        } else if (tokens.matches("CONSTRAINT")) {
            result = true;
            tokens.consume("CONSTRAINT");
            String constraintName = this.parseName(tokens);
            AstNode constraintNode = this.nodeFactory().node(constraintName, columnNode.getParent(), mixinType);
            if (tokens.matches("UNIQUE")) {
                tokens.consume("UNIQUE");
                constraintNode.setProperty("ddl:constraintType", (Object)"UNIQUE");
                boolean columnsAdded = this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
                if (!columnsAdded) {
                    this.nodeFactory().node(colName, constraintNode, "ddl:columnReference");
                }
                this.parseConstraintAttributes(tokens, constraintNode);
            } else if (tokens.matches("PRIMARY", new String[]{"KEY"})) {
                tokens.consume("PRIMARY");
                tokens.consume("KEY");
                constraintNode.setProperty("ddl:constraintType", (Object)"PRIMARY KEY");
                boolean columnsAdded = this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
                if (!columnsAdded) {
                    this.nodeFactory().node(colName, constraintNode, "ddl:columnReference");
                }
                this.parseConstraintAttributes(tokens, constraintNode);
            } else if (tokens.matches("REFERENCES")) {
                constraintNode.setProperty("ddl:constraintType", (Object)"FOREIGN KEY");
                this.nodeFactory().node(colName, constraintNode, "ddl:columnReference");
                this.parseReferences(tokens, constraintNode);
                this.parseConstraintAttributes(tokens, constraintNode);
            }
        } else if (tokens.matches("UNIQUE")) {
            result = true;
            tokens.consume("UNIQUE");
            String uc_name = "UC_1";
            AstNode constraintNode = this.nodeFactory().node(uc_name, columnNode.getParent(), mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"UNIQUE");
            this.nodeFactory().node(colName, constraintNode, "ddl:columnReference");
        } else if (tokens.matches("PRIMARY", new String[]{"KEY"})) {
            result = true;
            tokens.consume("PRIMARY", new String[]{"KEY"});
            String pk_name = "PK_1";
            AstNode constraintNode = this.nodeFactory().node(pk_name, columnNode.getParent(), mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"PRIMARY KEY");
            this.nodeFactory().node(colName, constraintNode, "ddl:columnReference");
        } else if (tokens.matches("FOREIGN", new String[]{"KEY"})) {
            result = true;
            tokens.consume("FOREIGN", new String[]{"KEY"});
            String constraintName = this.parseName(tokens);
            AstNode constraintNode = this.nodeFactory().node(constraintName, columnNode.getParent(), mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"FOREIGN KEY");
            this.nodeFactory().node(colName, constraintNode, "ddl:columnReference");
            this.parseReferences(tokens, constraintNode);
            this.parseConstraintAttributes(tokens, constraintNode);
        } else if (tokens.matches("REFERENCES")) {
            result = true;
            String constraintName = "FK_1";
            AstNode constraintNode = this.nodeFactory().node(constraintName, columnNode.getParent(), mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"FOREIGN KEY");
            this.nodeFactory().node(colName, constraintNode, "ddl:columnReference");
            this.parseReferences(tokens, constraintNode);
            this.parseConstraintAttributes(tokens, constraintNode);
        } else if (tokens.matches("CHECK")) {
            result = true;
            tokens.consume("CHECK");
            String ck_name = "CHECK_1";
            AstNode constraintNode = this.nodeFactory().node(ck_name, columnNode.getParent(), mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"CHECK");
            String clause = this.consumeParenBoundedTokens(tokens, true);
            constraintNode.setProperty("ddl:searchCondition", (Object)clause);
        }
        return result;
    }

    protected void parseTableConstraint(DdlTokenStream tokens, AstNode tableNode, boolean isAlterTable) throws ParsingException {
        assert (tokens != null);
        assert (tableNode != null);
        String mixinType = isAlterTable ? "ddl:addTableConstraintDefinition" : "ddl:tableConstraint";
        this.consumeComment(tokens);
        if (tokens.matches("PRIMARY", new String[]{"KEY"}) || tokens.matches("FOREIGN", new String[]{"KEY"}) || tokens.matches("UNIQUE")) {
            if (tokens.matches("UNIQUE")) {
                String uc_name = "UC_1";
                tokens.consume();
                AstNode constraintNode = this.nodeFactory().node(uc_name, tableNode, mixinType);
                constraintNode.setProperty("ddl:constraintType", (Object)"UNIQUE");
                this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
                this.parseConstraintAttributes(tokens, constraintNode);
                this.consumeComment(tokens);
            } else if (tokens.matches("PRIMARY", new String[]{"KEY"})) {
                String pk_name = "PK_1";
                tokens.consume("PRIMARY", new String[]{"KEY"});
                AstNode constraintNode = this.nodeFactory().node(pk_name, tableNode, mixinType);
                constraintNode.setProperty("ddl:constraintType", (Object)"PRIMARY KEY");
                this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
                this.parseConstraintAttributes(tokens, constraintNode);
                this.consumeComment(tokens);
            } else if (tokens.matches("FOREIGN", new String[]{"KEY"})) {
                String fk_name = "FK_1";
                tokens.consume("FOREIGN", new String[]{"KEY"});
                if (!tokens.matches("(")) {
                    fk_name = tokens.consume();
                }
                AstNode constraintNode = this.nodeFactory().node(fk_name, tableNode, mixinType);
                constraintNode.setProperty("ddl:constraintType", (Object)"FOREIGN KEY");
                this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
                this.parseReferences(tokens, constraintNode);
                this.parseConstraintAttributes(tokens, constraintNode);
                this.consumeComment(tokens);
            }
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "UNIQUE"})) {
            tokens.consume();
            String uc_name = this.parseName(tokens);
            tokens.consume("UNIQUE");
            AstNode constraintNode = this.nodeFactory().node(uc_name, tableNode, mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"UNIQUE");
            this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
            this.parseConstraintAttributes(tokens, constraintNode);
            this.consumeComment(tokens);
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "PRIMARY", "KEY"})) {
            tokens.consume("CONSTRAINT");
            String pk_name = this.parseName(tokens);
            tokens.consume("PRIMARY", new String[]{"KEY"});
            AstNode constraintNode = this.nodeFactory().node(pk_name, tableNode, mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"PRIMARY KEY");
            this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
            this.parseConstraintAttributes(tokens, constraintNode);
            this.consumeComment(tokens);
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "FOREIGN", "KEY"})) {
            tokens.consume("CONSTRAINT");
            String fk_name = this.parseName(tokens);
            tokens.consume("FOREIGN", new String[]{"KEY"});
            AstNode constraintNode = this.nodeFactory().node(fk_name, tableNode, mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"FOREIGN KEY");
            this.parseColumnNameList(tokens, constraintNode, "ddl:columnReference");
            this.parseReferences(tokens, constraintNode);
            this.parseConstraintAttributes(tokens, constraintNode);
            this.consumeComment(tokens);
        } else if (tokens.matches("CONSTRAINT", new String[]{"any value", "CHECK"})) {
            tokens.consume("CONSTRAINT");
            String ck_name = this.parseName(tokens);
            tokens.consume("CHECK");
            AstNode constraintNode = this.nodeFactory().node(ck_name, tableNode, mixinType);
            constraintNode.setProperty("ddl:constraintType", (Object)"CHECK");
            String clause = this.consumeParenBoundedTokens(tokens, true);
            constraintNode.setProperty("ddl:searchCondition", (Object)clause);
        }
    }

    protected void parseConstraintAttributes(DdlTokenStream tokens, AstNode constraintNode) throws ParsingException {
        AstNode attrNode;
        assert (tokens != null);
        assert (constraintNode != null);
        if (tokens.canConsume("INITIALLY", new String[]{"DEFERRED"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, "ddl:constraintAttribute");
            attrNode.setProperty("ddl:propValue", (Object)"INITIALLY DEFERRED");
        }
        if (tokens.canConsume("INITIALLY", new String[]{"IMMEDIATE"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, "ddl:constraintAttribute");
            attrNode.setProperty("ddl:propValue", (Object)"INITIALLY IMMEDIATE");
        }
        if (tokens.canConsume("NOT", new String[]{"DEFERRABLE"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, "ddl:constraintAttribute");
            attrNode.setProperty("ddl:propValue", (Object)"NOT DEFERRABLE");
        }
        if (tokens.canConsume("DEFERRABLE")) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, "ddl:constraintAttribute");
            attrNode.setProperty("ddl:propValue", (Object)"DEFERRABLE");
        }
        if (tokens.canConsume("INITIALLY", new String[]{"DEFERRED"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, "ddl:constraintAttribute");
            attrNode.setProperty("ddl:propValue", (Object)"INITIALLY DEFERRED");
        }
        if (tokens.canConsume("INITIALLY", new String[]{"IMMEDIATE"})) {
            attrNode = this.nodeFactory().node("CONSTRAINT_ATTRIBUTE", constraintNode, "ddl:constraintAttribute");
            attrNode.setProperty("ddl:propValue", (Object)"INITIALLY IMMEDIATE");
        }
    }

    protected void parseReferences(DdlTokenStream tokens, AstNode constraintNode) throws ParsingException {
        assert (tokens != null);
        assert (constraintNode != null);
        if (tokens.matches("REFERENCES")) {
            tokens.consume("REFERENCES");
            String tableName = this.parseName(tokens);
            this.nodeFactory().node(tableName, constraintNode, "ddl:tableReference");
            this.parseColumnNameList(tokens, constraintNode, "ddl:fkColumnReference");
            tokens.canConsume("MATCH", new String[]{"FULL"});
            tokens.canConsume("MATCH", new String[]{"PARTIAL"});
            while (tokens.canConsume("ON", new String[]{"UPDATE"}) || tokens.canConsume("ON", new String[]{"DELETE"})) {
                if (tokens.matches("CASCADE") || tokens.matches("NOW()")) {
                    tokens.consume();
                    continue;
                }
                if (tokens.matches("SET", new String[]{"NULL"})) {
                    tokens.consume("SET", new String[]{"NULL"});
                    continue;
                }
                if (tokens.matches("SET", new String[]{"DEFAULT"})) {
                    tokens.consume("SET", new String[]{"DEFAULT"});
                    continue;
                }
                if (tokens.matches("NO", new String[]{"ACTION"})) {
                    tokens.consume("NO", new String[]{"ACTION"});
                    continue;
                }
                LOGGER.debug(" ERROR:   ColumnDefinition REFERENCES has NO REFERENCIAL ACTION.", new Object[0]);
            }
        }
    }

    protected AstNode parseCreateViewStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        this.markStartOfStatement(tokens);
        String stmtType = "CREATE";
        tokens.consume("CREATE");
        if (tokens.canConsume("OR", new String[]{"REPLACE"})) {
            stmtType = stmtType + " " + "OR REPLACE";
        }
        tokens.consume("VIEW");
        stmtType = stmtType + " " + "VIEW";
        String name = this.parseName(tokens);
        AstNode createViewNode = this.nodeFactory().node(name, parentNode, "ddl:createViewStatement");
        this.parseColumnNameList(tokens, createViewNode, "ddl:columnReference");
        tokens.consume("AS");
        String queryExpression = this.parseUntilTerminator(tokens);
        createViewNode.setProperty("ddl:queryExpression", (Object)queryExpression);
        this.markEndOfStatement(tokens, createViewNode);
        return createViewNode;
    }

    protected AstNode parseCreateSchemaStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        AstNode schemaNode = null;
        String authorizationIdentifier = null;
        String schemaName = null;
        tokens.consume("CREATE", new String[]{"SCHEMA"});
        if (tokens.canConsume("AUTHORIZATION")) {
            authorizationIdentifier = tokens.consume();
        } else {
            schemaName = this.parseName(tokens);
            if (tokens.canConsume("AUTHORIZATION")) {
                authorizationIdentifier = this.parseName(tokens);
            }
        }
        assert (authorizationIdentifier != null || schemaName != null);
        schemaNode = schemaName != null ? this.nodeFactory().node(schemaName, parentNode, "ddl:createSchemaStatement") : this.nodeFactory().node(authorizationIdentifier, parentNode, "ddl:createSchemaStatement");
        if (tokens.canConsume("DEFAULT", new String[]{"CHARACTER", "SET"})) {
            this.parseName(tokens);
        }
        this.markEndOfStatement(tokens, schemaNode);
        return schemaNode;
    }

    protected AstNode parseCreateAssertionStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        this.markStartOfStatement(tokens);
        AstNode node = null;
        tokens.consume("CREATE", new String[]{"ASSERTION"});
        String name = this.parseName(tokens);
        node = this.nodeFactory().node(name, parentNode, "ddl:createAssertionStatement");
        tokens.consume("CHECK");
        String searchCondition = this.consumeParenBoundedTokens(tokens, false);
        node.setProperty("ddl:searchCondition", (Object)searchCondition);
        this.parseConstraintAttributes(tokens, node);
        this.markEndOfStatement(tokens, node);
        return node;
    }

    protected AstNode parseIgnorableStatement(DdlTokenStream tokens, String name, AstNode parentNode) {
        AstNode node = this.nodeFactory().node(name, parentNode, "ddl:statement");
        this.parseUntilTerminator(tokens);
        return node;
    }

    protected AstNode parseIgnorableStatement(DdlTokenStream tokens, String name, AstNode parentNode, String mixinType) {
        CheckArg.isNotNull((Object)((Object)tokens), (String)"tokens");
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        CheckArg.isNotNull((Object)mixinType, (String)"mixinType");
        AstNode node = this.nodeFactory().node(name, parentNode, mixinType);
        this.parseUntilTerminator(tokens);
        return node;
    }

    protected AstNode parseStatement(DdlTokenStream tokens, String[] stmt_start_phrase, AstNode parentNode, String mixinType) {
        CheckArg.isNotNull((Object)((Object)tokens), (String)"tokens");
        CheckArg.isNotNull((Object)stmt_start_phrase, (String)"stmt_start_phrase");
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        CheckArg.isNotNull((Object)mixinType, (String)"mixinType");
        this.markStartOfStatement(tokens);
        tokens.consume(stmt_start_phrase);
        AstNode result = this.parseIgnorableStatement(tokens, this.getStatementTypeName(stmt_start_phrase), parentNode, mixinType);
        this.markEndOfStatement(tokens, result);
        return result;
    }

    public final AstNode unknownTerminatedNode(AstNode parentNode) {
        return this.nodeFactory.node("unknownStatement", parentNode, "ddl:unknownStatement");
    }

    public final AstNode missingTerminatorNode(AstNode parentNode) {
        return this.nodeFactory.node("missingTerminator", parentNode, "ddl:missingTerminator");
    }

    public final boolean isMissingTerminatorNode(AstNode node) {
        return node.getName().equals("missingTerminator") && this.nodeFactory().hasMixinType(node, "ddl:missingTerminator");
    }

    public final boolean isValidSchemaChild(AstNode node) {
        List<String> schemaChildMixins = Arrays.asList(this.getValidSchemaChildTypes());
        for (String mixin : node.getMixins()) {
            if (!schemaChildMixins.contains(mixin)) continue;
            return true;
        }
        return false;
    }

    public final boolean setAsSchemaChildNode(AstNode statementNode, boolean stmtIsMissingTerminator) {
        if (!this.isValidSchemaChild(statementNode)) {
            return false;
        }
        List<AstNode> children = this.getRootNode().getChildren();
        if (children.size() > 2) {
            AstNode theSchemaNode;
            AstNode previousNode = children.get(children.size() - 2);
            if (this.nodeFactory().hasMixinType(previousNode, "ddl:missingTerminator") && ((theSchemaNode = children.get(children.size() - 3)).getChildCount() == 0 || this.nodeFactory().hasMixinType(theSchemaNode.getLastChild(), "ddl:missingTerminator")) && this.nodeFactory().hasMixinType(theSchemaNode, "ddl:createSchemaStatement")) {
                statementNode.setParent(theSchemaNode);
                if (stmtIsMissingTerminator) {
                    this.missingTerminatorNode(theSchemaNode);
                }
                return true;
            }
        }
        return false;
    }

    protected String getTerminator() {
        return this.terminator;
    }

    protected boolean setTerminator(String terminator) {
        CheckArg.isNotNull((Object)terminator, (String)"terminator");
        if (this.terminator.equalsIgnoreCase(terminator)) {
            return false;
        }
        this.terminator = terminator;
        return true;
    }

    protected String[] getValidSchemaChildTypes() {
        return VALID_SCHEMA_CHILD_TYPES;
    }

    protected boolean isComment(DdlTokenStream tokens) throws ParsingException {
        return tokens.matches(32);
    }

    protected boolean consumeComment(DdlTokenStream tokens) throws ParsingException {
        return tokens.canConsume(32);
    }

    protected boolean isTableConstraint(DdlTokenStream tokens) throws ParsingException {
        boolean result = false;
        if (tokens.matches("PRIMARY", new String[]{"KEY"}) || tokens.matches("FOREIGN", new String[]{"KEY"}) || tokens.matches("UNIQUE")) {
            result = true;
        } else if (tokens.matches("CONSTRAINT") && (tokens.matches("CONSTRAINT", new String[]{"any value", "UNIQUE"}) || tokens.matches("CONSTRAINT", new String[]{"any value", "PRIMARY", "KEY"}) || tokens.matches("CONSTRAINT", new String[]{"any value", "FOREIGN", "KEY"}) || tokens.matches("CONSTRAINT", new String[]{"any value", "CHECK"}))) {
            result = true;
        }
        return result;
    }

    protected boolean isColumnDefinitionStart(DdlTokenStream tokens) throws ParsingException {
        boolean result = false;
        if (this.isTableConstraint(tokens)) {
            result = false;
        } else {
            String dTypeStartWord;
            Iterator<String> iterator = this.getDataTypeStartWords().iterator();
            while (iterator.hasNext() && !(result = tokens.matches("any value", new String[]{dTypeStartWord = iterator.next()}) || tokens.matches("COLUMN", new String[]{"any value", dTypeStartWord}))) {
            }
        }
        return result;
    }

    protected List<String> getDataTypeStartWords() {
        if (this.allDataTypeStartWords == null) {
            this.allDataTypeStartWords = new ArrayList<String>();
            this.allDataTypeStartWords.addAll(DdlConstants.DataTypes.DATATYPE_START_WORDS);
            this.allDataTypeStartWords.addAll(this.getCustomDataTypeStartWords());
        }
        return this.allDataTypeStartWords;
    }

    protected List<String> getCustomDataTypeStartWords() {
        return Collections.emptyList();
    }

    protected String parseName(DdlTokenStream tokens) {
        StringBuilder sb = new StringBuilder();
        if (tokens.matches('[')) {
            while (true) {
                tokens.consume('[');
                sb.append(this.consumeIdentifier(tokens));
                tokens.consume(']');
                if (tokens.matches('.')) {
                    sb.append(tokens.consume());
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                sb.append(this.consumeIdentifier(tokens));
                if (!tokens.matches('.')) break;
                sb.append(tokens.consume());
            }
        }
        return sb.toString();
    }

    protected String consumeIdentifier(DdlTokenStream tokens) throws ParsingException {
        String value = tokens.consume();
        if (value.charAt(0) == '\"') {
            int length = value.length();
            value = value.substring(1, length - 1);
        }
        return value;
    }

    protected boolean isTerminator(DdlTokenStream tokens) throws ParsingException {
        boolean result = tokens.matches(this.getTerminator());
        return result;
    }

    protected boolean parseColumnNameList(DdlTokenStream tokens, AstNode parentNode, String referenceType) {
        boolean parsedColumns = false;
        List<Object> columnNameList = new ArrayList();
        if (tokens.matches("(")) {
            tokens.consume("(");
            columnNameList = this.parseNameList(tokens);
            if (!columnNameList.isEmpty()) {
                parsedColumns = true;
            }
            tokens.consume(")");
        }
        for (String string : columnNameList) {
            this.nodeFactory().node(string, parentNode, referenceType);
        }
        return parsedColumns;
    }

    protected List<String> parseNameList(DdlTokenStream tokens) throws ParsingException {
        LinkedList<String> names = new LinkedList<String>();
        do {
            names.add(this.parseName(tokens));
        } while (tokens.canConsume(","));
        return names;
    }

    protected String parseUntilTerminator(DdlTokenStream tokens) throws ParsingException {
        StringBuilder sb = new StringBuilder();
        boolean lastTokenWasPeriod = false;
        Position prevPosition = tokens.hasNext() ? tokens.nextPosition() : Position.EMPTY_CONTENT_POSITION;
        String prevToken = "";
        while (tokens.hasNext() && !tokens.matches(128) && (this.doUseTerminator() && !this.isTerminator(tokens) || !this.doUseTerminator())) {
            Position currPosition = tokens.nextPosition();
            String thisToken = tokens.consume();
            boolean thisTokenIsPeriod = thisToken.equals(".");
            boolean thisTokenIsComma = thisToken.equals(",");
            if (lastTokenWasPeriod || thisTokenIsPeriod || thisTokenIsComma) {
                sb.append(thisToken);
            } else if (currPosition.getIndexInContent() - prevPosition.getIndexInContent() - prevToken.length() > 0) {
                sb.append(" ").append(thisToken);
            } else {
                sb.append(thisToken);
            }
            lastTokenWasPeriod = thisTokenIsPeriod;
            prevToken = thisToken;
            prevPosition = currPosition;
        }
        return sb.toString();
    }

    protected String parseUntilTerminatorIgnoreEmbeddedStatements(DdlTokenStream tokens) throws ParsingException {
        StringBuilder sb = new StringBuilder();
        boolean lastTokenWasPeriod = false;
        Position prevPosition = Position.EMPTY_CONTENT_POSITION;
        String prevToken = "";
        while (tokens.hasNext() && !this.isTerminator(tokens)) {
            Position currPosition = tokens.nextPosition();
            String thisToken = tokens.consume();
            boolean thisTokenIsPeriod = thisToken.equals(".");
            boolean thisTokenIsComma = thisToken.equals(",");
            if (lastTokenWasPeriod || thisTokenIsPeriod || thisTokenIsComma) {
                sb.append(thisToken);
            } else if (currPosition.getIndexInContent() - prevPosition.getIndexInContent() - prevToken.length() > 0) {
                sb.append(" ").append(thisToken);
            } else {
                sb.append(thisToken);
            }
            lastTokenWasPeriod = thisTokenIsPeriod;
            prevToken = thisToken;
            prevPosition = currPosition;
        }
        return sb.toString();
    }

    protected String parseUntilSemiColon(DdlTokenStream tokens) throws ParsingException {
        StringBuilder sb = new StringBuilder();
        boolean lastTokenWasPeriod = false;
        while (tokens.hasNext() && !tokens.matches(";")) {
            String thisToken = tokens.consume();
            boolean thisTokenIsPeriod = thisToken.equals(".");
            boolean thisTokenIsComma = thisToken.equals(",");
            if (lastTokenWasPeriod || thisTokenIsPeriod || thisTokenIsComma) {
                sb.append(thisToken);
            } else {
                sb.append(" ").append(thisToken);
            }
            if (thisTokenIsPeriod) {
                lastTokenWasPeriod = true;
                continue;
            }
            lastTokenWasPeriod = false;
        }
        return sb.toString();
    }

    protected String parseUntilCommaOrTerminator(DdlTokenStream tokens) throws ParsingException {
        StringBuilder sb = new StringBuilder();
        if (this.doUseTerminator()) {
            while (tokens.hasNext() && !tokens.matches(128) && !this.isTerminator(tokens) && !tokens.matches(",")) {
                sb.append(" ").append(tokens.consume());
            }
        } else {
            while (tokens.hasNext() && !tokens.matches(128) && !tokens.matches(",")) {
                sb.append(" ").append(tokens.consume());
            }
        }
        return sb.toString();
    }

    public boolean doUseTerminator() {
        return this.useTerminator;
    }

    public void setDoUseTerminator(boolean useTerminator) {
        this.useTerminator = useTerminator;
    }

    public String getStatementTypeName(String[] stmtPhrase) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < stmtPhrase.length; ++i) {
            if (i == 0) {
                sb.append(stmtPhrase[0]);
                continue;
            }
            sb.append(" ").append(stmtPhrase[i]);
        }
        return sb.toString();
    }

    protected boolean parseDefaultClause(DdlTokenStream tokens, AstNode columnNode) throws ParsingException {
        assert (tokens != null);
        assert (columnNode != null);
        String defaultValue = "";
        if (tokens.canConsume("DEFAULT")) {
            String optionID;
            int precision = -1;
            if (tokens.canConsume("CURRENT_DATE") || tokens.canConsume("'CURRENT_DATE'")) {
                optionID = "DATETIME";
                defaultValue = "CURRENT_DATE";
            } else if (tokens.canConsume("CURRENT_TIME") || tokens.canConsume("'CURRENT_TIME'")) {
                optionID = "DATETIME";
                defaultValue = "CURRENT_TIME";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("CURRENT_TIMESTAMP") || tokens.canConsume("'CURRENT_TIMESTAMP'")) {
                optionID = "DATETIME";
                defaultValue = "CURRENT_TIMESTAMP";
                if (tokens.canConsume("(")) {
                    precision = this.integer(tokens.consume());
                    tokens.canConsume(")");
                }
            } else if (tokens.canConsume("USER") || tokens.canConsume("'USER'")) {
                optionID = "USER";
                defaultValue = "USER";
            } else if (tokens.canConsume("CURRENT_USER") || tokens.canConsume("'CURRENT_USER'")) {
                optionID = "CURRENT_USER";
                defaultValue = "CURRENT_USER";
            } else if (tokens.canConsume("SESSION_USER") || tokens.canConsume("'SESSION_USER'")) {
                optionID = "SESSION_USER";
                defaultValue = "SESSION_USER";
            } else if (tokens.canConsume("SYSTEM_USER") || tokens.canConsume("'SYSTEM_USER'")) {
                optionID = "SYSTEM_USER";
                defaultValue = "SYSTEM_USER";
            } else if (tokens.canConsume("NULL") || tokens.canConsume("NULL")) {
                optionID = "NULL";
                defaultValue = "NULL";
            } else if (tokens.canConsume("(")) {
                optionID = "LITERAL";
                while (!tokens.canConsume(")")) {
                    defaultValue = defaultValue + tokens.consume();
                }
            } else {
                optionID = "LITERAL";
                defaultValue = tokens.consume();
                if (defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                    defaultValue = defaultValue.length() > 2 ? defaultValue.substring(1, defaultValue.lastIndexOf(39)) : "";
                }
                if (tokens.canConsume(".")) {
                    defaultValue = defaultValue + '.' + tokens.consume();
                }
            }
            columnNode.setProperty("ddl:defaultOption", (Object)optionID);
            columnNode.setProperty("ddl:defaultValue", (Object)defaultValue);
            if (precision > -1) {
                columnNode.setProperty("ddl:defaultprecision", (Object)precision);
            }
            return true;
        }
        return false;
    }

    protected boolean parseCollateClause(DdlTokenStream tokens, AstNode columnNode) throws ParsingException {
        assert (tokens != null);
        assert (columnNode != null);
        if (tokens.matches("COLLATE")) {
            tokens.consume("COLLATE");
            String collationName = this.parseName(tokens);
            columnNode.setProperty("ddl:collationName", (Object)collationName);
            return true;
        }
        return false;
    }

    protected int integer(String value) {
        assert (value != null);
        assert (value.length() > 0);
        return new BigInteger(value).intValue();
    }

    public final Position getCurrentMarkedPosition() {
        return this.currentMarkedPosition;
    }

    public final void markStartOfStatement(DdlTokenStream tokens) {
        tokens.mark();
        this.currentMarkedPosition = tokens.nextPosition();
    }

    public final void markEndOfStatement(DdlTokenStream tokens, AstNode statementNode) {
        if (!tokens.canConsume(this.getTerminator())) {
            if (!this.setAsSchemaChildNode(statementNode, true)) {
                this.missingTerminatorNode(this.getRootNode());
            }
        } else {
            this.setAsSchemaChildNode(statementNode, false);
        }
        String source = tokens.getMarkedContent().trim();
        statementNode.setProperty("ddl:expression", (Object)source);
        statementNode.setProperty("ddl:length", (Object)source.length());
        statementNode.setProperty("ddl:startLineNumber", (Object)this.currentMarkedPosition.getLine());
        statementNode.setProperty("ddl:startCharIndex", (Object)this.currentMarkedPosition.getIndexInContent());
        statementNode.setProperty("ddl:startColumnNumber", (Object)this.currentMarkedPosition.getColumn());
        this.testPrint("== >> SOURCE:\n" + source + "\n");
    }

    @Override
    public void postProcess(AstNode rootNode) {
    }

    protected void testPrint(String str) {
        if (this.isTestMode()) {
            System.out.println(str);
        }
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public String getId() {
        return ID;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DdlParser) {
            return ((DdlParser)obj).getId().equals(this.getId());
        }
        return false;
    }
}

