/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.vdb;

import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.teiid.modeshape.sequencer.vdb.TeiidI18n;
import org.teiid.modeshape.sequencer.vdb.VdbManifest;
import org.teiid.modeshape.sequencer.vdb.VdbSequencer;

public class VdbDynamicSequencer
extends VdbSequencer {
    @Override
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        LOGGER.debug("VdbDynamicSequencer.execute called:outputNode name='{0}', path='{1}'", new Object[]{outputNode.getName(), outputNode.getPath()});
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        try (InputStream stream = binaryValue.getStream();){
            VdbManifest manifest = this.readManifest(binaryValue, stream, outputNode, context);
            if (manifest == null) {
                throw new Exception("VdbDynamicSequencer.execute failed. The xml cannot be read.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(TeiidI18n.errorReadingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), e);
        }
        return true;
    }

    public boolean sequenceVdb(InputStream vdbStream, Node vdbOutputNode) throws Exception {
        CheckArg.isNotNull((Object)vdbStream, (String)"vdbStream");
        if (!vdbOutputNode.isNodeType("vdb:virtualDatabase")) {
            throw new RuntimeException(TeiidI18n.invalidVdbModelNodeType.text(new Object[]{vdbOutputNode.getPath()}));
        }
        try {
            VdbManifest manifest = this.readManifest(null, vdbStream, vdbOutputNode, null);
            if (manifest == null) {
                throw new Exception("VdbDynamicSequencer.execute failed. The xml cannot be read.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(TeiidI18n.errorReadingVdbFile.text(new Object[]{vdbOutputNode.getPath(), e.getMessage()}), e);
        }
        return true;
    }
}

