/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.vdb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.teiid.modeshape.sequencer.vdb.ImportVdb;
import org.teiid.modeshape.sequencer.vdb.TeiidI18n;
import org.teiid.modeshape.sequencer.vdb.VdbDataRole;
import org.teiid.modeshape.sequencer.vdb.VdbEntry;
import org.teiid.modeshape.sequencer.vdb.VdbManifest;
import org.teiid.modeshape.sequencer.vdb.VdbModel;
import org.teiid.modeshape.sequencer.vdb.VdbTranslator;
import org.teiid.modeshape.sequencer.vdb.model.ModelSequencer;
import org.teiid.modeshape.sequencer.vdb.model.ReferenceResolver;

@ThreadSafe
public class VdbSequencer
extends Sequencer {
    private static final String DDL_FILE_EXT = ".ddl";
    private static final String LIB_FOLDER = "lib/";
    protected static final Logger LOGGER = Logger.getLogger(VdbSequencer.class);
    private static final String MANIFEST_FILE = "META-INF/vdb.xml";
    private static final Pattern VERSION_REGEX = Pattern.compile("(.*)[.]\\s*[+-]?([0-9]+)\\s*$");
    private ModelSequencer modelSequencer;

    public static String extractVersionInformation(String fileNameWithoutExtension, AtomicInteger version) {
        Matcher matcher = VERSION_REGEX.matcher(fileNameWithoutExtension);
        if (matcher.matches()) {
            fileNameWithoutExtension = matcher.group(1);
            version.set(Integer.parseInt(matcher.group(2)));
        }
        return fileNameWithoutExtension.replaceAll("[.]*$", "");
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        ZipEntry entry2;
        Throwable throwable;
        LOGGER.debug("VdbSequencer.execute called:outputNode name='{0}', path='{1}'", new Object[]{outputNode.getName(), outputNode.getPath()});
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        VdbManifest manifest = null;
        boolean processDdlFiles = false;
        boolean processLibFiles = false;
        ArrayList<String> ddlFileModelsFound = new ArrayList<String>();
        try {
            throwable = null;
            try (ZipInputStream vdbStream = new ZipInputStream(binaryValue.getStream());){
                entry2 = null;
                ReferenceResolver resolver = new ReferenceResolver();
                while ((entry2 = vdbStream.getNextEntry()) != null) {
                    String entryName = entry2.getName();
                    if (entryName.endsWith(MANIFEST_FILE)) {
                        manifest = this.readManifest(binaryValue, vdbStream, outputNode, context);
                        continue;
                    }
                    if (!entry2.isDirectory() && this.modelSequencer.hasModelFileExtension(entryName)) {
                        Node modelNode;
                        boolean sequenced;
                        LOGGER.debug("before reading model '{0}'", new Object[]{entryName});
                        if (manifest == null) {
                            throw new Exception(TeiidI18n.missingVdbManifest.text(new Object[]{outputNode.getPath()}));
                        }
                        VdbModel vdbModel = manifest.getModel(entryName);
                        if (vdbModel == null) {
                            throw new Exception(TeiidI18n.missingVdbModel.text(new Object[]{entryName, outputNode.getPath()}));
                        }
                        int index = entryName.lastIndexOf(47) + 1;
                        if (index != -1 && index < entryName.length()) {
                            entryName = entryName.substring(index);
                        }
                        if (!(sequenced = this.modelSequencer.sequenceVdbModel(vdbStream, modelNode = outputNode.addNode(entryName, "vdb:model"), vdbModel, resolver, context))) {
                            modelNode.remove();
                            LOGGER.debug(">>>>model NOT sequenced '{0}'\n\n", new Object[]{entryName});
                            continue;
                        }
                        LOGGER.debug(">>>>done sequencing model '{0}'\n\n", new Object[]{entryName});
                        continue;
                    }
                    if (this.isDdlFile(entryName)) {
                        String modelName;
                        if (manifest == null) {
                            processDdlFiles = true;
                            continue;
                        }
                        if (processDdlFiles || StringUtil.isBlank((String)(modelName = this.sequenceDdlFile(vdbStream, entryName, manifest, outputNode)))) continue;
                        ddlFileModelsFound.add(modelName);
                        continue;
                    }
                    if (!entry2.isDirectory() && entryName.startsWith(LIB_FOLDER)) {
                        if (manifest == null) {
                            processLibFiles = true;
                            continue;
                        }
                        if (processLibFiles) continue;
                        this.sequenceLibResource(vdbStream, entryName, outputNode);
                        continue;
                    }
                    LOGGER.debug("ignoring resource '{0}'", new Object[]{entryName});
                }
            }
            catch (Throwable entry2) {
                throwable = entry2;
                throw entry2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(TeiidI18n.errorReadingVdbFile.text(new Object[]{inputProperty.getPath(), e.getMessage()}), e);
        }
        if (manifest == null) {
            throw new Exception(TeiidI18n.missingVdbManifest.text(new Object[]{outputNode.getPath()}));
        }
        if (processLibFiles || processDdlFiles) {
            LOGGER.debug("second pass: /lib resources = {0}, DDL files = {1}", new Object[]{processLibFiles, processDdlFiles});
            throwable = null;
            try (ZipInputStream zis = new ZipInputStream(binaryValue.getStream());){
                entry2 = null;
                while ((entry2 = zis.getNextEntry()) != null) {
                    String modelName;
                    String entryName = entry2.getName();
                    if (entry2.isDirectory()) continue;
                    if (processLibFiles && entryName.startsWith(LIB_FOLDER)) {
                        this.sequenceLibResource(zis, entryName, outputNode);
                        continue;
                    }
                    if (!processDdlFiles || !this.isDdlFile(entryName) || StringUtil.isBlank((String)(modelName = this.sequenceDdlFile(zis, entryName, manifest, outputNode)))) continue;
                    ddlFileModelsFound.add(modelName);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        for (VdbModel model : manifest.getModels()) {
            if (!"DDL-FILE".equals(model.getMetadataType()) || ddlFileModelsFound.contains(model.getName())) continue;
            throw new Exception(TeiidI18n.ddlFileMissing.text(new Object[]{model.getDdlFileEntryPath(), model.getName()}));
        }
        return true;
    }

    private boolean isDdlFile(String fileName) {
        return fileName.endsWith(DDL_FILE_EXT);
    }

    protected VdbManifest readManifest(Binary binaryValue, InputStream inputStream, Node outputNode, Sequencer.Context context) throws Exception {
        LOGGER.debug("----before reading vdb.xml", new Object[0]);
        VdbManifest manifest = VdbManifest.read(inputStream, context);
        assert (manifest != null) : "manifest is null";
        outputNode.setPrimaryType("vdb:virtualDatabase");
        outputNode.addMixin("mix:referenceable");
        outputNode.setProperty("vdb:version", (long)manifest.getVersion());
        outputNode.setProperty("vdb:originalFile", outputNode.getPath());
        if (binaryValue != null) {
            outputNode.setProperty("mode:sha1", ((org.modeshape.jcr.api.Binary)binaryValue).getHexHash());
        }
        this.setProperty(outputNode, "vdb:name", manifest.getName());
        this.setProperty(outputNode, "vdb:description", manifest.getDescription());
        this.setProperty(outputNode, "vdb:connectionType", manifest.getConnectionType());
        this.sequenceImportVdbs(manifest, outputNode);
        this.sequenceTranslators(manifest, outputNode);
        this.sequenceDataRoles(manifest, outputNode);
        this.sequenceEntries(manifest, outputNode);
        this.sequenceProperties(manifest, outputNode);
        this.sequenceDeclarativeModels(manifest, outputNode);
        LOGGER.debug(">>>>done reading vdb.xml\n\n", new Object[0]);
        return manifest;
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        LOGGER.debug("enter initialize", new Object[0]);
        this.modelSequencer = new ModelSequencer();
        this.modelSequencer.initialize(registry, nodeTypeManager);
        URL vdbCndUrl = ((Object)((Object)this)).getClass().getResource("/org/teiid/modeshape/sequencer/vdb/vdb.cnd");
        this.registerNodeTypes(vdbCndUrl.openStream(), nodeTypeManager, true);
        LOGGER.debug("vdb.cnd loaded", new Object[0]);
        LOGGER.debug("exit initialize", new Object[0]);
    }

    private void sequenceDataRoles(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbDataRole> dataRolesGroup = manifest.getDataRoles();
        if (!dataRolesGroup.isEmpty()) {
            Node dataRolesGroupNode = outputNode.addNode("vdb:dataRoles", "vdb:dataRoles");
            for (VdbDataRole dataRole : dataRolesGroup) {
                List<VdbDataRole.Permission> permissionsGroup;
                Node dataRoleNode = dataRolesGroupNode.addNode(dataRole.getName(), "vdb:dataRole");
                this.setProperty(dataRoleNode, "vdb:description", dataRole.getDescription());
                dataRoleNode.setProperty("vdb:anyAuthenticated", dataRole.isAnyAuthenticated());
                dataRoleNode.setProperty("vdb:allowCreateTemporaryTables", dataRole.isAllowCreateTempTables());
                dataRoleNode.setProperty("vdb:grantAll", dataRole.isGrantAll());
                List<String> roleNames = dataRole.getMappedRoleNames();
                if (!roleNames.isEmpty()) {
                    dataRoleNode.setProperty("vdb:mappedRoleNames", roleNames.toArray(new String[roleNames.size()]));
                }
                if ((permissionsGroup = dataRole.getPermissions()).isEmpty()) continue;
                Node permissionsGroupNode = dataRoleNode.addNode("vdb:permissions", "vdb:permissions");
                for (VdbDataRole.Permission permission : permissionsGroup) {
                    List<VdbDataRole.Mask> masks;
                    Node permissionNode = permissionsGroupNode.addNode(permission.getResourceName(), "vdb:permission");
                    permissionNode.setProperty("vdb:allowAlter", permission.canAlter());
                    permissionNode.setProperty("vdb:allowCreate", permission.canCreate());
                    permissionNode.setProperty("vdb:allowDelete", permission.canDelete());
                    permissionNode.setProperty("vdb:allowExecute", permission.canExecute());
                    permissionNode.setProperty("vdb:allowRead", permission.canRead());
                    permissionNode.setProperty("vdb:allowUpdate", permission.canUpdate());
                    permissionNode.setProperty("vdb:allowLanguage", permission.useLanguage());
                    List<VdbDataRole.Condition> conditions = permission.getConditions();
                    if (!conditions.isEmpty()) {
                        Node conditionsGroupNode = permissionNode.addNode("vdb:conditions", "vdb:conditions");
                        for (VdbDataRole.Condition condition : conditions) {
                            Node conditionNode = conditionsGroupNode.addNode(condition.getRule(), "vdb:condition");
                            conditionNode.setProperty("vdb:constraint", condition.isConstraint());
                        }
                    }
                    if ((masks = permission.getMasks()).isEmpty()) continue;
                    Node masksGroupNode = permissionNode.addNode("vdb:masks", "vdb:masks");
                    for (VdbDataRole.Mask mask : masks) {
                        Node maskNode = masksGroupNode.addNode(mask.getRule(), "vdb:mask");
                        maskNode.setProperty("vdb:order", (long)mask.getOrder());
                    }
                }
            }
        }
    }

    private String sequenceDdlFile(ZipInputStream vdbStream, String entryName, VdbManifest manifest, Node outputNode) throws Exception {
        LOGGER.debug("processing DDL file '{0}'", new Object[]{entryName});
        boolean modelFound = false;
        for (VdbModel model : manifest.getModels()) {
            String metadataType = model.getMetadataType();
            if (!"DDL-FILE".equals(metadataType)) continue;
            String ddlFileEntryPath = model.getDdlFileEntryPath();
            LOGGER.debug("metadataType='{0}', entryName='{1}', ddlFileEntryPath='{2}'", new Object[]{metadataType, ddlFileEntryPath, entryName});
            if (!StringUtil.isBlank((String)ddlFileEntryPath) && ddlFileEntryPath.startsWith("/")) {
                ddlFileEntryPath = ddlFileEntryPath.substring(1);
            }
            if (!ddlFileEntryPath.equals(entryName)) continue;
            String modelName = model.getName();
            NodeIterator itr = outputNode.getNodes(modelName);
            if (itr.getSize() != 0L) {
                modelFound = true;
                Node modelNode = itr.nextNode();
                Scanner scanner = new Scanner((InputStream)vdbStream, "UTF-8").useDelimiter("\\A");
                String ddl = scanner.next().replaceAll("\\s{2,}", " ");
                modelNode.setProperty("vdb:modelDefinition", ddl);
                LOGGER.debug("Using DDL file content to set model '{0}' metadata to: '{1}'", new Object[]{modelName, ddl});
                return modelName;
            }
            throw new Exception(TeiidI18n.missingModelNodeThatReferencesDdlFile.text(new Object[]{modelName, ddlFileEntryPath}));
        }
        if (!modelFound) {
            LOGGER.debug("DDL file '{0}' was not used in a DDL-FILE model", new Object[]{entryName});
        }
        return null;
    }

    private void sequenceDeclarativeModels(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        for (VdbModel model : manifest.getModels()) {
            List<VdbModel.Source> sources;
            if (!model.isDeclarative()) continue;
            LOGGER.debug(">>>>writing declarative model '{0}'", new Object[]{model.getName()});
            Node modelNode = outputNode.addNode(model.getName(), "vdb:declarativeModel");
            this.setProperty(modelNode, "vdb:description", model.getDescription());
            modelNode.setProperty("vdb:visible", model.isVisible());
            this.setProperty(modelNode, "vdb:pathInVdb", model.getPathInVdb());
            this.setProperty(modelNode, "mmcore:modelType", model.getType());
            this.setProperty(modelNode, "vdb:metadataType", model.getMetadataType());
            this.setProperty(modelNode, "vdb:modelDefinition", model.getModelDefinition());
            if ("DDL-FILE".equals(model.getMetadataType())) {
                this.setProperty(modelNode, "vdb:ddlFileEntryPath", model.getDdlFileEntryPath());
            }
            if (!(sources = model.getSources()).isEmpty()) {
                Node modelSourcesGroupNode = modelNode.addNode("vdb:sources", "vdb:sources");
                for (VdbModel.Source source : sources) {
                    Node sourceNode = modelSourcesGroupNode.addNode(source.getName(), "vdb:source");
                    sourceNode.setProperty("vdb:sourceTranslator", source.getTranslator());
                    sourceNode.setProperty("vdb:sourceJndiName", source.getJndiName());
                }
            }
            for (Map.Entry<String, String> entry : model.getProperties().entrySet()) {
                this.setProperty(modelNode, entry.getKey(), entry.getValue());
            }
        }
    }

    private void sequenceEntries(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbEntry> entriesGroup = manifest.getEntries();
        if (!entriesGroup.isEmpty()) {
            Node entriesGroupNode = outputNode.addNode("vdb:entries", "vdb:entries");
            for (VdbEntry entry : entriesGroup) {
                Node entryNode = entriesGroupNode.addNode("vdb:entry", "vdb:entry");
                this.setProperty(entryNode, "vdb:path", entry.getPath());
                this.setProperty(entryNode, "vdb:description", entry.getDescription());
                Map<String, String> props = entry.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(entryNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void sequenceImportVdbs(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<ImportVdb> importVdbsGroup = manifest.getImportVdbs();
        if (!importVdbsGroup.isEmpty()) {
            Node importVdbsGroupNode = outputNode.addNode("vdb:importVdbs", "vdb:importVdbs");
            for (ImportVdb importVdb : importVdbsGroup) {
                Node importVdbNode = importVdbsGroupNode.addNode(importVdb.getName(), "vdb:importVdb");
                importVdbNode.setProperty("vdb:version", (long)importVdb.getVersion());
                importVdbNode.setProperty("vdb:importDataPolicies", importVdb.isImportDataPolicies());
            }
        }
    }

    private void sequenceLibResource(ZipInputStream zis, String entryPath, Node outputNode) throws Exception {
        LOGGER.debug("processing /lib resource '{0}'", new Object[]{entryPath});
        String resourceName = entryPath.substring(entryPath.lastIndexOf(47));
        byte[] buf = new byte[1024];
        File file = File.createTempFile(resourceName, null);
        try (FileOutputStream fos = new FileOutputStream(file);){
            int numRead = 0;
            while ((numRead = zis.read(buf)) > 0) {
                fos.write(buf, 0, numRead);
            }
        }
        Node resourcesNode = null;
        resourcesNode = outputNode.hasNode("vdb:resources") ? outputNode.getNode("vdb:resources") : outputNode.addNode("vdb:resources", "vdb:resources");
        Node resourceNode = resourcesNode.addNode(resourceName, "nt:file");
        Node contentNode = resourceNode.addNode("jcr:content", "nt:resource");
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        Binary binary = outputNode.getSession().getValueFactory().createBinary((InputStream)is);
        contentNode.setProperty("jcr:data", binary);
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(file.lastModified());
        contentNode.setProperty("jcr:lastModified", lastModified);
    }

    private void sequenceProperties(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        Map<String, String> props = manifest.getProperties();
        if (!props.isEmpty()) {
            for (Map.Entry<String, String> prop : props.entrySet()) {
                if ("preview".equals(prop.getKey())) {
                    outputNode.setProperty("vdb:preview", Boolean.parseBoolean(prop.getValue()));
                    continue;
                }
                this.setProperty(outputNode, prop.getKey(), prop.getValue());
            }
        }
    }

    private void sequenceTranslators(VdbManifest manifest, Node outputNode) throws Exception {
        assert (manifest != null) : "manifest is null";
        assert (outputNode != null) : "outputNode is null";
        List<VdbTranslator> translatorsGroup = manifest.getTranslators();
        if (!translatorsGroup.isEmpty()) {
            Node translatorsGroupNode = outputNode.addNode("vdb:translators", "vdb:translators");
            for (VdbTranslator translator : translatorsGroup) {
                Node translatorNode = translatorsGroupNode.addNode(translator.getName(), "vdb:translator");
                this.setProperty(translatorNode, "vdb:type", translator.getType());
                this.setProperty(translatorNode, "vdb:description", translator.getDescription());
                Map<String, String> props = translator.getProperties();
                if (props.isEmpty()) continue;
                for (Map.Entry<String, String> prop : props.entrySet()) {
                    this.setProperty(translatorNode, prop.getKey(), prop.getValue());
                }
            }
        }
    }

    private void setProperty(Node node, String name, String value) throws Exception {
        assert (node != null);
        assert (!StringUtil.isBlank((String)name));
        if (!StringUtil.isBlank((String)value)) {
            int index;
            String propName = name;
            if (propName.startsWith("{") && (index = propName.indexOf("}")) != -1) {
                boolean registered = false;
                String uri = propName.substring(1, index);
                for (String registeredUri : node.getSession().getWorkspace().getNamespaceRegistry().getURIs()) {
                    if (!registeredUri.equals(uri)) continue;
                    registered = true;
                    break;
                }
                if (!registered) {
                    NamespaceRegistry registry = node.getSession().getWorkspace().getNamespaceRegistry();
                    List<String> prefixes = Arrays.asList(registry.getPrefixes());
                    String[] segments = uri.split("/");
                    String prefix = segments[segments.length - 1];
                    int i = 1;
                    while (prefixes.contains(prefix)) {
                        prefix = prefix + i;
                    }
                    registry.registerNamespace(prefix, uri);
                }
            }
            node.setProperty(propName, value);
        }
    }
}

