/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.vdb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.teiid.modeshape.sequencer.vdb.TeiidI18n;
import org.teiid.modeshape.sequencer.vdb.VdbModel;
import org.teiid.modeshape.sequencer.vdb.model.CoreModelObjectHandler;
import org.teiid.modeshape.sequencer.vdb.model.DiagramModelObjectHandler;
import org.teiid.modeshape.sequencer.vdb.model.JdbcModelObjectHandler;
import org.teiid.modeshape.sequencer.vdb.model.ModelExtensionDefinitionHelper;
import org.teiid.modeshape.sequencer.vdb.model.ModelObjectHandler;
import org.teiid.modeshape.sequencer.vdb.model.ModelReader;
import org.teiid.modeshape.sequencer.vdb.model.ReferenceResolver;
import org.teiid.modeshape.sequencer.vdb.model.RelationalModelObjectHandler;
import org.teiid.modeshape.sequencer.vdb.model.TransformationModelObjectHandler;
import org.teiid.modeshape.sequencer.vdb.xmi.XmiElement;

public final class ModelNodeWriter {
    private static final Logger LOGGER = Logger.getLogger(ModelNodeWriter.class);
    private final Sequencer.Context context;
    private final Map<String, ModelObjectHandler> handlers = new HashMap<String, ModelObjectHandler>();
    private final Node outputNode;
    private final ModelReader reader;
    private final Map<String, Class<? extends ModelObjectHandler>> registry = new HashMap<String, Class<? extends ModelObjectHandler>>();
    private final ReferenceResolver resolver;
    private final VdbModel vdbModel;
    private final ModelExtensionDefinitionHelper medHelper;

    ModelNodeWriter(Node modelNode, ModelReader reader, ReferenceResolver resolver, VdbModel vdbModel, Sequencer.Context context) throws Exception {
        CheckArg.isNotNull((Object)modelNode, (String)"modelNode");
        CheckArg.isNotNull((Object)reader, (String)"reader");
        CheckArg.isNotNull((Object)resolver, (String)"resolver");
        CheckArg.isNotNull((Object)context, (String)"context");
        if (!modelNode.isNodeType("mmcore:model")) {
            throw new RuntimeException(TeiidI18n.invalidModelNodeType.text(new Object[]{modelNode.getPath()}));
        }
        this.outputNode = modelNode;
        this.resolver = resolver;
        this.reader = reader;
        this.vdbModel = vdbModel;
        this.context = context;
        this.medHelper = new ModelExtensionDefinitionHelper(this);
    }

    Sequencer.Context getContext() {
        return this.context;
    }

    Node getModelNode() {
        return this.outputNode;
    }

    ReferenceResolver getResolver() {
        return this.resolver;
    }

    ModelObjectHandler getHandler(String namespaceUri) throws Exception {
        CheckArg.isNotEmpty((String)namespaceUri, (String)"namespaceUri");
        ModelObjectHandler handler = this.handlers.get(namespaceUri);
        if (handler == null && this.registry.containsKey(namespaceUri)) {
            Class<? extends ModelObjectHandler> handlerClass = this.registry.get(namespaceUri);
            handler = handlerClass.newInstance();
            this.handlers.put(namespaceUri, handler);
            handler.setContext(this.context);
            handler.setReader(this.reader);
            handler.setResolver(this.resolver);
            handler.setVdbModel(this.vdbModel);
            handler.setModelExtensionDefinitionHelper(this.medHelper);
        }
        return handler;
    }

    public boolean isAcceptedPrimaryMetamodel(String uri) {
        return "http://www.metamatrix.com/metamodels/Relational".equals(uri);
    }

    private void loadRegistry() {
        this.registry.put("http://www.metamatrix.com/metamodels/Core", CoreModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/Diagram", DiagramModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/JDBC", JdbcModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/Relational", RelationalModelObjectHandler.class);
        this.registry.put("http://www.metamatrix.com/metamodels/Transformation", TransformationModelObjectHandler.class);
    }

    public boolean write() throws Exception {
        long startTime = System.currentTimeMillis();
        boolean result = true;
        String primaryMetamodelUri = this.reader.getPrimaryMetamodelUri();
        if (primaryMetamodelUri == null || !this.isAcceptedPrimaryMetamodel(primaryMetamodelUri)) {
            result = false;
        } else {
            this.loadRegistry();
            if (!this.writeModelObjects()) {
                result = false;
            } else {
                result = this.writeUnresolvedReferences();
                this.medHelper.assignModelNodeChildrenMedMixins(this.outputNode);
            }
        }
        LOGGER.debug("model write time={0}\n\n", new Object[]{System.currentTimeMillis() - startTime});
        return result;
    }

    private boolean writeModelObjects() throws Exception {
        LOGGER.debug("[begin writeModelObjects()]", new Object[0]);
        for (XmiElement element : this.reader.getElements()) {
            String nsUri = element.getNamespaceUri();
            ModelObjectHandler handler = this.getHandler(nsUri);
            if (handler == null) {
                LOGGER.debug("ModelObjectHandler for namespace {0} cannot be found", new Object[]{nsUri});
                continue;
            }
            handler.process(element, this.outputNode);
        }
        LOGGER.debug("[end writeModelObjects()]\n\n", new Object[0]);
        return true;
    }

    public boolean writeUnresolvedReferences() throws Exception {
        LOGGER.debug("[begin writeUnresolvedReferences()]", new Object[0]);
        ArrayList resolvedReferences = new ArrayList();
        for (Map.Entry<String, ReferenceResolver.UnresolvedReference> entry : this.resolver.getUnresolved().entrySet()) {
            int i;
            boolean multiValued;
            Node resolved = this.resolver.getNode(entry.getKey());
            if (resolved == null) {
                LOGGER.debug("**** uuid {0} is still unresolved during last phase of writing model", new Object[]{entry.getKey()});
                continue;
            }
            ReferenceResolver.UnresolvedReference unresolved = entry.getValue();
            ValueFactory valueFactory = resolved.getSession().getValueFactory();
            for (String mixin : unresolved.getMixins()) {
                resolved.addMixin(mixin);
                LOGGER.debug("adding mixin {0} to resolved node {1}", new Object[]{mixin, resolved.getName()});
            }
            for (String propName : unresolved.getProperties().keySet()) {
                ReferenceResolver.UnresolvedProperty property = unresolved.getProperties().get(propName);
                assert (property != null);
                multiValued = property.isMulti();
                if (multiValued) {
                    Value[] propertyValues = new Value[property.getValues().size()];
                    i = 0;
                    for (String value : property.getValues()) {
                        propertyValues[i++] = valueFactory.createValue(value);
                    }
                    continue;
                }
                String mappedName = this.medHelper.getMappedPropertyName(propName);
                resolved.setProperty(mappedName, property.getValue());
                LOGGER.debug("setting property '{0}' with value '{1}' to resolved node {2}", new Object[]{propName, property.getValue(), resolved.getName()});
            }
            for (String propertyName : unresolved.getReferences().keySet()) {
                Collection refs = unresolved.getReferences().get((Object)propertyName);
                if (refs == null || refs.isEmpty()) continue;
                multiValued = false;
                if (resolved.hasProperty(propertyName)) {
                    multiValued = resolved.getProperty(propertyName).isMultiple();
                    if (multiValued) {
                        Value[] values = new Value[refs.size()];
                        i = 0;
                        for (String value : refs) {
                            Node referencedNode = this.resolver.getNode(value);
                            if (referencedNode == null) {
                                this.resolver.addUnresolvedReference(value);
                                continue;
                            }
                            values[i++] = valueFactory.createValue(referencedNode, true);
                        }
                        resolved.setProperty(propertyName, values);
                        continue;
                    }
                    resolved.setProperty(propertyName, (String)refs.iterator().next());
                    continue;
                }
                LOGGER.debug("**** resolved property does not have property '{0}'. The value has {1}  reference(s) and first reference is '{2}'", new Object[]{propertyName, refs.size(), refs.iterator().next()});
            }
            for (String propertyName : unresolved.getReferenceNames().keySet()) {
                Collection referencerUuids = unresolved.getReferenceNames().get((Object)propertyName);
                if (referencerUuids == null || referencerUuids.isEmpty()) continue;
                for (String uuid : referencerUuids) {
                    Node referencerNode = this.resolver.getNode(uuid);
                    if (referencerNode == null) {
                        ReferenceResolver.UnresolvedReference unresolvedReferencer = this.resolver.addUnresolvedReference(uuid);
                        unresolvedReferencer.addProperty(propertyName, resolved.getName(), true);
                        continue;
                    }
                    referencerNode.setProperty(propertyName, new Value[]{this.context.valueFactory().createValue(resolved.getName())});
                }
            }
            Multimap<String, String> refRefs = unresolved.getReferencerReferences();
            for (String propertyName : refRefs.keySet()) {
                if (!resolved.isNodeType("mix:referenceable")) {
                    resolved.addMixin("mix:referenceable");
                }
                Value weakRef = valueFactory.createValue(resolved, true);
                for (String referencerUuuid : refRefs.get((Object)propertyName)) {
                    Node referencer = this.resolver.getNode(referencerUuuid);
                    if (referencer == null) {
                        ReferenceResolver.UnresolvedReference unresolvedReferencer = this.resolver.addUnresolvedReference(referencerUuuid);
                        unresolvedReferencer.addReference(propertyName, entry.getKey());
                        continue;
                    }
                    if (referencer.hasProperty(propertyName)) {
                        Property prop = referencer.getProperty(propertyName);
                        if (prop.isMultiple()) {
                            Value[] currentValues = prop.getValues();
                            Value[] newValues = new Value[currentValues.length + 1];
                            System.arraycopy(currentValues, 0, newValues, 0, currentValues.length);
                            newValues[currentValues.length] = weakRef;
                            referencer.setProperty(propertyName, newValues);
                            continue;
                        }
                        referencer.setProperty(propertyName, weakRef);
                        continue;
                    }
                    LOGGER.debug("**** weak reference property could be multi-value here", new Object[0]);
                }
            }
        }
        if (!resolvedReferences.isEmpty()) {
            for (ReferenceResolver.UnresolvedReference unresolved : resolvedReferences) {
                this.resolver.resolved(unresolved);
            }
        }
        LOGGER.debug("number unresolved at end={0}\n[end writeUnresolvedReferences()]\n\n", new Object[]{this.resolver.getUnresolved().size()});
        return true;
    }
}

