/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.vdb.model;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.teiid.modeshape.sequencer.vdb.VdbModel;
import org.teiid.modeshape.sequencer.vdb.model.ModelExtensionDefinitionHelper;
import org.teiid.modeshape.sequencer.vdb.model.ModelReader;
import org.teiid.modeshape.sequencer.vdb.model.ReferenceResolver;
import org.teiid.modeshape.sequencer.vdb.xmi.XmiAttribute;
import org.teiid.modeshape.sequencer.vdb.xmi.XmiElement;
import org.teiid.modeshape.sequencer.vdb.xmi.XmiPart;

public abstract class ModelObjectHandler {
    protected static final Logger LOGGER = Logger.getLogger(ModelObjectHandler.class);
    private Sequencer.Context context;
    private ModelReader reader;
    private ReferenceResolver resolver;
    private VdbModel vdbModel;
    private ModelExtensionDefinitionHelper medHelper;

    protected Node addNode(Node parentNode, String nodeName, String xmiUuid, String primaryNodeType) throws Exception {
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        CheckArg.isNotEmpty((String)nodeName, (String)"nodeName");
        CheckArg.isNotEmpty((String)primaryNodeType, (String)"primaryNodeType");
        Node newNode = parentNode.addNode(nodeName, primaryNodeType);
        if (!StringUtil.isBlank((String)xmiUuid)) {
            this.setProperty(newNode, "xmi:uuid", xmiUuid);
            this.resolver.record(xmiUuid, newNode);
        }
        LOGGER.debug("adding node {0} to parent {1}", new Object[]{newNode.getName(), parentNode.getName()});
        return newNode;
    }

    protected Node addNode(Node parentNode, XmiElement element, String nameAttributeUri, String primaryNodeType) throws Exception {
        XmiAttribute nameAttribute;
        CheckArg.isNotNull((Object)parentNode, (String)"parentNode");
        CheckArg.isNotEmpty((String)primaryNodeType, (String)"primaryNodeType");
        String name = null;
        name = StringUtil.isBlank((String)nameAttributeUri) || element == null ? primaryNodeType : ((nameAttribute = element.getNameAttribute(nameAttributeUri)) == null ? primaryNodeType : nameAttribute.getValue());
        String uuid = element == null ? null : element.getUuid();
        return this.addNode(parentNode, name, uuid, primaryNodeType);
    }

    protected void addPropertyValue(Node node, String propertyName, String newValue) throws Exception {
        CheckArg.isNotEmpty((String)newValue, (String)"newValue");
        this.addPropertyValue(node, propertyName, this.context.valueFactory().createValue(newValue));
    }

    protected void addPropertyValue(Node node, String propertyName, Value newValue) throws Exception {
        CheckArg.isNotNull((Object)node, (String)"node");
        CheckArg.isNotEmpty((String)propertyName, (String)"propertyName");
        CheckArg.isNotNull((Object)newValue, (String)"newValue");
        if (node.hasProperty(propertyName)) {
            Property property = node.getProperty(propertyName);
            Value[] currentValues = property.getValues();
            Value[] newValues = new Value[currentValues.length + 1];
            System.arraycopy(currentValues, 0, newValues, 0, currentValues.length);
            newValues[currentValues.length] = newValue;
            node.setProperty(propertyName, newValues);
        } else {
            node.setProperty(propertyName, new Value[]{newValue});
        }
        LOGGER.debug("added a value of '{0}' to multi-valued property '{1}' in node '{2}'", new Object[]{newValue, propertyName, node.getName()});
    }

    protected Sequencer.Context getContext() {
        return this.context;
    }

    protected ModelExtensionDefinitionHelper getMedHelper() {
        return this.medHelper;
    }

    protected String getQName(XmiPart xmiPart) {
        CheckArg.isNotNull((Object)xmiPart, (String)"xmiPart");
        return xmiPart.getQName();
    }

    protected ModelReader getReader() {
        return this.reader;
    }

    protected ReferenceResolver getResolver() {
        return this.resolver;
    }

    protected VdbModel getVdbModel() {
        return this.vdbModel;
    }

    protected abstract void process(XmiElement var1, Node var2) throws Exception;

    protected void setBooleanProperty(Node node, String jcrPropertyName, String value) throws Exception {
        CheckArg.isNotNull((Object)node, (String)"node");
        CheckArg.isNotEmpty((String)jcrPropertyName, (String)"jcrPropertyName");
        if (!StringUtil.isBlank((String)value)) {
            node.setProperty(jcrPropertyName, Boolean.parseBoolean(value));
        }
    }

    protected void setContext(Sequencer.Context context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        this.context = context;
    }

    void setModelExtensionDefinitionHelper(ModelExtensionDefinitionHelper medHelper) {
        this.medHelper = medHelper;
    }

    protected void setProperty(Node node, String propertyName, String propertyValue) throws Exception {
        CheckArg.isNotNull((Object)node, (String)"node");
        CheckArg.isNotEmpty((String)propertyName, (String)"propertyName");
        if (!StringUtil.isBlank((String)propertyValue)) {
            if (this.resolver.isReference(propertyValue)) {
                String refUuid = this.resolver.resolveInternalReference(propertyValue);
                Node refNode = this.resolver.getNode(refUuid);
                if (refNode == null) {
                    ReferenceResolver.UnresolvedReference unresolved = this.resolver.addUnresolvedReference(refUuid);
                    unresolved.addReferencerReference(node.getProperty("xmi:uuid").getString(), propertyName);
                } else {
                    if (!refNode.isNodeType("mix:referenceable")) {
                        refNode.addMixin("mix:referenceable");
                    }
                    Value weakReference = node.getSession().getValueFactory().createValue(refNode, true);
                    node.setProperty(propertyName, weakReference);
                }
            } else {
                node.setProperty(propertyName, propertyValue);
                LOGGER.debug("{0}:setting {1} = {2}", new Object[]{node.getName(), propertyName, propertyValue});
            }
        }
    }

    protected void setReader(ModelReader reader) {
        CheckArg.isNotNull((Object)reader, (String)"reader");
        this.reader = reader;
    }

    protected void setResolver(ReferenceResolver resolver) {
        CheckArg.isNotNull((Object)resolver, (String)"resolver");
        this.resolver = resolver;
    }

    protected void setVdbModel(VdbModel vdbModel) {
        this.vdbModel = vdbModel;
    }
}

