/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.vdb.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.teiid.modeshape.sequencer.vdb.TeiidI18n;
import org.teiid.modeshape.sequencer.vdb.VdbModel;
import org.teiid.modeshape.sequencer.vdb.VdbSequencer;
import org.teiid.modeshape.sequencer.vdb.model.ModelNodeWriter;
import org.teiid.modeshape.sequencer.vdb.model.ModelReader;
import org.teiid.modeshape.sequencer.vdb.model.ReferenceResolver;

@ThreadSafe
public class ModelSequencer
extends Sequencer {
    private static final String[] MODEL_FILE_EXTENSIONS = new String[]{".xmi"};
    private static final Logger LOGGER = Logger.getLogger(ModelSequencer.class);

    public static boolean shouldSequence(ModelReader modelReader) {
        assert (modelReader != null);
        String modelType = modelReader.getModelType();
        boolean validModelType = "PHYSICAL".equalsIgnoreCase(modelType) || "VIRTUAL".equalsIgnoreCase(modelType);
        return validModelType && "http://www.metamatrix.com/metamodels/Relational".equals(modelReader.getPrimaryMetamodelUri());
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        outputNode.addMixin("mmcore:model");
        try (InputStream modelStream = binaryValue.getStream();){
            boolean bl = this.sequenceModel(modelStream, outputNode, outputNode.getPath(), null, new ReferenceResolver(), context);
            return bl;
        }
    }

    public boolean hasModelFileExtension(String resourceName) {
        for (String extension : MODEL_FILE_EXTENSIONS) {
            if (!resourceName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        LOGGER.debug("enter initialize", new Object[0]);
        Class<VdbSequencer> vdbSeqClass = VdbSequencer.class;
        this.registerNodeTypes(vdbSeqClass, "xmi", nodeTypeManager);
        this.registerNodeTypes(vdbSeqClass, "med", nodeTypeManager);
        this.registerNodeTypes(vdbSeqClass, "mmcore", nodeTypeManager);
        this.registerNodeTypes(vdbSeqClass, "jdbc", nodeTypeManager);
        this.registerNodeTypes(vdbSeqClass, "relational", nodeTypeManager);
        this.registerNodeTypes(vdbSeqClass, "transformation", nodeTypeManager);
        this.registerNamespace("diagram", "http://www.metamatrix.com/metamodels/Diagram", registry);
        LOGGER.debug("exit initialize", new Object[0]);
    }

    private void registerNodeTypes(Class<?> vdbSeqClass, String cndFileName, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        URL url = vdbSeqClass.getResource("/org/teiid/modeshape/sequencer/vdb/" + cndFileName + ".cnd");
        this.registerNodeTypes(url.openStream(), nodeTypeManager, true);
        LOGGER.debug(cndFileName + "CND loaded", new Object[0]);
    }

    private boolean sequenceModel(InputStream modelStream, Node modelOutputNode, String modelPath, VdbModel vdbModel, ReferenceResolver resolver, Sequencer.Context context) throws Exception {
        assert (modelStream != null);
        assert (modelOutputNode != null);
        assert (context != null);
        assert (modelOutputNode.isNodeType("mmcore:model"));
        LOGGER.debug("sequenceModel:model node path='{0}', model path='{1}', vdb model='{2}'", new Object[]{modelOutputNode.getPath(), modelPath, vdbModel});
        NamespaceRegistry registry = modelOutputNode.getSession().getWorkspace().getNamespaceRegistry();
        ModelReader modelReader = new ModelReader(modelPath, resolver, registry);
        modelReader.readModel(modelStream);
        if (ModelSequencer.shouldSequence(modelReader)) {
            ModelNodeWriter nodeWriter = new ModelNodeWriter(modelOutputNode, modelReader, resolver, vdbModel, context);
            return nodeWriter.write();
        }
        LOGGER.debug("sequenceModel:model not sequenced at path '{0}'", new Object[]{modelPath});
        return false;
    }

    public boolean sequenceVdbModel(InputStream modelStream, Node modelOutputNode, VdbModel vdbModel, ReferenceResolver resolver, Sequencer.Context context) throws Exception {
        CheckArg.isNotNull((Object)modelStream, (String)"modelStream");
        CheckArg.isNotNull((Object)modelOutputNode, (String)"modelOutputNode");
        CheckArg.isNotNull((Object)vdbModel, (String)"vdbModel");
        if (!modelOutputNode.isNodeType("vdb:model")) {
            throw new RuntimeException(TeiidI18n.invalidVdbModelNodeType.text(new Object[]{modelOutputNode.getPath()}));
        }
        return this.sequenceModel(modelStream, modelOutputNode, vdbModel.getPathInVdb(), vdbModel, resolver, context);
    }
}

