/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.vdb.xmi;

import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.StringUtil;
import org.teiid.modeshape.sequencer.vdb.xmi.XmiPart;

public abstract class XmiBasePart
implements XmiPart {
    private final String name;
    private String namespacePrefix;
    private String namespaceUri;
    private String value;

    protected XmiBasePart(String name) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XmiBasePart)) {
            return false;
        }
        XmiBasePart that = (XmiBasePart)obj;
        if (this == that) {
            return true;
        }
        if (StringUtil.isBlank((String)this.name) ? !StringUtil.isBlank((String)that.name) : !this.name.equals(that.name)) {
            return false;
        }
        if (StringUtil.isBlank((String)this.namespaceUri) ? !StringUtil.isBlank((String)that.namespaceUri) : !this.namespaceUri.equals(that.namespaceUri)) {
            return false;
        }
        if (StringUtil.isBlank((String)this.namespacePrefix) ? !StringUtil.isBlank((String)that.namespacePrefix) : !this.namespacePrefix.equals(that.namespacePrefix)) {
            return false;
        }
        return !(StringUtil.isBlank((String)this.value) ? !StringUtil.isBlank((String)that.value) : !this.value.equals(that.value));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public String getQName() {
        if (StringUtil.isBlank((String)this.getNamespacePrefix())) {
            return this.getName();
        }
        return this.getNamespacePrefix() + ':' + this.getName();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.name, this.namespacePrefix, this.namespaceUri, this.value});
    }

    public void setNamespacePrefix(String newNamespacePrefix) {
        this.namespacePrefix = newNamespacePrefix;
    }

    public void setNamespaceUri(String newNamespaceUri) {
        this.namespaceUri = newNamespaceUri;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String toString() {
        return this.getQName() + '=' + this.getValue();
    }
}

