/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.vdb;

import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.teiid.modeshape.sequencer.Options;
import org.teiid.modeshape.sequencer.internal.AbstractExporter;
import org.teiid.modeshape.sequencer.vdb.ImportVdb;
import org.teiid.modeshape.sequencer.vdb.VdbDataRole;
import org.teiid.modeshape.sequencer.vdb.VdbEntry;
import org.teiid.modeshape.sequencer.vdb.VdbManifest;
import org.teiid.modeshape.sequencer.vdb.VdbModel;
import org.teiid.modeshape.sequencer.vdb.VdbTranslator;

public class VdbExporter
extends AbstractExporter {
    private static final String FIND_CHILD_BY_NAME_AND_TYPE = "SELECT [jcr:path] FROM ['%s'] WHERE ISCHILDNODE('%s') AND [jcr:name] = '%s' LIMIT 1";
    private static final String FIND_CHILD_WITH_TYPE = "SELECT [jcr:path] FROM ['%s'] WHERE ISCHILDNODE('%s')";
    private static final Logger LOGGER = Logger.getLogger(VdbExporter.class);

    private VdbManifest constructManifest(Node vdb, Options options) throws Exception {
        Node[] children;
        Node[] entryNodes;
        Node[] dataRoleNodes;
        String description;
        Node[] translatorNodes;
        Node groupingNode;
        Property property;
        PropertyIterator itr;
        Options.PropertyFilter filter;
        Value[] props;
        VdbManifest manifest = null;
        String name = null;
        name = vdb.hasProperty("vdb:name") ? vdb.getProperty("vdb:name").getString() : vdb.getName();
        manifest = new VdbManifest(name);
        if (vdb.hasProperty("vdb:description")) {
            manifest.setDescription(vdb.getProperty("vdb:description").getString());
        }
        if (vdb.hasProperty("vdb:version")) {
            manifest.setVersion((int)vdb.getProperty("vdb:version").getLong());
        }
        if (vdb.hasProperty("vdb:connectionType")) {
            manifest.setConnectionType(vdb.getProperty("vdb:connectionType").getString());
        }
        Map<String, String> props2 = manifest.getProperties();
        Options.PropertyFilter filter2 = this.getPropertyFilter(options);
        Node[] itr2 = vdb.getProperties();
        while (itr2.hasNext()) {
            Property property2 = itr2.nextProperty();
            String propName = property2.getName();
            if (!filter2.accept(propName)) continue;
            String name2 = propName;
            int index = name2.indexOf(58);
            if (index != -1) {
                String uri = vdb.getSession().getNamespaceURI(name2.substring(0, index));
                name2 = '{' + uri + '}' + name2.substring(index + 1);
            }
            props2.put(name2, property2.getValue().getString());
        }
        Node[] modelNodes = this.findChildrenWithType(vdb, "vdb:declarativeModel");
        if (modelNodes.length != 0) {
            List<VdbModel> models = manifest.getModels();
            for (Node modelNode : modelNodes) {
                Property sourceNodes;
                Node groupingNode2;
                String type = modelNode.getProperty("mmcore:modelType").getString();
                String pathInVdb = null;
                if (modelNode.hasProperty("vdb:pathInVdb")) {
                    pathInVdb = modelNode.getProperty("vdb:pathInVdb").getString();
                }
                VdbModel model = new VdbModel(modelNode.getName(), type, pathInVdb);
                if (modelNode.hasProperty("vdb:visible")) {
                    model.setVisible(modelNode.getProperty("vdb:visible").getBoolean());
                }
                if (modelNode.hasProperty("vdb:description")) {
                    model.setDescription(modelNode.getProperty("vdb:description").getString());
                }
                props = model.getProperties();
                filter = this.getPropertyFilter(options);
                itr = modelNode.getProperties();
                while (itr.hasNext()) {
                    property = itr.nextProperty();
                    if (!filter.accept(property.getName())) continue;
                    props.put((String)property.getName(), (String)property.getValue().getString());
                }
                if (modelNode.hasProperty("vdb:metadataType")) {
                    model.setMetadataType(modelNode.getProperty("vdb:metadataType").getString());
                }
                if (modelNode.hasProperty("vdb:modelDefinition")) {
                    model.setModelDefinition(modelNode.getProperty("vdb:modelDefinition").getString());
                }
                if (modelNode.hasProperty("vdb:ddlFileEntryPath")) {
                    model.setDdlFileEntryPath(modelNode.getProperty("vdb:ddlFileEntryPath").getString());
                }
                if ((groupingNode2 = this.findNodeByNameAndType(modelNode, "vdb:sources", "vdb:sources")) != null && ((Node[])(sourceNodes = this.findChildrenWithType(groupingNode2, "vdb:source"))).length != 0) {
                    List<VdbModel.Source> sources = model.getSources();
                    for (Node sourceNode : sourceNodes) {
                        String connName;
                        String translator = sourceNode.getProperty("vdb:sourceTranslator").getString();
                        VdbModel vdbModel = model;
                        vdbModel.getClass();
                        VdbModel.Source source = vdbModel.new VdbModel.Source(sourceNode.getName(), translator);
                        if (sourceNode.hasProperty("vdb:sourceJndiName")) {
                            String jndiName = sourceNode.getProperty("vdb:sourceJndiName").getString();
                            source.setJndiName(jndiName);
                        }
                        if (sourceNode.hasProperty("vdb:originConnection") && (connName = sourceNode.getProperty("vdb:originConnection").getString()) != null) {
                            model.getProperties().put(VdbModel.createOriginConnectionPropertyName(source.getName()), connName);
                        }
                        sources.add(source);
                        LOGGER.debug("Added source {0} to model {1}", new Object[]{source.getName(), model.getName()});
                    }
                }
                models.add(model);
                LOGGER.debug("Added model {0} to manifest", new Object[]{model.getName()});
            }
        }
        if ((groupingNode = this.findNodeByNameAndType(vdb, "vdb:translators", "vdb:translators")) != null && (translatorNodes = this.findChildrenWithType(groupingNode, "vdb:translator")).length != 0) {
            List<VdbTranslator> translators = manifest.getTranslators();
            for (Node translatorNode : translatorNodes) {
                String type = translatorNode.getProperty("vdb:type").getString();
                VdbTranslator translator = new VdbTranslator(translatorNode.getName(), type);
                if (translatorNode.hasProperty("vdb:description")) {
                    description = translatorNode.getProperty("vdb:description").getString();
                    translator.setDescription(description);
                }
                props = translator.getProperties();
                filter = this.getPropertyFilter(options);
                itr = translatorNode.getProperties();
                while (itr.hasNext()) {
                    property = itr.nextProperty();
                    if (!filter.accept(property.getName())) continue;
                    props.put((String)property.getName(), (String)property.getValue().getString());
                }
                translators.add(translator);
                LOGGER.debug("Added translator {0} to manifest", new Object[]{translator.getName()});
            }
        }
        if ((groupingNode = this.findNodeByNameAndType(vdb, "vdb:dataRoles", "vdb:dataRoles")) != null && (dataRoleNodes = this.findChildrenWithType(groupingNode, "vdb:dataRole")).length != 0) {
            List<VdbDataRole> dataRoles = manifest.getDataRoles();
            for (Node dataRoleNode : dataRoleNodes) {
                Node[] permissionNodes;
                Node permissionsGroupingNode;
                VdbDataRole dataRole = new VdbDataRole(dataRoleNode.getName());
                if (dataRoleNode.hasProperty("vdb:description")) {
                    String description2 = dataRoleNode.getProperty("vdb:description").getString();
                    dataRole.setDescription(description2);
                }
                dataRole.setAnyAuthenticated(dataRoleNode.getProperty("vdb:anyAuthenticated").getBoolean());
                dataRole.setAllowCreateTempTables(dataRoleNode.getProperty("vdb:allowCreateTemporaryTables").getBoolean());
                dataRole.setGrantAll(dataRoleNode.getProperty("vdb:grantAll").getBoolean());
                if (dataRoleNode.hasProperty("vdb:mappedRoleNames")) {
                    List<String> mappedRoles = dataRole.getMappedRoleNames();
                    for (Value value : dataRoleNode.getProperty("vdb:mappedRoleNames").getValues()) {
                        String mappedRole = value.getString();
                        mappedRoles.add(mappedRole);
                        LOGGER.debug("Added mapped role {0} to data role {1}", new Object[]{mappedRole, dataRole.getName()});
                    }
                }
                if ((permissionsGroupingNode = this.findNodeByNameAndType(dataRoleNode, "vdb:permissions", "vdb:permissions")) != null && (permissionNodes = this.findChildrenWithType(permissionsGroupingNode, "vdb:permission")).length != 0) {
                    List<VdbDataRole.Permission> permissions = dataRole.getPermissions();
                    for (Node permissionNode : permissionNodes) {
                        Node[] maskNodes;
                        VdbDataRole vdbDataRole = dataRole;
                        vdbDataRole.getClass();
                        VdbDataRole.Permission permission = new VdbDataRole.Permission(vdbDataRole, dataRoleNode.getName());
                        permission.allowAlter(permissionNode.getProperty("vdb:allowAlter").getBoolean());
                        permission.allowCreate(permissionNode.getProperty("vdb:allowCreate").getBoolean());
                        permission.allowDelete(permissionNode.getProperty("vdb:allowDelete").getBoolean());
                        permission.allowExecute(permissionNode.getProperty("vdb:allowExecute").getBoolean());
                        permission.allowLanguage(permissionNode.getProperty("vdb:allowLanguage").getBoolean());
                        permission.allowRead(permissionNode.getProperty("vdb:allowRead").getBoolean());
                        permission.allowUpdate(permissionNode.getProperty("vdb:allowUpdate").getBoolean());
                        Node[] conditionNodes = this.findChildrenWithType(permissionNode, "vdb:condition");
                        if (conditionNodes.length != 0) {
                            List<VdbDataRole.Condition> conditions = permission.getConditions();
                            for (Node conditionNode : conditionNodes) {
                                VdbDataRole.Condition condition = new VdbDataRole.Condition(dataRole);
                                condition.setConstraint(conditionNode.getProperty("vdb:constraint").getBoolean());
                                condition.setRule(conditionNode.getName());
                                conditions.add(condition);
                                LOGGER.debug("Added condition {0} to permission {1}", new Object[]{condition.getRule(), permission.getResourceName()});
                            }
                        }
                        if ((maskNodes = this.findChildrenWithType(permissionNode, "vdb:mask")).length != 0) {
                            List<VdbDataRole.Mask> masks = permission.getMasks();
                            for (Node maskNode : maskNodes) {
                                VdbDataRole.Mask mask = new VdbDataRole.Mask(dataRole);
                                mask.setOrder((int)maskNode.getProperty("vdb:order").getLong());
                                mask.setRule(maskNode.getName());
                                masks.add(mask);
                                LOGGER.debug("Added mask {0} to permission {1}", new Object[]{mask.getRule(), permission.getResourceName()});
                            }
                        }
                        permissions.add(permission);
                        LOGGER.debug("Added permission {0} to data role {1}", new Object[]{permission.getResourceName(), dataRole.getName()});
                    }
                }
                dataRoles.add(dataRole);
                LOGGER.debug("Added data role {0} to manifest", new Object[]{dataRole.getName()});
            }
        }
        if ((groupingNode = this.findNodeByNameAndType(vdb, "vdb:entries", "vdb:entries")) != null && (entryNodes = this.findChildrenWithType(groupingNode, "vdb:entry")).length != 0) {
            List<VdbEntry> entries = manifest.getEntries();
            for (Node entryNode : entryNodes) {
                String path = entryNode.getProperty("vdb:path").getString();
                VdbEntry entry = new VdbEntry(path);
                if (entryNode.hasProperty("vdb:description")) {
                    description = entryNode.getProperty("vdb:description").getString();
                    entry.setDescription(description);
                }
                props = entry.getProperties();
                Options.PropertyFilter filter3 = this.getPropertyFilter(options);
                PropertyIterator itr3 = entryNode.getProperties();
                while (itr3.hasNext()) {
                    Property property3 = itr3.nextProperty();
                    if (!filter3.accept(property3.getName())) continue;
                    props.put(property3.getName(), property3.getValue().getString());
                }
                entries.add(entry);
                LOGGER.debug("Added entry with path {0} to manifest", new Object[]{entry.getPath()});
            }
        }
        if ((groupingNode = this.findNodeByNameAndType(vdb, "vdb:importVdbs", "vdb:importVdbs")) != null && (children = this.findChildrenWithType(groupingNode, "vdb:importVdb")).length != 0) {
            List<ImportVdb> importVdbs = manifest.getImportVdbs();
            for (Node node : children) {
                int version = Integer.parseInt(node.getProperty("vdb:version").getString());
                ImportVdb importVdb = new ImportVdb(node.getName(), version);
                boolean importDataPolicies = node.getProperty("vdb:importDataPolicies").getBoolean();
                importVdb.setImportDataPolicies(importDataPolicies);
                importVdbs.add(importVdb);
                LOGGER.debug("Added import VDB {0} to manifest", new Object[]{importVdb.getName()});
            }
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExport(Node vdbNode, Options options, AbstractExporter.ResultImpl result) {
        XMLStreamWriter xmlWriter = null;
        try {
            List<VdbEntry> entries;
            List<VdbDataRole> dataRoles;
            List<VdbTranslator> translators;
            Map<String, String> props;
            List<VdbModel> models;
            List<ImportVdb> imports;
            Map<String, String> props2;
            VdbManifest manifest = this.constructManifest(vdbNode, options);
            StringWriter stringWriter = new StringWriter();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            xmlWriter = xof.createXMLStreamWriter(stringWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("vdb");
            xmlWriter.writeAttribute("name", manifest.getName());
            xmlWriter.writeAttribute("version", Integer.toString(manifest.getVersion()));
            if (!StringUtil.isBlank((String)manifest.getDescription())) {
                xmlWriter.writeStartElement("description");
                xmlWriter.writeCharacters(manifest.getDescription());
                xmlWriter.writeEndElement();
            }
            if (!StringUtil.isBlank((String)manifest.getConnectionType())) {
                xmlWriter.writeStartElement("connection-type");
                xmlWriter.writeCharacters(manifest.getConnectionType());
                xmlWriter.writeEndElement();
            }
            if (!(props2 = manifest.getProperties()).isEmpty()) {
                for (Map.Entry<String, String> property : props2.entrySet()) {
                    this.writePropertyElement(xmlWriter, property.getKey(), property.getValue());
                }
            }
            if (!(imports = manifest.getImportVdbs()).isEmpty()) {
                for (ImportVdb importVdb : imports) {
                    xmlWriter.writeStartElement("import-vdb");
                    xmlWriter.writeAttribute("import-data-policies", Boolean.toString(importVdb.isImportDataPolicies()));
                    xmlWriter.writeAttribute("name", importVdb.getName());
                    xmlWriter.writeAttribute("version", Integer.toString(importVdb.getVersion()));
                    xmlWriter.writeEndElement();
                }
            }
            if (!(models = manifest.getModels()).isEmpty()) {
                for (VdbModel model : models) {
                    List<VdbModel.ValidationMarker> markers;
                    List<VdbModel.Source> sources;
                    xmlWriter.writeStartElement("model");
                    xmlWriter.writeAttribute("name", model.getName());
                    if (model.getType() != null && !model.getType().equals("PHYSICAL")) {
                        xmlWriter.writeAttribute("type", model.getType());
                    }
                    if (!model.isVisible()) {
                        xmlWriter.writeAttribute("visible", Boolean.toString(model.isVisible()));
                    }
                    if (!StringUtil.isBlank((String)model.getPathInVdb())) {
                        xmlWriter.writeAttribute("path", model.getPathInVdb());
                    }
                    if (!StringUtil.isBlank((String)model.getDescription())) {
                        xmlWriter.writeStartElement("description");
                        xmlWriter.writeCharacters(model.getDescription());
                        xmlWriter.writeEndElement();
                    }
                    if (!(props = model.getProperties()).isEmpty()) {
                        for (Map.Entry<String, String> entry : props.entrySet()) {
                            this.writePropertyElement(xmlWriter, entry.getKey(), entry.getValue());
                        }
                    }
                    if (!StringUtil.isBlank((String)model.getModelDefinition())) {
                        xmlWriter.writeStartElement("metadata");
                        if (!StringUtil.isBlank((String)model.getMetadataType())) {
                            xmlWriter.writeAttribute("type", model.getMetadataType());
                        }
                        xmlWriter.writeCData(model.getModelDefinition());
                        xmlWriter.writeEndElement();
                    }
                    if (!(sources = model.getSources()).isEmpty()) {
                        for (VdbModel.Source source : sources) {
                            xmlWriter.writeStartElement("source");
                            xmlWriter.writeAttribute("name", source.getName());
                            xmlWriter.writeAttribute("translator-name", source.getTranslator());
                            if (!StringUtil.isBlank((String)source.getJndiName())) {
                                xmlWriter.writeAttribute("connection-jndi-name", source.getJndiName());
                            }
                            xmlWriter.writeEndElement();
                        }
                    }
                    if (!(markers = model.getProblems()).isEmpty()) {
                        for (VdbModel.ValidationMarker validationMarker : markers) {
                            xmlWriter.writeStartElement("validation-error");
                            xmlWriter.writeAttribute("severity", validationMarker.getSeverity().name());
                            if (!StringUtil.isBlank((String)validationMarker.getPath())) {
                                xmlWriter.writeAttribute("path", validationMarker.getPath());
                            }
                            xmlWriter.writeCharacters(validationMarker.getMessage());
                            xmlWriter.writeEndElement();
                        }
                    }
                    xmlWriter.writeEndElement();
                }
            }
            if (!(translators = manifest.getTranslators()).isEmpty()) {
                for (VdbTranslator translator : translators) {
                    xmlWriter.writeStartElement("translator");
                    xmlWriter.writeAttribute("name", translator.getName());
                    xmlWriter.writeAttribute("type", translator.getType());
                    if (!StringUtil.isBlank((String)translator.getDescription())) {
                        xmlWriter.writeAttribute("description", translator.getDescription());
                    }
                    if (!(props = translator.getProperties()).isEmpty()) {
                        for (Map.Entry<String, String> entry : props.entrySet()) {
                            this.writePropertyElement(xmlWriter, entry.getKey(), entry.getValue());
                        }
                    }
                    xmlWriter.writeEndElement();
                }
            }
            if (!(dataRoles = manifest.getDataRoles()).isEmpty()) {
                for (VdbDataRole dataRole : dataRoles) {
                    List<String> mappedRoles;
                    List<VdbDataRole.Permission> permissions;
                    xmlWriter.writeStartElement("data-role");
                    xmlWriter.writeAttribute("name", dataRole.getName());
                    xmlWriter.writeAttribute("any-authenticated", Boolean.toString(dataRole.isAnyAuthenticated()));
                    xmlWriter.writeAttribute("allow-create-temporary-tables", Boolean.toString(dataRole.isAllowCreateTempTables()));
                    xmlWriter.writeAttribute("grant-all", Boolean.toString(dataRole.isGrantAll()));
                    if (!StringUtil.isBlank((String)dataRole.getDescription())) {
                        xmlWriter.writeStartElement("description");
                        xmlWriter.writeCharacters(dataRole.getDescription());
                        xmlWriter.writeEndElement();
                    }
                    if (!(permissions = dataRole.getPermissions()).isEmpty()) {
                        for (VdbDataRole.Permission permission : permissions) {
                            List<VdbDataRole.Mask> masks;
                            xmlWriter.writeStartElement("permission");
                            xmlWriter.writeStartElement("resource-name");
                            xmlWriter.writeCharacters(permission.getResourceName());
                            xmlWriter.writeEndElement();
                            xmlWriter.writeStartElement("allow-create");
                            xmlWriter.writeCharacters(Boolean.toString(permission.canCreate()));
                            xmlWriter.writeEndElement();
                            xmlWriter.writeStartElement("allow-read");
                            xmlWriter.writeCharacters(Boolean.toString(permission.canRead()));
                            xmlWriter.writeEndElement();
                            xmlWriter.writeStartElement("allow-update");
                            xmlWriter.writeCharacters(Boolean.toString(permission.canUpdate()));
                            xmlWriter.writeEndElement();
                            xmlWriter.writeStartElement("allow-delete");
                            xmlWriter.writeCharacters(Boolean.toString(permission.canDelete()));
                            xmlWriter.writeEndElement();
                            xmlWriter.writeStartElement("allow-execute");
                            xmlWriter.writeCharacters(Boolean.toString(permission.canExecute()));
                            xmlWriter.writeEndElement();
                            xmlWriter.writeStartElement("allow-alter");
                            xmlWriter.writeCharacters(Boolean.toString(permission.canAlter()));
                            xmlWriter.writeEndElement();
                            List<VdbDataRole.Condition> conditions = permission.getConditions();
                            if (!conditions.isEmpty()) {
                                for (VdbDataRole.Condition condition : conditions) {
                                    xmlWriter.writeStartElement("condition");
                                    xmlWriter.writeAttribute("constraint", Boolean.toString(condition.isConstraint()));
                                    xmlWriter.writeCharacters(condition.getRule());
                                    xmlWriter.writeEndElement();
                                }
                            }
                            if (!(masks = permission.getMasks()).isEmpty()) {
                                for (VdbDataRole.Mask mask : masks) {
                                    xmlWriter.writeStartElement("mask");
                                    xmlWriter.writeAttribute("order", Integer.toString(mask.getOrder()));
                                    xmlWriter.writeCharacters(mask.getRule());
                                    xmlWriter.writeEndElement();
                                }
                            }
                            xmlWriter.writeEndElement();
                        }
                    }
                    if (!(mappedRoles = dataRole.getMappedRoleNames()).isEmpty()) {
                        for (String string : mappedRoles) {
                            xmlWriter.writeStartElement("mapped-role-name");
                            xmlWriter.writeCharacters(string);
                            xmlWriter.writeEndElement();
                        }
                    }
                    xmlWriter.writeEndElement();
                }
            }
            if (!(entries = manifest.getEntries()).isEmpty()) {
                for (VdbEntry entry : entries) {
                    xmlWriter.writeStartElement("entry");
                    xmlWriter.writeAttribute("path", entry.getPath());
                    if (!StringUtil.isBlank((String)entry.getDescription())) {
                        xmlWriter.writeStartElement("description");
                        xmlWriter.writeCharacters(entry.getDescription());
                        xmlWriter.writeEndElement();
                    }
                    if (!(props = entry.getProperties()).isEmpty()) {
                        for (Map.Entry entry2 : props.entrySet()) {
                            this.writePropertyElement(xmlWriter, (String)entry2.getKey(), (String)entry2.getValue());
                        }
                    }
                    xmlWriter.writeEndElement();
                }
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            String xml = stringWriter.toString().trim();
            LOGGER.debug("VDB {0} manifest: \n{1}", new Object[]{vdbNode.getPath(), this.prettyPrint(xml, options)});
            String pretty = this.isPrettyPrint(options) ? this.prettyPrint(xml, options) : xml;
            result.setOutcome((Object)pretty, String.class);
        }
        catch (Exception e) {
            result.setError(null, e);
        }
        finally {
            if (xmlWriter != null) {
                try {
                    xmlWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Node[] findChildrenWithType(Node parentNode, String childType) throws Exception {
        String queryText = String.format(FIND_CHILD_WITH_TYPE, childType, parentNode.getPath());
        Session session = parentNode.getSession();
        QueryManager queryMgr = session.getWorkspace().getQueryManager();
        Query query = queryMgr.createQuery(queryText, "JCR-SQL2");
        QueryResult result = query.execute();
        NodeIterator itr = result.getNodes();
        if (itr.getSize() == 0L) {
            return NO_NODES;
        }
        Node[] children = new Node[(int)itr.getSize()];
        int i = 0;
        while (itr.hasNext()) {
            children[i++] = itr.nextNode();
        }
        return children;
    }

    private Node findNodeByNameAndType(Node parentNode, String groupingNodeName, String groupingNodeType) throws Exception {
        String queryText = String.format(FIND_CHILD_BY_NAME_AND_TYPE, groupingNodeType, parentNode.getPath(), groupingNodeName);
        Session session = parentNode.getSession();
        QueryManager queryMgr = session.getWorkspace().getQueryManager();
        Query query = queryMgr.createQuery(queryText, "JCR-SQL2");
        QueryResult result = query.execute();
        NodeIterator itr = result.getNodes();
        if (itr.getSize() == 0L) {
            return null;
        }
        return itr.nextNode();
    }

    private void writePropertyElement(XMLStreamWriter writer, String propName, String propValue) throws XMLStreamException {
        writer.writeStartElement("property");
        writer.writeAttribute("name", propName);
        writer.writeAttribute("value", propValue);
        writer.writeEndElement();
    }
}

