/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.ddl;

import org.modeshape.common.text.ParsingException;
import org.teiid.modeshape.sequencer.ddl.DdlTokenStream;
import org.teiid.modeshape.sequencer.ddl.StatementParser;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlConstants;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlParser;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlParsingException;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;

final class OptionNamespaceParser
extends StatementParser {
    OptionNamespaceParser(TeiidDdlParser teiidDdlParser) {
        super(teiidDdlParser);
    }

    @Override
    boolean matches(DdlTokenStream tokens) {
        return tokens.matches(TeiidDdlConstants.DdlStatement.OPTION_NAMESPACE.tokens());
    }

    @Override
    AstNode parse(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        if (tokens.canConsume(TeiidDdlConstants.DdlStatement.OPTION_NAMESPACE.tokens())) {
            String uri = this.parseValue(tokens);
            if (tokens.canConsume(TeiidDdlConstants.TeiidReservedWord.AS.toDdl())) {
                String alias = this.parseIdentifier(tokens);
                this.addNamespaceAlias(alias, uri);
                AstNode optionNamespaceNode = this.getNodeFactory().node(alias, parentNode, "teiidddl:optionNamespace");
                optionNamespaceNode.setProperty("teiidddl:uri", (Object)uri);
                return optionNamespaceNode;
            }
        }
        throw new TeiidDdlParsingException(tokens, "Unparsable option namespace statement");
    }

    @Override
    protected void postProcess(AstNode rootNode) {
    }
}

