/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.teiid.modeshape.util.StringUtil;

public class Options {
    public static final int DEFAULT_INDENT_AMOUNT = 4;
    public static final boolean DEFAULT_PRETTY_PRINT = true;
    public static final PropertyFilter DEFAULT_PROPERTY_FILTER = propertyName -> !propertyName.startsWith("dv:") && !propertyName.startsWith("jcr:") && !propertyName.startsWith("jdbc:") && !propertyName.startsWith("med:") && !propertyName.startsWith("mix:") && !propertyName.startsWith("mmcore:") && !propertyName.startsWith("mode:") && !propertyName.startsWith("nt:") && !propertyName.startsWith("relational:") && !propertyName.startsWith("transformation:") && !propertyName.startsWith("vdb:") && !propertyName.startsWith("xmi:");
    private static final Map<String, Object> DEFAULTS = Collections.unmodifiableMap(new HashMap<String, Object>(){
        {
            this.put(Options.INDENT_AMOUNT_PROPERTY, 4);
            this.put(Options.PRETTY_PRINT_PROPERTY, true);
            this.put(Options.PROPERTY_FILTER_PROPERTY, DEFAULT_PROPERTY_FILTER);
        }
    });
    public static final String INDENT_AMOUNT_PROPERTY = "indent-amount";
    public static final String PRETTY_PRINT_PROPERTY = "pretty-print";
    public static final String PROPERTY_FILTER_PROPERTY = "property-filter";
    private final Map<String, Object> options = new HashMap<String, Object>(DEFAULTS);

    public Object get(String name) throws RuntimeException {
        Object value = this.options.get(StringUtil.requireNonEmpty(name, "name"));
        if (value == null) {
            return DEFAULTS.get(name);
        }
        return value;
    }

    public Object get(String name, Object defaultValue) throws RuntimeException {
        Object value = this.options.get(StringUtil.requireNonEmpty(name, "name"));
        return value == null ? Objects.requireNonNull(defaultValue, "defaultValue") : value;
    }

    public Object set(String name, Object value) {
        StringUtil.requireNonEmpty(name, "name");
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            return this.options.remove(name);
        }
        return this.options.put(name, value);
    }

    public String toString() {
        return this.options.toString();
    }

    @FunctionalInterface
    public static interface PropertyFilter {
        public boolean accept(String var1);
    }
}

