/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.internal;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Node;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.StringUtil;
import org.teiid.modeshape.core.CoreI18n;
import org.teiid.modeshape.sequencer.Exporter;
import org.teiid.modeshape.sequencer.Options;
import org.teiid.modeshape.sequencer.Result;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class AbstractExporter
implements Exporter {
    private static final Logger LOGGER = Logger.getLogger(AbstractExporter.class);
    protected static final Node[] NO_NODES = new Node[0];

    protected abstract void doExport(Node var1, Options var2, ResultImpl var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Result execute(Node nodeBeingExported, Options exportOptions) {
        long start = System.currentTimeMillis();
        Options options = exportOptions == null ? new Options() : exportOptions;
        ResultImpl result = null;
        String nodePath = null;
        try {
            nodePath = Objects.requireNonNull(nodeBeingExported, "nodeBeingExported").getPath();
            result = new ResultImpl(nodePath, options);
        }
        catch (Exception e) {
            if (result == null) {
                result = new ResultImpl();
            }
            result.setError(CoreI18n.errorConstructingExportResult.text(new Object[]{this.getClass().getName()}), e);
            return result;
        }
        try {
            LOGGER.debug("Starting export of node {0} by exporter {1}", new Object[]{nodePath, this.getClass().getSimpleName()});
            this.doExport(nodeBeingExported, options, result);
        }
        catch (Exception e) {
            try {
                result.setError(CoreI18n.errorDuringExport.text(new Object[]{this.getClass().getName()}), e);
            }
            catch (Throwable throwable) {
                LOGGER.debug("Finished export of node {0} by exporter {1} in {2}ms and success = {3}", new Object[]{nodePath == null ? "null node path" : nodePath, this.getClass().getSimpleName(), System.currentTimeMillis() - start, result.wasSuccessful()});
                throw throwable;
            }
            LOGGER.debug("Finished export of node {0} by exporter {1} in {2}ms and success = {3}", new Object[]{nodePath == null ? "null node path" : nodePath, this.getClass().getSimpleName(), System.currentTimeMillis() - start, result.wasSuccessful()});
        }
        LOGGER.debug("Finished export of node {0} by exporter {1} in {2}ms and success = {3}", new Object[]{nodePath == null ? "null node path" : nodePath, this.getClass().getSimpleName(), System.currentTimeMillis() - start, result.wasSuccessful()});
        return result;
    }

    protected String getIndentAmount(Options options) {
        assert (options != null);
        Object value = options.get("indent-amount", 4);
        if (!(value instanceof Integer)) {
            return Integer.toString(4);
        }
        return Integer.toString((Integer)value);
    }

    protected Options.PropertyFilter getPropertyFilter(Options options) {
        assert (options != null);
        Object value = options.get("property-filter", Options.DEFAULT_PROPERTY_FILTER);
        if (!(value instanceof Options.PropertyFilter)) {
            return Options.DEFAULT_PROPERTY_FILTER;
        }
        return (Options.PropertyFilter)value;
    }

    protected boolean isPrettyPrint(Options options) {
        assert (options != null);
        Object value = options.get("pretty-print", true);
        if (!(value instanceof Boolean)) {
            return true;
        }
        return (Boolean)value;
    }

    protected Document parseXmlFile(String xml) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xml));
        return db.parse(is);
    }

    protected String prettyPrint(String xml, Options options) throws Exception {
        assert (options != null);
        Document document = this.parseXmlFile(xml);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", this.getIndentAmount(options));
        DOMSource source = new DOMSource(document);
        StringWriter output = new StringWriter();
        StreamResult result = new StreamResult(output);
        transformer.transform(source, result);
        return output.toString();
    }

    protected class ResultImpl
    implements Result {
        public static final String EXPORTER = "exporter.exporter";
        public static final String OPTIONS = "exporter.options";
        public static final String OUTCOME = "exporter.outcome";
        public static final String PATH_EXPORTED_NODE = "exporter.exported-node-path";
        public static final String TYPE = "exporter.outcome-type";
        private final Map<String, Object> data = new HashMap<String, Object>();
        private Exception error = null;
        private String errorMsg = null;
        private Class<?> type = null;

        protected ResultImpl() {
            this.data.put(EXPORTER, this.getClass().getName());
        }

        protected ResultImpl(String pathOfExportedNode, Options options) {
            this();
            this.data.put(PATH_EXPORTED_NODE, pathOfExportedNode);
            this.data.put(OPTIONS, options);
        }

        @Override
        public Object getData(String key) {
            return this.data.get(key);
        }

        @Override
        public Exception getError() {
            return this.error;
        }

        @Override
        public String getErrorMessage() {
            if (StringUtil.isBlank((String)this.errorMsg)) {
                return this.error == null ? null : this.error.getLocalizedMessage();
            }
            return this.errorMsg;
        }

        @Override
        public Options getOptions() {
            return (Options)this.data.get(OPTIONS);
        }

        @Override
        public Object getOutcome() {
            return this.data.get(OUTCOME);
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public Iterator<String> iterator() {
            return this.data.keySet().iterator();
        }

        public Object setData(String key, Object value) {
            if (EXPORTER.equals(key) || OPTIONS.equals(org.teiid.modeshape.util.StringUtil.requireNonEmpty(key, "key")) || PATH_EXPORTED_NODE.equals(key) || TYPE.equals(key)) {
                throw new RuntimeException(CoreI18n.unmodifiableResultData.text(new Object[]{key}));
            }
            if (value == null) {
                return this.data.remove(key);
            }
            return this.data.put(key, value);
        }

        public void setError(String message, Exception error) {
            this.error = error;
            this.errorMsg = message;
        }

        public void setOutcome(Object outcome, Class<?> outcomeType) {
            this.data.put(OUTCOME, Objects.requireNonNull(outcome, "outcome"));
            this.type = Objects.requireNonNull(outcomeType, "outcomeType");
        }

        @Override
        public boolean wasSuccessful() {
            return this.error == null && StringUtil.isBlank((String)this.errorMsg);
        }
    }
}

