/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.ddl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.teiid.modeshape.sequencer.ddl.DdlParser;
import org.teiid.modeshape.sequencer.ddl.DdlParsers;
import org.teiid.modeshape.sequencer.ddl.DdlSequencer;
import org.teiid.modeshape.sequencer.ddl.TeiidDdlParser;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;

public class TeiidDdlSequencer
extends DdlSequencer {
    private static final String[] GRAMMARS = new String[]{"TEIID"};

    @Override
    protected DdlParsers createParsers(List<DdlParser> parsers) {
        return super.createParsers(this.getParserList());
    }

    @Override
    public String[] getGrammars() {
        return GRAMMARS;
    }

    @Override
    protected List<DdlParser> getParserList() {
        return Collections.singletonList(new TeiidDdlParser());
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        URL standardDdlCndUrl = ((Object)((Object)this)).getClass().getResource("/org/teiid/modeshape/sequencer/ddl/StandardDdl.cnd");
        this.registerNodeTypes(standardDdlCndUrl.openStream(), nodeTypeManager, true);
        URL teiidDdlCndUrl = ((Object)((Object)this)).getClass().getResource("/org/teiid/modeshape/sequencer/ddl/TeiidDdl.cnd");
        this.registerNodeTypes(teiidDdlCndUrl.openStream(), nodeTypeManager, true);
    }

    @Override
    protected void preProcess(AstNode astNode, Node parentNode) throws RepositoryException {
        if (astNode.hasMixin("teiidddl:optionNamespace")) {
            NamespaceRegistry registry = parentNode.getSession().getWorkspace().getNamespaceRegistry();
            String uri = astNode.getProperty("teiidddl:uri").toString();
            registry.registerNamespace(astNode.getName(), uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sequenceDdl(String ddl, Node outputNode) throws Exception {
        ByteArrayInputStream ddlStream = new ByteArrayInputStream(ddl.getBytes());
        Binary binary = outputNode.getSession().getValueFactory().createBinary((InputStream)ddlStream);
        Property temp = outputNode.setProperty("ddlStream", binary);
        try {
            if (!this.execute(temp, outputNode, null)) {
                throw new Exception("Error sequencing DDL: " + ddl);
            }
        }
        finally {
            temp.remove();
        }
    }

    @Override
    public void setGrammars(String[] grammarNamesOrClasses) {
    }
}

