/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer.ddl.datatype;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.ParsingException;
import org.teiid.modeshape.sequencer.ddl.DdlConstants;
import org.teiid.modeshape.sequencer.ddl.DdlTokenStream;
import org.teiid.modeshape.sequencer.ddl.datatype.DataType;
import org.teiid.modeshape.sequencer.ddl.node.AstNode;

public class DataTypeParser
implements DdlConstants {
    private static Logger LOGGER = Logger.getLogger(DataTypeParser.class);
    private static List<String[]> basicCharStringTypes = new ArrayList<String[]>();
    private static List<String[]> basicNationalCharStringTypes = new ArrayList<String[]>();
    private static List<String[]> basicBitStringTypes = new ArrayList<String[]>();
    private static List<String[]> basicExactNumericTypes = new ArrayList<String[]>();
    private static List<String[]> basicApproxNumericStringTypes = new ArrayList<String[]>();
    private static List<String[]> basicDateTimeTypes = new ArrayList<String[]>();
    private static List<String[]> basicMiscTypes = new ArrayList<String[]>();
    private int defaultLength = 255;
    private int defaultPrecision = 0;
    private int defaultScale = 0;

    public DataTypeParser() {
        this.initialize();
    }

    private void initialize() {
        basicCharStringTypes.add(DdlConstants.DataTypes.DTYPE_CHARACTER);
        basicCharStringTypes.add(DdlConstants.DataTypes.DTYPE_CHAR);
        basicCharStringTypes.add(DdlConstants.DataTypes.DTYPE_CHARACTER_VARYING);
        basicCharStringTypes.add(DdlConstants.DataTypes.DTYPE_CHAR_VARYING);
        basicCharStringTypes.add(DdlConstants.DataTypes.DTYPE_VARCHAR);
        basicNationalCharStringTypes.add(DdlConstants.DataTypes.DTYPE_NCHAR);
        basicNationalCharStringTypes.add(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER);
        basicNationalCharStringTypes.add(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER_VARYING);
        basicNationalCharStringTypes.add(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR);
        basicNationalCharStringTypes.add(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR_VARYING);
        basicNationalCharStringTypes.add(DdlConstants.DataTypes.DTYPE_NCHAR_VARYING);
        basicBitStringTypes.add(DdlConstants.DataTypes.DTYPE_BIT);
        basicBitStringTypes.add(DdlConstants.DataTypes.DTYPE_BIT_VARYING);
        basicExactNumericTypes.add(DdlConstants.DataTypes.DTYPE_NUMERIC);
        basicExactNumericTypes.add(DdlConstants.DataTypes.DTYPE_DEC);
        basicExactNumericTypes.add(DdlConstants.DataTypes.DTYPE_DECIMAL);
        basicExactNumericTypes.add(DdlConstants.DataTypes.DTYPE_INTEGER);
        basicExactNumericTypes.add(DdlConstants.DataTypes.DTYPE_INT);
        basicExactNumericTypes.add(DdlConstants.DataTypes.DTYPE_SMALLINT);
        basicApproxNumericStringTypes.add(DdlConstants.DataTypes.DTYPE_FLOAT);
        basicApproxNumericStringTypes.add(DdlConstants.DataTypes.DTYPE_REAL);
        basicApproxNumericStringTypes.add(DdlConstants.DataTypes.DTYPE_DOUBLE_PRECISION);
        basicDateTimeTypes.add(DdlConstants.DataTypes.DTYPE_DATE);
        basicDateTimeTypes.add(DdlConstants.DataTypes.DTYPE_TIME);
        basicDateTimeTypes.add(DdlConstants.DataTypes.DTYPE_TIMESTAMP);
        basicMiscTypes.add(DdlConstants.DataTypes.DTYPE_INTERVAL);
    }

    public final boolean isDatatype(DdlTokenStream tokens) throws ParsingException {
        for (String[] stmts : basicCharStringTypes) {
            if (!tokens.matches(stmts)) continue;
            return true;
        }
        for (String[] stmts : basicNationalCharStringTypes) {
            if (!tokens.matches(stmts)) continue;
            return true;
        }
        for (String[] stmts : basicBitStringTypes) {
            if (!tokens.matches(stmts)) continue;
            return true;
        }
        for (String[] stmts : basicExactNumericTypes) {
            if (!tokens.matches(stmts)) continue;
            return true;
        }
        for (String[] stmts : basicApproxNumericStringTypes) {
            if (!tokens.matches(stmts)) continue;
            return true;
        }
        for (String[] stmts : basicDateTimeTypes) {
            if (!tokens.matches(stmts)) continue;
            return true;
        }
        for (String[] stmts : basicMiscTypes) {
            if (!tokens.matches(stmts)) continue;
            return true;
        }
        return this.isCustomDataType(tokens);
    }

    private boolean isDatatype(DdlTokenStream tokens, int type) throws ParsingException {
        switch (type) {
            case 0: {
                for (String[] stmts : basicCharStringTypes) {
                    if (!tokens.matches(stmts)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (String[] stmts : basicNationalCharStringTypes) {
                    if (!tokens.matches(stmts)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (String[] stmts : basicBitStringTypes) {
                    if (!tokens.matches(stmts)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (String[] stmts : basicExactNumericTypes) {
                    if (!tokens.matches(stmts)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                for (String[] stmts : basicApproxNumericStringTypes) {
                    if (!tokens.matches(stmts)) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (String[] stmts : basicDateTimeTypes) {
                    if (!tokens.matches(stmts)) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (String[] stmts : basicMiscTypes) {
                    if (!tokens.matches(stmts)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
        return false;
    }

    public DataType parse(DdlTokenStream tokens) throws ParsingException {
        DataType result = null;
        result = this.isDatatype(tokens, 0) ? this.parseCharStringType(tokens) : (this.isDatatype(tokens, 1) ? this.parseNationalCharStringType(tokens) : (this.isDatatype(tokens, 2) ? this.parseBitStringType(tokens) : (this.isDatatype(tokens, 3) ? this.parseExactNumericType(tokens) : (this.isDatatype(tokens, 4) ? this.parseApproxNumericType(tokens) : (this.isDatatype(tokens, 5) ? this.parseDateTimeType(tokens) : (this.isDatatype(tokens, 6) ? this.parseMiscellaneousType(tokens) : this.parseCustomType(tokens)))))));
        if (tokens.canConsume('[')) {
            if (!tokens.canConsume(']')) {
                tokens.consume();
                tokens.consume(']');
            }
            if (tokens.canConsume('[') && !tokens.canConsume(']')) {
                tokens.consume();
                tokens.consume(']');
            }
        }
        return result;
    }

    protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
        DataType dataType = null;
        String typeName = null;
        if (tokens.matches(DdlConstants.DataTypes.DTYPE_VARCHAR)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_VARCHAR);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_VARCHAR);
            long length = this.parseBracketedLong(tokens, dataType);
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_CHAR_VARYING)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_CHAR_VARYING);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_CHAR_VARYING);
            long length = this.parseBracketedLong(tokens, dataType);
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_CHARACTER_VARYING)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_CHARACTER_VARYING);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_CHARACTER_VARYING);
            long length = this.parseBracketedLong(tokens, dataType);
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_CHAR) || tokens.matches(DdlConstants.DataTypes.DTYPE_CHARACTER)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false);
            dataType.setName(typeName);
            long length = this.getDefaultLength();
            if (tokens.matches("(")) {
                length = this.parseBracketedLong(tokens, dataType);
            }
            dataType.setLength(length);
        }
        return dataType;
    }

    protected DataType parseNationalCharStringType(DdlTokenStream tokens) throws ParsingException {
        DataType dataType = null;
        String typeName = null;
        if (tokens.matches(DdlConstants.DataTypes.DTYPE_NCHAR_VARYING)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_NCHAR_VARYING);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_NCHAR_VARYING);
            long length = this.parseBracketedLong(tokens, dataType);
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR_VARYING)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR_VARYING);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR_VARYING);
            long length = this.parseBracketedLong(tokens, dataType);
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER_VARYING)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER_VARYING);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER_VARYING);
            long length = this.parseBracketedLong(tokens, dataType);
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_NCHAR)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_NCHAR);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_NCHAR);
            long length = this.getDefaultLength();
            if (tokens.matches("(")) {
                length = this.parseBracketedLong(tokens, dataType);
            }
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_NATIONAL_CHAR);
            long length = this.getDefaultLength();
            if (tokens.matches("(")) {
                length = this.parseBracketedLong(tokens, dataType);
            }
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_NATIONAL_CHARACTER);
            long length = this.getDefaultLength();
            if (tokens.matches("(")) {
                length = this.parseBracketedLong(tokens, dataType);
            }
            dataType.setLength(length);
        }
        return dataType;
    }

    protected DataType parseBitStringType(DdlTokenStream tokens) throws ParsingException {
        DataType dataType = null;
        String typeName = null;
        if (tokens.matches(DdlConstants.DataTypes.DTYPE_BIT_VARYING)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_BIT_VARYING);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_BIT_VARYING);
            long length = this.parseBracketedLong(tokens, dataType);
            dataType.setLength(length);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_BIT)) {
            typeName = this.getStatementTypeName(DdlConstants.DataTypes.DTYPE_BIT);
            dataType = new DataType(typeName);
            this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_BIT);
            long length = this.getDefaultLength();
            if (tokens.matches("(")) {
                length = this.parseBracketedLong(tokens, dataType);
            }
            dataType.setLength(length);
        }
        return dataType;
    }

    protected DataType parseExactNumericType(DdlTokenStream tokens) throws ParsingException {
        DataType dataType = null;
        String typeName = null;
        if (tokens.matchesAnyOf("INTEGER", new String[]{"INT", "SMALLINT"})) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false);
            dataType.setName(typeName);
        } else if (tokens.matchesAnyOf("NUMERIC", new String[]{"DECIMAL", "DEC"})) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false);
            dataType.setName(typeName);
            int precision = 0;
            int scale = 0;
            if (tokens.matches("(")) {
                this.consume(tokens, dataType, false, "(");
                precision = (int)this.parseLong(tokens, dataType);
                scale = this.canConsume(tokens, dataType, false, ",", new String[0]) ? (int)this.parseLong(tokens, dataType) : this.getDefaultScale();
                this.consume(tokens, dataType, false, ")");
            } else {
                precision = this.getDefaultPrecision();
                scale = this.getDefaultScale();
            }
            dataType.setPrecision(precision);
            dataType.setScale(scale);
        }
        return dataType;
    }

    protected DataType parseApproxNumericType(DdlTokenStream tokens) throws ParsingException {
        DataType dataType = null;
        String typeName = null;
        if (tokens.matches(DdlConstants.DataTypes.DTYPE_REAL)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_REAL);
            dataType.setName(typeName);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_DOUBLE_PRECISION)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_DOUBLE_PRECISION);
            dataType.setName(typeName);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_FLOAT)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_FLOAT);
            dataType.setName(typeName);
            int precision = 0;
            if (tokens.matches("(")) {
                precision = (int)this.parseBracketedLong(tokens, dataType);
            }
            dataType.setPrecision(precision);
        }
        return dataType;
    }

    protected DataType parseDateTimeType(DdlTokenStream tokens) throws ParsingException {
        DataType dataType = null;
        String typeName = null;
        if (tokens.matches(DdlConstants.DataTypes.DTYPE_DATE)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_DATE);
            dataType.setName(typeName);
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_TIME)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_TIME);
            dataType.setName(typeName);
            int precision = 0;
            if (tokens.matches("(")) {
                precision = (int)this.parseBracketedLong(tokens, dataType);
            }
            dataType.setPrecision(precision);
            this.canConsume(tokens, dataType, true, "WITH", "TIME", "ZONE");
        } else if (tokens.matches(DdlConstants.DataTypes.DTYPE_TIMESTAMP)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_TIMESTAMP);
            dataType.setName(typeName);
            int precision = 0;
            if (tokens.matches("(")) {
                precision = (int)this.parseBracketedLong(tokens, dataType);
            }
            dataType.setPrecision(precision);
            this.canConsume(tokens, dataType, true, "WITH", "TIME", "ZONE");
        }
        return dataType;
    }

    protected DataType parseMiscellaneousType(DdlTokenStream tokens) throws ParsingException {
        DataType dataType = null;
        String typeName = null;
        if (tokens.matches(DdlConstants.DataTypes.DTYPE_INTERVAL)) {
            dataType = new DataType();
            typeName = this.consume(tokens, dataType, false, DdlConstants.DataTypes.DTYPE_INTERVAL);
            dataType.setName(typeName);
            if (tokens.matchesAnyOf("YEAR", new String[]{"MONTH", "DAY", "HOUR", "MINUTE"})) {
                this.consume(tokens, dataType, true);
                if (this.canConsume(tokens, dataType, true, "TO", new String[0])) {
                    this.consume(tokens, dataType, true);
                } else if (tokens.matches("(", new String[]{"any value", ")"})) {
                    this.consume(tokens, dataType, true, "(");
                    this.consume(tokens, dataType, true);
                    this.consume(tokens, dataType, true, ")");
                } else {
                    LOGGER.debug("  WARNING:  PROBLEM parsing INTERVAL data type. Check your DDL for incomplete statement.", new Object[0]);
                }
            } else if (this.canConsume(tokens, dataType, true, "SECOND", new String[0])) {
                if (this.canConsume(tokens, dataType, true, "(", new String[0])) {
                    this.consume(tokens, dataType, true);
                    if (this.canConsume(tokens, dataType, true, ",", new String[0])) {
                        this.consume(tokens, dataType, true);
                    }
                    this.canConsume(tokens, dataType, true, ")", new String[0]);
                } else {
                    LOGGER.debug("  WARNING:  PROBLEM parsing INTERVAL data type. Check your DDL for incomplete statement.", new Object[0]);
                }
            } else {
                LOGGER.debug("  WARNING:  PROBLEM parsing INTERVAL data type. Check your DDL for incomplete statement.", new Object[0]);
            }
        }
        return dataType;
    }

    protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
        return null;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(int defaultLength) {
        this.defaultLength = defaultLength;
    }

    public int getDefaultPrecision() {
        return this.defaultPrecision;
    }

    public void setDefaultPrecision(int defaultPrecision) {
        this.defaultPrecision = defaultPrecision;
    }

    public int getDefaultScale() {
        return this.defaultScale;
    }

    public void setDefaultScale(int defaultScale) {
        this.defaultScale = defaultScale;
    }

    protected long parseLong(DdlTokenStream tokens, DataType dataType) {
        String value = this.consume(tokens, dataType, false);
        return this.parseLong(value);
    }

    protected long parseBracketedLong(DdlTokenStream tokens, DataType dataType) {
        this.consume(tokens, dataType, false, "(");
        String value = this.consume(tokens, dataType, false);
        this.consume(tokens, dataType, false, ")");
        return this.parseLong(value);
    }

    protected long parseLong(String value) {
        long factor = 1L;
        if (value.endsWith("K")) {
            factor = 1024L;
        } else if (value.endsWith("M")) {
            factor = 0x100000L;
        } else if (value.endsWith("G")) {
            factor = 0x40000000L;
        }
        if (factor > 1L) {
            value = value.substring(0, value.length() - 1);
        }
        return new BigInteger(value).longValue() * factor;
    }

    protected String consume(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix) throws ParsingException {
        String value = tokens.consume();
        dataType.appendSource(addSpacePrefix, value);
        return value;
    }

    protected String consume(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix, String str) throws ParsingException {
        tokens.consume(str);
        dataType.appendSource(addSpacePrefix, str);
        return str;
    }

    protected String consume(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix, String initialStr, String ... additionalStrs) throws ParsingException {
        tokens.consume(initialStr, additionalStrs);
        StringBuilder value = new StringBuilder(initialStr);
        dataType.appendSource(addSpacePrefix, initialStr);
        for (String str : additionalStrs) {
            value.append(" ").append(str);
            dataType.appendSource(addSpacePrefix, str);
        }
        return value.toString();
    }

    protected String consume(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix, String[] additionalStrs) throws ParsingException {
        tokens.consume(additionalStrs);
        StringBuilder value = new StringBuilder(100);
        int i = 0;
        for (String str : additionalStrs) {
            if (i == 0) {
                value.append(str);
            } else {
                value.append(" ").append(str);
            }
            dataType.appendSource(addSpacePrefix, str);
            ++i;
        }
        return value.toString();
    }

    protected boolean canConsume(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix, String initialStr, String ... additionalStrs) throws ParsingException {
        if (tokens.canConsume(initialStr, additionalStrs)) {
            dataType.appendSource(addSpacePrefix, initialStr);
            for (String str : additionalStrs) {
                dataType.appendSource(addSpacePrefix, str);
            }
            return true;
        }
        return false;
    }

    protected boolean canConsume(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix, String[] additionalStrs) throws ParsingException {
        if (tokens.canConsume(additionalStrs)) {
            for (String str : additionalStrs) {
                dataType.appendSource(addSpacePrefix, str);
            }
            return true;
        }
        return false;
    }

    protected boolean canConsume(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix, int type) throws ParsingException {
        if (tokens.matches(type)) {
            dataType.appendSource(addSpacePrefix, tokens.consume());
            return true;
        }
        return false;
    }

    protected boolean canConsumeAnyOf(DdlTokenStream tokens, DataType dataType, boolean addSpacePrefix, String initialStr, String ... additionalStrs) throws ParsingException {
        if (tokens.canConsume(initialStr)) {
            dataType.appendSource(addSpacePrefix, initialStr);
            return true;
        }
        int n = 0;
        String[] stringArray = additionalStrs;
        int n2 = stringArray.length;
        if (n < n2) {
            String str = stringArray[n];
            dataType.appendSource(addSpacePrefix, str);
            return true;
        }
        return false;
    }

    public String getStatementTypeName(String[] stmtPhrase) {
        StringBuilder sb = new StringBuilder(100);
        for (int i = 0; i < stmtPhrase.length; ++i) {
            if (i == 0) {
                sb.append(stmtPhrase[0]);
                continue;
            }
            sb.append(" ").append(stmtPhrase[i]);
        }
        return sb.toString();
    }

    public void setPropertiesOnNode(AstNode columnNode, DataType datatype) {
        columnNode.setProperty("ddl:datatypeName", (Object)datatype.getName());
        if (datatype.getLength() >= 0L) {
            columnNode.setProperty("ddl:datatypeLength", (Object)datatype.getLength());
        }
        if (datatype.getPrecision() >= 0) {
            columnNode.setProperty("ddl:datatypePrecision", (Object)datatype.getPrecision());
        }
        if (datatype.getScale() >= 0) {
            columnNode.setProperty("ddl:datatypeScale", (Object)datatype.getScale());
        }
        if (datatype.getArrayDimensions() >= 0) {
            columnNode.setProperty("ddl:datatypeArrayDimensions", (Object)datatype.getArrayDimensions());
        }
    }
}

