/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.modeshape.sequencer;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.EventListenerIterator;
import javax.jcr.observation.ObservationManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.LocalEnvironment;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.observation.Event;

public abstract class AbstractSequencerTest {
    protected static ModeShapeEngine _engine;
    protected static final int DEFAULT_WAIT_TIME_SECONDS = 15;
    protected static final String REPO_NAME = "teiid-modeshape-sequencer-test-repository";
    protected static final boolean START_REPO_AUTOMATICALLY = true;
    protected RepositoryConfiguration config;
    protected Environment environment;
    private final Logger logger = Logger.getLogger(this.getClass());
    private ObservationManager observationManager;
    protected JcrRepository repository;
    protected Node rootNode;
    protected JcrSession session;
    protected JcrTools tools;
    private final ConcurrentHashMap<String, CountDownLatch> nodeSequencedLatches = new ConcurrentHashMap();
    private final Map<String, Node> sequencedNodes = new HashMap<String, Node>();
    protected final ConcurrentHashMap<String, Event> sequencingEvents = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CountDownLatch> sequencingFailureLatches = new ConcurrentHashMap();

    @BeforeClass
    public static void createEngine() {
        _engine = new ModeShapeEngine();
        _engine.start();
    }

    protected void addSequencingListeners(JcrSession session) throws RepositoryException {
        this.observationManager.addEventListener((EventListener)new SequencingListener(), 128, null, true, null, null, false);
        this.observationManager.addEventListener((EventListener)new SequencingFailureListener(), 256, null, true, null, null, false);
    }

    @After
    public void afterEach() throws Exception {
        EventListenerIterator it = this.observationManager.getRegisteredEventListeners();
        while (it.hasNext()) {
            this.observationManager.removeEventListener(it.nextEventListener());
        }
        this.stopRepository();
        this.cleanupData();
    }

    @Before
    public void beforeEach() throws Exception {
        this.startRepository();
        this.tools = new JcrTools();
        this.rootNode = this.session.getRootNode();
        this.addSequencingListeners(this.session);
    }

    private void cleanupData() {
        this.sequencedNodes.clear();
        this.sequencingEvents.clear();
        this.nodeSequencedLatches.clear();
        this.sequencingFailureLatches.clear();
    }

    protected Node createNodeWithContentFromFile(String nodeRelativePath, String filePath) throws RepositoryException {
        Node parent = this.rootNode;
        for (String pathSegment : nodeRelativePath.split("/")) {
            parent = parent.addNode(pathSegment);
        }
        Node content = parent.addNode("jcr:content");
        content.setProperty("jcr:data", this.session.getValueFactory().createBinary(this.resourceStream(filePath)));
        this.session.save();
        return parent;
    }

    private RepositoryConfiguration createRepositoryConfiguration(String repositoryName) throws Exception {
        return RepositoryConfiguration.read((InputStream)this.getRepositoryConfigStream(), (String)repositoryName).with(this.environment);
    }

    private void createWaitingLatchIfNecessary(String expectedPath, ConcurrentHashMap<String, CountDownLatch> latchesMap) {
        latchesMap.putIfAbsent(expectedPath, new CountDownLatch(1));
    }

    protected Node getOutputNode(Node parentNode, String relativePath) throws Exception {
        return this.getOutputNode(parentNode, relativePath, 15);
    }

    protected Node getOutputNode(Node parentNode, String relativePath, int waitTimeSeconds) throws Exception {
        String parentNodePath = parentNode.getPath();
        String expectedPath = parentNodePath.endsWith("/") ? parentNodePath + relativePath : parentNodePath + "/" + relativePath;
        return this.getOutputNode(expectedPath, waitTimeSeconds);
    }

    protected Node getOutputNode(String expectedPath, int waitTimeSeconds) throws InterruptedException {
        if (!this.sequencedNodes.containsKey(expectedPath)) {
            this.createWaitingLatchIfNecessary(expectedPath, this.nodeSequencedLatches);
            this.logger.debug("Waiting for sequenced node at: " + expectedPath, new Object[0]);
            CountDownLatch countDownLatch = this.nodeSequencedLatches.get(expectedPath);
            countDownLatch.await(waitTimeSeconds, TimeUnit.SECONDS);
        }
        this.nodeSequencedLatches.remove(expectedPath);
        return this.sequencedNodes.remove(expectedPath);
    }

    protected InputStream getRepositoryConfigStream() {
        return this.resourceStream("config/repo-config.json");
    }

    protected void killRepository(JcrRepository repository) {
        try {
            if (repository.getState() != ModeShapeEngine.State.RUNNING) {
                return;
            }
            _engine.undeploy(REPO_NAME);
        }
        catch (Throwable t) {
            this.logger.error((I18nResource)JcrI18n.errorKillingRepository, new Object[]{repository.getName(), t.getMessage()});
        }
    }

    protected void registerNodeTypes(String resourceName) throws RepositoryException, IOException {
        InputStream stream = this.resourceStream(resourceName);
        Assert.assertThat((Object)stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        JcrWorkspace workspace = this.session.getWorkspace();
        NodeTypeManager ntMgr = (NodeTypeManager)workspace.getNodeTypeManager();
        ntMgr.registerNodeTypes(stream, true);
    }

    protected InputStream resourceStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    protected void smokeCheckSequencingEvent(Event event, int expectedEventType, String ... expectedEventInfoKeys) throws RepositoryException {
        Assert.assertEquals((long)event.getType(), (long)expectedEventType);
        Map info = event.getInfo();
        Assert.assertNotNull((Object)info);
        for (String extraInfoKey : expectedEventInfoKeys) {
            Assert.assertNotNull(info.get(extraInfoKey));
        }
    }

    protected void startRepository() throws Exception {
        this.environment = new LocalEnvironment();
        this.config = this.createRepositoryConfiguration(REPO_NAME);
        this.repository = _engine.deploy(this.config);
        this.session = this.repository.login();
        this.observationManager = this.session.getWorkspace().getObservationManager();
    }

    protected void stopRepository() throws Exception {
        try {
            try {
                if (this.session != null && this.session.isLive()) {
                    this.session.logout();
                }
            }
            finally {
                this.killRepository(this.repository);
            }
        }
        finally {
            this.repository = null;
            this.config = null;
            this.environment.shutdown();
            this.environment = null;
        }
    }

    protected final class SequencingListener
    implements EventListener {
        protected SequencingListener() {
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                try {
                    Event event = (Event)events.nextEvent();
                    AbstractSequencerTest.this.smokeCheckSequencingEvent(event, 128, "sequencedNodeId", "sequencedNodePath", "outputPath", "selectedPath", "sequencerName", "userId");
                    AbstractSequencerTest.this.sequencingEvents.putIfAbsent((String)event.getInfo().get("sequencedNodePath"), event);
                    String nodePath = event.getPath();
                    AbstractSequencerTest.this.logger.debug("New sequenced node at: " + nodePath, new Object[0]);
                    AbstractSequencerTest.this.sequencedNodes.put(nodePath, AbstractSequencerTest.this.session.getNode(nodePath));
                    AbstractSequencerTest.this.createWaitingLatchIfNecessary(nodePath, AbstractSequencerTest.this.nodeSequencedLatches);
                    ((CountDownLatch)AbstractSequencerTest.this.nodeSequencedLatches.get(nodePath)).countDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected final class SequencingFailureListener
    implements EventListener {
        protected SequencingFailureListener() {
        }

        public void onEvent(EventIterator events) {
            while (events.hasNext()) {
                try {
                    Event event = (Event)events.nextEvent();
                    AbstractSequencerTest.this.smokeCheckSequencingEvent(event, 256, "sequencedNodeId", "sequencedNodePath", "sequencingFailureCause", "outputPath", "selectedPath", "sequencerName", "userId");
                    String nodePath = event.getPath();
                    AbstractSequencerTest.this.sequencingEvents.putIfAbsent(nodePath, event);
                    AbstractSequencerTest.this.createWaitingLatchIfNecessary(nodePath, AbstractSequencerTest.this.sequencingFailureLatches);
                    ((CountDownLatch)AbstractSequencerTest.this.sequencingFailureLatches.get(nodePath)).countDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

