/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiOperation;
import io.swagger.jaxrs.listing.BaseApiListingResource;
import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.teiid.core.util.StringUtil;

@Path(value="/swagger.{type:json|yaml}")
public class CustomApiListingResource
extends BaseApiListingResource {
    @Context
    ServletContext context;

    @GET
    @Produces(value={"application/json", "application/yaml"})
    @ApiOperation(value="The swagger definition in either JSON or YAML", hidden=true)
    public Response getListing(@Context Application app, @Context ServletConfig sc, @Context FilterConfig fc, @Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="type") String type) throws JsonProcessingException {
        sc = this.getConfig(sc, fc);
        if (!StringUtil.isEmpty((String)type) && type.trim().equalsIgnoreCase("yaml")) {
            return this.getListingYamlResponse(app, this.context, sc, headers, uriInfo);
        }
        return this.getListingJsonResponse(app, this.context, sc, headers, uriInfo);
    }

    private ServletConfig getConfig(ServletConfig sc, FilterConfig fc) {
        try {
            sc.getInitParameter("test");
        }
        catch (Exception e) {
            return new ServletConfigWrapper(fc);
        }
        return sc;
    }

    private static class ServletConfigWrapper
    implements ServletConfig {
        private FilterConfig fc;

        public ServletConfigWrapper(FilterConfig fc) {
            this.fc = fc;
        }

        public String getServletName() {
            return this.fc.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.fc.getServletContext();
        }

        public String getInitParameter(String name) {
            return this.fc.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return this.fc.getInitParameterNames();
        }
    }
}

