/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.script.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.teiid.script.io.StringLineReader;

public class ResultSetReader
extends StringLineReader {
    ResultSet source = null;
    int columnCount = 0;
    String delimiter = "    ";
    boolean firstTime = true;
    int[] columnTypes = null;
    private int rowCount;

    public ResultSetReader(ResultSet in) {
        this.source = in;
    }

    public ResultSetReader(ResultSet in, String delimiter) {
        this.source = in;
        this.delimiter = delimiter;
    }

    @Override
    public void close() throws IOException {
        try {
            this.source.close();
            super.close();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected String nextLine() throws IOException {
        try {
            if (this.firstTime) {
                this.firstTime = false;
                ResultSetMetaData metadata = this.source.getMetaData();
                this.columnCount = metadata.getColumnCount();
                this.columnTypes = new int[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    this.columnTypes[i] = metadata.getColumnType(i + 1);
                }
                return ResultSetReader.resultSetMetaDataToString(metadata, this.delimiter);
            }
            if (this.source.next()) {
                ++this.rowCount;
                StringBuffer sb = new StringBuffer();
                for (int col = 1; col <= this.columnCount; ++col) {
                    Object anObj = this.source.getObject(col);
                    if (this.columnTypes[col - 1] == 2005) {
                        sb.append(anObj != null ? this.source.getString(col) : "null");
                    } else if (this.columnTypes[col - 1] == 2004) {
                        sb.append(anObj != null ? "BLOB" : "null");
                    } else if (this.columnTypes[col - 1] == 2009) {
                        SQLXML xml = (SQLXML)anObj;
                        sb.append(anObj != null ? ResultSetReader.prettyPrint(xml) : "null");
                    } else {
                        sb.append(anObj != null ? anObj : "null");
                    }
                    if (col == this.columnCount) continue;
                    sb.append(this.delimiter);
                }
                sb.append("\n");
                return sb.toString();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage());
        }
        return null;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static String resultSetMetaDataToString(ResultSetMetaData metadata, String delimiter) throws SQLException {
        StringBuffer sb = new StringBuffer();
        int columnCount = metadata.getColumnCount();
        for (int col = 1; col <= columnCount; ++col) {
            sb.append(metadata.getColumnName(col)).append("[").append(metadata.getColumnTypeName(col)).append("]");
            if (col == columnCount) continue;
            sb.append(delimiter);
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String prettyPrint(SQLXML xml) throws SQLException {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setAttribute("indent-number", new Integer(2));
            Transformer tf = transFactory.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("method", "xml");
            tf.setOutputProperty("standalone", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult xmlOut = new StreamResult(new BufferedOutputStream(out));
            tf.transform(xml.getSource(StreamSource.class), xmlOut);
            return out.toString();
        }
        catch (Exception e) {
            return xml.getString();
        }
    }
}

