/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.util;

import java.io.InputStream;
import java.io.StringReader;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.stax.StAXSource;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.util.XMLInputStream;

public class TestXMLInputStream {
    @Test
    public void testStreaming() throws Exception {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\"?><root>");
        for (int i = 0; i < 1000; ++i) {
            xmlBuilder.append("<a></a>");
            xmlBuilder.append("<b></b>");
        }
        xmlBuilder.append("</root>");
        String xml = xmlBuilder.toString();
        StAXSource source = new StAXSource(XMLType.getXmlInputFactory().createXMLEventReader(new StringReader(xml)));
        XMLInputStream is = new XMLInputStream(source, XMLOutputFactory.newFactory());
        byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is);
        Assert.assertEquals((Object)xml, (Object)new String(bytes, "UTF-8"));
    }

    @Test
    public void testUTF16Streaming() throws Exception {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("<?xml version=\"1.0\"?><root>");
        for (int i = 0; i < 1000; ++i) {
            xmlBuilder.append("<a></a>");
            xmlBuilder.append("<b></b>");
        }
        xmlBuilder.append("</root>");
        String xml = xmlBuilder.toString();
        StAXSource source = new StAXSource(XMLType.getXmlInputFactory().createXMLEventReader(new StringReader(xml)));
        XMLInputStream is = new XMLInputStream(source, XMLOutputFactory.newFactory(), "UTF-16");
        byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is);
        Assert.assertEquals((Object)xml, (Object)new String(bytes, "UTF-16"));
    }
}

