/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.AggregateAttributes;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;

public class FunctionMethod
extends AbstractMetadataRecord {
    public static final String SYSTEM_NAME = "{http://www.teiid.org/ext/relational/2012}system-name";
    private static final long serialVersionUID = -8039086494296455152L;
    private static final String NOT_ALLOWED = "NOT_ALLOWED";
    private static final String ALLOWED = "ALLOWED";
    private static final String REQUIRED = "REQUIRED";
    private String description;
    private String category;
    private PushDown pushdown = PushDown.CAN_PUSHDOWN;
    private String invocationClass;
    private String invocationMethod;
    private boolean nullOnNull;
    private AggregateAttributes aggregateAttributes;
    private transient Method method;
    private Determinism determinism = Determinism.DETERMINISTIC;
    protected List<FunctionParameter> inParameters = new ArrayList<FunctionParameter>(2);
    private FunctionParameter outputParameter;
    private Schema parent;

    public FunctionMethod() {
    }

    public FunctionMethod(String name, String description, String category, FunctionParameter[] inputParams, FunctionParameter outputParam) {
        this(name, description, category, PushDown.MUST_PUSHDOWN, null, null, inputParams != null ? Arrays.asList(inputParams) : null, outputParam, true, Determinism.DETERMINISTIC);
    }

    public FunctionMethod(String name, String description, String category, PushDown pushdown, String invocationClass, String invocationMethod, List<FunctionParameter> inputParams, FunctionParameter outputParam, boolean nullOnNull, Determinism deterministic) {
        this.setName(name);
        this.setDescription(description);
        this.setCategory(category);
        this.setPushdown(pushdown);
        this.setInvocationClass(invocationClass);
        this.setInvocationMethod(invocationMethod);
        this.setInputParameters(inputParams);
        this.setOutputParameter(outputParam);
        this.setNullOnNull(nullOnNull);
        this.setDeterminism(deterministic);
    }

    public FunctionMethod(String name, String description, String category, String invocationClass, String invocationMethod, FunctionParameter[] inputParams, FunctionParameter outputParam) {
        this(name, description, category, PushDown.CAN_PUSHDOWN, invocationClass, invocationMethod, inputParams != null ? Arrays.asList(inputParams) : null, outputParam, true, Determinism.DETERMINISTIC);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public PushDown getPushdown() {
        return this.pushdown;
    }

    public void setPushdown(PushDown pushdown) {
        this.pushdown = pushdown;
    }

    public void setPushDown(String pushdown) {
        if (pushdown != null) {
            if (pushdown.equals(REQUIRED)) {
                this.pushdown = PushDown.MUST_PUSHDOWN;
            } else if (pushdown.equals(ALLOWED)) {
                this.pushdown = PushDown.CAN_PUSHDOWN;
            } else if (pushdown.equals(NOT_ALLOWED)) {
                this.pushdown = PushDown.CANNOT_PUSHDOWN;
            }
        } else {
            this.pushdown = PushDown.CAN_PUSHDOWN;
        }
    }

    public String getInvocationClass() {
        return this.invocationClass;
    }

    public void setInvocationClass(String invocationClass) {
        this.invocationClass = invocationClass;
    }

    public String getInvocationMethod() {
        return this.invocationMethod;
    }

    public void setInvocationMethod(String invocationMethod) {
        this.invocationMethod = invocationMethod;
    }

    public int getInputParameterCount() {
        if (this.inParameters == null) {
            return 0;
        }
        return this.inParameters.size();
    }

    public List<FunctionParameter> getInputParameters() {
        return this.inParameters;
    }

    public void setInputParameters(List<FunctionParameter> params) {
        this.inParameters.clear();
        if (params != null) {
            for (FunctionParameter param : params) {
                param.setParent(this);
                this.inParameters.add(param);
            }
        }
    }

    public FunctionParameter getOutputParameter() {
        return this.outputParameter;
    }

    public void setOutputParameter(FunctionParameter param) {
        if (param != null) {
            param.setName("result");
            param.setParent(this);
        }
        this.outputParameter = param;
    }

    @Override
    public int hashCode() {
        int hash = HashCodeUtil.hashCode((int)0, (Object[])new Object[]{super.getName()});
        if (this.inParameters != null) {
            hash = HashCodeUtil.hashCode((int)hash, (int)this.inParameters.hashCode());
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FunctionMethod) {
            FunctionMethod other = (FunctionMethod)obj;
            if (this.getInputParameterCount() != other.getInputParameterCount()) {
                return false;
            }
            if (!EquivalenceUtil.areEqual((Object)this.parent, (Object)other.getParent())) {
                return false;
            }
            if (!other.getName().equalsIgnoreCase(this.getName())) {
                return false;
            }
            List<FunctionParameter> thisInputs = this.getInputParameters();
            if (thisInputs != null && thisInputs.size() > 0) {
                List<FunctionParameter> otherInputs = other.getInputParameters();
                for (int i = 0; i < thisInputs.size(); ++i) {
                    boolean paramMatch = EquivalenceUtil.areEqual((Object)thisInputs.get(i), (Object)otherInputs.get(i));
                    if (paramMatch) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.getName() != null) {
            str.append(this.getName());
        } else {
            str.append("<unknown>");
        }
        str.append("(");
        if (this.inParameters != null) {
            for (int i = 0; i < this.inParameters.size(); ++i) {
                if (this.inParameters.get(i) != null) {
                    str.append(this.inParameters.get(i).toString());
                } else {
                    str.append("<unknown>");
                }
                if (i >= this.inParameters.size() - 1) continue;
                str.append(", ");
            }
        }
        str.append(") : ");
        if (this.outputParameter != null) {
            str.append(this.outputParameter.toString());
        } else {
            str.append("<unknown>");
        }
        return str.toString();
    }

    public boolean isNullOnNull() {
        return this.nullOnNull;
    }

    public void setNullOnNull(boolean nullOnNull) {
        this.nullOnNull = nullOnNull;
    }

    public Determinism getDeterminism() {
        return this.determinism;
    }

    public void setDeterministicBoolean(boolean deterministic) {
        this.determinism = deterministic ? Determinism.DETERMINISTIC : Determinism.NONDETERMINISTIC;
    }

    public void setDeterminism(Determinism determinism) {
        this.determinism = determinism;
    }

    public boolean isVarArgs() {
        if (this.inParameters != null && this.inParameters.size() > 0) {
            return this.inParameters.get(this.inParameters.size() - 1).isVarArg();
        }
        return false;
    }

    public boolean setVarArgs(boolean varargs) {
        if (this.inParameters != null && this.inParameters.size() > 0) {
            this.inParameters.get(this.inParameters.size() - 1).setVarArg(varargs);
            return true;
        }
        return false;
    }

    public void setParent(Schema parent) {
        this.parent = parent;
    }

    @Override
    public Schema getParent() {
        return this.parent;
    }

    public AggregateAttributes getAggregateAttributes() {
        return this.aggregateAttributes;
    }

    public void setAggregateAttributes(AggregateAttributes aggregateAttributes) {
        this.aggregateAttributes = aggregateAttributes;
    }

    public static FunctionMethod createFunctionMethod(String name, String description, String category, String returnType, String ... paramTypes) {
        FunctionParameter[] params = new FunctionParameter[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = new FunctionParameter("param" + (i + 1), paramTypes[i]);
        }
        FunctionMethod method = new FunctionMethod(name, description, category, params, new FunctionParameter("result", returnType));
        method.setNameInSource(name);
        return method;
    }

    public static void convertExtensionMetadata(Procedure procedureRecord, FunctionMethod function) {
        String deterministic = procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}deterministic", true);
        boolean nullOnNull = Boolean.valueOf(procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}null-on-null", true));
        String varargs = procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}varargs", true);
        String javaClass = procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}java-class", true);
        String javaMethod = procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}java-method", true);
        if (function.getInvocationClass() == null) {
            function.setInvocationClass(javaClass);
        }
        if (function.getInvocationMethod() == null) {
            function.setInvocationMethod(javaMethod);
        }
        if (!procedureRecord.getParameters().isEmpty()) {
            function.setProperties(procedureRecord.getProperties());
        }
        boolean aggregate = Boolean.valueOf(procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}aggregate", true));
        if (deterministic != null) {
            function.setDeterminism(Boolean.valueOf(deterministic) != false ? Determinism.DETERMINISTIC : Determinism.NONDETERMINISTIC);
        }
        function.setNullOnNull(nullOnNull);
        if (varargs != null && !function.getInputParameters().isEmpty()) {
            function.getInputParameters().get(function.getInputParameterCount() - 1).setVarArg(Boolean.valueOf(varargs));
        }
        if (aggregate) {
            boolean analytic = Boolean.valueOf(procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}analytic", true));
            boolean allowsOrderBy = Boolean.valueOf(procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}allows-orderby", true));
            boolean usesDistinctRows = Boolean.valueOf(procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}uses-distinct-rows", true));
            boolean allowsDistinct = Boolean.valueOf(procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}allows-distinct", true));
            boolean decomposable = Boolean.valueOf(procedureRecord.getProperty("{http://www.teiid.org/ext/relational/2012}decomposable", true));
            AggregateAttributes aa = new AggregateAttributes();
            aa.setAnalytic(analytic);
            aa.setAllowsOrderBy(allowsOrderBy);
            aa.setUsesDistinctRows(usesDistinctRows);
            aa.setAllowsDistinct(allowsDistinct);
            aa.setDecomposable(decomposable);
            function.setAggregateAttributes(aa);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public static enum Determinism {
        NONDETERMINISTIC,
        COMMAND_DETERMINISTIC,
        SESSION_DETERMINISTIC,
        USER_DETERMINISTIC,
        VDB_DETERMINISTIC,
        DETERMINISTIC;

    }

    public static enum PushDown {
        CAN_PUSHDOWN,
        CANNOT_PUSHDOWN,
        MUST_PUSHDOWN,
        SYNTHETIC;

    }
}

