/*
 * Copyright Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags and
 * the COPYRIGHT.txt file distributed with this work.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.teiid.language;

import java.util.List;

import org.teiid.language.visitor.LanguageObjectVisitor;

/**
 * Represents a GROUP BY clause in a query.
 */
public class GroupBy extends BaseLanguageObject {

    private List<Expression> elements;
    private boolean rollup;
    
    public GroupBy(List<Expression> elements) {
        this.elements = elements;
    }
    
    /**
     * Get list of IExpression that the GROUP BY should be grouped on.
     * @return List of IExpression
     */
    public List<Expression> getElements() {
        return elements;
    }

    public void acceptVisitor(LanguageObjectVisitor visitor) {
        visitor.visit(this);
    }

    public void setElements(List<Expression> elements) {
        this.elements = elements;
    }
    
    public boolean isRollup() {
		return rollup;
	}
    
    public void setRollup(boolean rollup) {
		this.rollup = rollup;
	}

}
