/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language;

import java.util.List;
import org.teiid.language.BaseLanguageObject;
import org.teiid.language.Command;
import org.teiid.language.DerivedColumn;
import org.teiid.language.InsertValueSource;
import org.teiid.language.Limit;
import org.teiid.language.OrderBy;
import org.teiid.language.Select;
import org.teiid.language.With;

public abstract class QueryExpression
extends BaseLanguageObject
implements Command,
InsertValueSource {
    private OrderBy orderBy;
    private Limit limit;
    private With with;

    public abstract Select getProjectedQuery();

    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public String[] getColumnNames() {
        List<DerivedColumn> selectSymbols = this.getProjectedQuery().getDerivedColumns();
        String[] columnNames = new String[selectSymbols.size()];
        int symbolIndex = 0;
        for (DerivedColumn column : selectSymbols) {
            columnNames[symbolIndex++] = column.getAlias();
        }
        return columnNames;
    }

    public Class<?>[] getColumnTypes() {
        List<DerivedColumn> selectSymbols = this.getProjectedQuery().getDerivedColumns();
        Class[] columnTypes = new Class[selectSymbols.size()];
        int symbolIndex = 0;
        for (DerivedColumn column : selectSymbols) {
            columnTypes[symbolIndex++] = column.getExpression().getType();
        }
        return columnTypes;
    }

    public void setOrderBy(OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public With getWith() {
        return this.with;
    }

    public void setWith(With with) {
        this.with = with;
    }
}

