/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.spi;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.ConnectionContext;
import org.teiid.resource.spi.WrappedConnection;

public class BasicManagedConnection
implements ManagedConnection {
    protected PrintWriter log;
    protected final Collection<ConnectionEventListener> listeners = new ArrayList<ConnectionEventListener>();
    private BasicConnection physicalConnection;
    private final Set<WrappedConnection> handles = new HashSet<WrappedConnection>();

    public BasicManagedConnection(BasicConnection connection) {
        this.physicalConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object handle) throws ResourceException {
        if (!(handle instanceof WrappedConnection)) {
            throw new ResourceException("Wrong connection supplied to assosiate");
        }
        ((WrappedConnection)handle).setManagedConnection(this);
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add((WrappedConnection)handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            for (WrappedConnection wc : this.handles) {
                wc.setManagedConnection(null);
            }
            this.handles.clear();
        }
        if (this.physicalConnection != null) {
            this.physicalConnection.cleanUp();
        }
        ConnectionContext.setSubject(null);
    }

    public void destroy() throws ResourceException {
        this.cleanup();
        this.physicalConnection.close();
        this.physicalConnection = null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject arg0, ConnectionRequestInfo arg1) throws ResourceException {
        ConnectionContext.setSubject(arg0);
        WrappedConnection wc = new WrappedConnection(this);
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add(wc);
        }
        return wc;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return null;
    }

    public XAResource getXAResource() throws ResourceException {
        return this.physicalConnection.getXAResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener arg0) {
        Collection<ConnectionEventListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(arg0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener arg0) {
        Collection<ConnectionEventListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(arg0);
        }
    }

    public void setLogWriter(PrintWriter arg0) throws ResourceException {
        this.log = arg0;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(WrappedConnection wc) {
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.remove(wc);
        }
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1);
        ce.setConnectionHandle((Object)wc);
        ArrayList<ConnectionEventListener> copy = null;
        Collection<ConnectionEventListener> collection = this.listeners;
        synchronized (collection) {
            copy = new ArrayList<ConnectionEventListener>(this.listeners);
        }
        for (ConnectionEventListener l : copy) {
            l.connectionClosed(ce);
        }
    }

    Connection getConnection() throws ResourceException {
        if (this.physicalConnection == null) {
            throw new ResourceException("Connection has been destroyed!!!");
        }
        return this.physicalConnection;
    }

    public boolean isValid() {
        if (this.physicalConnection == null) {
            return false;
        }
        return this.physicalConnection.isAlive();
    }
}

