/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;

public class FullyQualifiedName {
    public static final String SEPARATOR = "/";
    private StringBuilder builder = new StringBuilder();

    public FullyQualifiedName() {
    }

    public FullyQualifiedName(String name, String value) {
        this.append(name, value);
    }

    public FullyQualifiedName append(String name, String value) {
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)value);
        if (this.builder.length() > 0) {
            this.builder.append(SEPARATOR);
        }
        try {
            this.builder.append(URLEncoder.encode(name, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }
}

