/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stax.StAXSource;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.AccessibleByteArrayOutputStream;

public class XMLInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 8192;
    private int pos = 0;
    private AccessibleByteArrayOutputStream baos = new AccessibleByteArrayOutputStream(8192);
    private XMLEventReader reader;
    private XMLEventWriter writer;

    public XMLInputStream(StAXSource source, XMLOutputFactory outFactory) throws XMLStreamException {
        this(source, outFactory, "UTF-8");
    }

    public XMLInputStream(StAXSource source, XMLOutputFactory outFactory, String encoding) throws XMLStreamException {
        this.reader = source.getXMLEventReader();
        if (this.reader == null) {
            this.reader = XMLType.getXmlInputFactory().createXMLEventReader(source.getXMLStreamReader());
        }
        this.writer = outFactory.createXMLEventWriter((OutputStream)this.baos, encoding);
    }

    @Override
    public int read() throws IOException {
        while (this.pos >= this.baos.getCount()) {
            if (!this.reader.hasNext()) {
                return -1;
            }
            if (this.baos.getCount() > 8192) {
                this.baos.setCount(0);
                this.pos = 0;
            }
            try {
                XMLEvent event = this.reader.nextEvent();
                this.writer.add(event);
                this.writer.flush();
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }
        return 0xFF & this.baos.getBuffer()[this.pos++];
    }

    @Override
    public void close() throws IOException {
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }
}

