/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;

public class TestMetadataFactory {
    @Test
    public void testSchemaProperties() {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("foo");
        mmd.addProperty("teiid_rel:data-ttl", "1");
        MetadataFactory mf = new MetadataFactory("x", (Object)1, Collections.EMPTY_MAP, mmd);
        Schema s = mf.getSchema();
        Assert.assertEquals((Object)"foo", (Object)s.getName());
        String val = s.getProperty("{http://www.teiid.org/ext/relational/2012}data-ttl", false);
        Assert.assertEquals((Object)"1", (Object)val);
    }

    @Test
    public void testCreateFunction() throws NoSuchMethodException, SecurityException {
        FunctionMethod fm = MetadataFactory.createFunctionFromMethod((String)"x", (Method)TestMetadataFactory.class.getMethod("someFunction", new Class[0]));
        Assert.assertEquals(Boolean.class, (Object)fm.getOutputParameter().getJavaType());
        fm = MetadataFactory.createFunctionFromMethod((String)"x", (Method)TestMetadataFactory.class.getMethod("someArrayFunction", new Class[0]));
        Assert.assertEquals(String[].class, (Object)fm.getOutputParameter().getJavaType());
    }

    @Test
    public void testCreateAggregateFunction() throws NoSuchMethodException, SecurityException {
        FunctionMethod fm = MetadataFactory.createFunctionFromMethod((String)"x", (Method)MyUDAF.class.getMethod("addInput", String.class));
        Assert.assertEquals(Boolean.class, (Object)fm.getOutputParameter().getJavaType());
        Assert.assertNotNull((Object)fm.getAggregateAttributes());
    }

    @Test
    public void testCorrectName() {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("foo");
        HashMap<String, Datatype> types = new HashMap<String, Datatype>();
        Datatype value = new Datatype();
        value.setName("string");
        types.put("string", value);
        MetadataFactory factory = new MetadataFactory("x", (Object)1, types, mmd);
        Table x = factory.addTable("x");
        Column c = factory.addColumn("a.b", "string", (ColumnSet)x);
        Assert.assertEquals((Object)"a_b", (Object)c.getName());
    }

    @Test
    public void testDuplicateColumns() {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("foo");
        mmd.addProperty("importer.renameDuplicateColumns", "true");
        HashMap<String, Datatype> types = new HashMap<String, Datatype>();
        Datatype value = new Datatype();
        value.setName("string");
        types.put("string", value);
        MetadataFactory factory = new MetadataFactory("x", (Object)1, types, mmd);
        Table x = factory.addTable("x");
        Column c = factory.addColumn("a_b", "string", (ColumnSet)x);
        Assert.assertEquals((Object)"a_b", (Object)c.getName());
        c = factory.addColumn("a_B", "string", (ColumnSet)x);
        Assert.assertEquals((Object)"a_B_1", (Object)c.getName());
    }

    @Test
    public void testDuplicateTables() {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("foo");
        mmd.addProperty("importer.renameDuplicateTables", "true");
        HashMap<String, Datatype> types = new HashMap<String, Datatype>();
        Datatype value = new Datatype();
        value.setName("string");
        types.put("string", value);
        MetadataFactory factory = new MetadataFactory("x", (Object)1, types, mmd);
        Table x = factory.addTable("x");
        Assert.assertEquals((Object)"x", (Object)x.getName());
        Table x1 = factory.addTable("X");
        Assert.assertEquals((Object)"X_1", (Object)x1.getName());
        Table x2 = factory.addTable("X");
        Assert.assertEquals((Object)"X_2", (Object)x2.getName());
    }

    @Test
    public void testDuplicateProcedure() {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("foo");
        mmd.addProperty("importer.renameAllDuplicates", "true");
        HashMap<String, Datatype> types = new HashMap<String, Datatype>();
        Datatype value = new Datatype();
        value.setName("string");
        types.put("string", value);
        MetadataFactory factory = new MetadataFactory("x", (Object)1, types, mmd);
        Procedure x = factory.addProcedure("x");
        Assert.assertEquals((Object)"x", (Object)x.getName());
        Procedure x1 = factory.addProcedure("X");
        Assert.assertEquals((Object)"X_1", (Object)x1.getName());
        Procedure x2 = factory.addProcedure("X");
        Assert.assertEquals((Object)"X_2", (Object)x2.getName());
    }

    public static boolean someFunction() {
        return true;
    }

    public static String[] someArrayFunction() {
        return null;
    }

    @Test
    public void testNameFormat() {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("foo");
        mmd.addProperty("importer.nameFormat", "x_%s_y");
        HashMap types = new HashMap();
        MetadataFactory factory = new MetadataFactory("x", (Object)1, types, mmd);
        Table x = factory.addTable("x");
        Assert.assertEquals((Object)"x_x_y", (Object)x.getName());
        Procedure p = factory.addProcedure("a%b.c");
        Assert.assertEquals((Object)"x_a%b.c_y", (Object)p.getName());
    }

    public static class MyUDAF
    implements UserDefinedAggregate<Boolean> {
        public Boolean getResult(CommandContext commandContext) {
            return null;
        }

        public void reset() {
        }

        public void addInput(String val) {
        }
    }
}

